/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.intermediate;

import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class CalculateGraphSize
implements ILayoutProcessor<ElkNode> {
    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        double minXPos = Double.MAX_VALUE;
        double minYPos = Double.MAX_VALUE;
        double maxXPos = Double.MIN_VALUE;
        double maxYPos = Double.MIN_VALUE;
        for (ElkNode node : graph.getChildren()) {
            double posX = node.getX();
            double posY = node.getY();
            double width = node.getWidth();
            double height = node.getHeight();
            ElkMargin margins = (ElkMargin)node.getProperty(CoreOptions.MARGINS);
            minXPos = Math.min(minXPos, posX - margins.left);
            minYPos = Math.min(minYPos, posY - margins.top);
            maxXPos = Math.max(maxXPos, posX + width + margins.right);
            maxYPos = Math.max(maxYPos, posY + height + margins.bottom);
        }
        ElkPadding padding = (ElkPadding)graph.getProperty(CoreOptions.PADDING);
        KVector offset = new KVector(minXPos - padding.getLeft(), minYPos - padding.getTop());
        for (ElkNode node : graph.getChildren()) {
            node.setX(node.getX() - offset.x);
            node.setY(node.getY() - offset.y);
        }
        double width = maxXPos - minXPos + padding.getHorizontal();
        double height = maxYPos - minYPos + padding.getVertical();
        graph.setWidth(width);
        graph.setHeight(height);
    }
}

