/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.layouter.preferences;

import org.eclipse.elk.alg.graphviz.layouter.preferences.GraphvizLayouterPreferenceStore;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GraphvizPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.elk.alg.graphviz.preferences";

    public GraphvizPreferencePage() {
        super(1);
        this.setDescription("Controls how the Eclipse Layout Kernel interacts with the Graphviz layout tools. The Graphviz layout tools are available at http://www.graphviz.org/. If the 'dot' executable cannot be found in default locations, its path must be entered here.");
    }

    public void createFieldEditors() {
        Composite executableEditorParent = this.getFieldEditorParent();
        FileFieldEditor executableEditor = new FileFieldEditor("graphviz.executable", "Path to 'dot' executable:", executableEditorParent);
        executableEditor.setValidateStrategy(0);
        this.addField((FieldEditor)executableEditor);
        Composite timeoutEditorParent = this.getFieldEditorParent();
        IntegerFieldEditor timeoutEditor = new IntegerFieldEditor("graphviz.timeout", "Timeout (ms):", timeoutEditorParent);
        timeoutEditor.setValidRange(200, Integer.MAX_VALUE);
        this.addField((FieldEditor)timeoutEditor);
        BooleanFieldEditor restartGraphvizProcessCheckbox = new BooleanFieldEditor("graphviz.reuseProcess", "Reuse single graphviz process for better performance", this.getFieldEditorParent());
        this.addField((FieldEditor)restartGraphvizProcessCheckbox);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(GraphvizLayouterPreferenceStore.getInstance().getPreferenceStore());
    }

    public boolean performOk() {
        for (LayoutAlgorithmData data : LayoutMetaDataService.getInstance().getAlgorithmData()) {
            if (!"Graphviz".equals(data.getBundleName())) continue;
            data.getInstancePool().clear();
        }
        return super.performOk();
    }
}

