/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.core.data.cmsis;

import org.eclipse.embedcdt.core.zafarkhaja.semver.Version;
import org.eclipse.embedcdt.internal.packs.core.Activator;
import org.eclipse.embedcdt.packs.core.IConsoleStream;
import org.eclipse.embedcdt.packs.core.data.DataUtils;
import org.eclipse.embedcdt.packs.core.data.cmsis.PdscUtils;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;

public class PdscTreeParser {
    protected IConsoleStream fOut = Activator.getInstance().getConsoleOutput();
    protected Version fSemVer;

    protected boolean checkValid(Node node) {
        if (node == null || !node.hasChildren()) {
            return false;
        }
        Leaf firstChild = node.getFirstChild();
        if (!firstChild.isType("package")) {
            String msg = "Missing <package>; instead, <" + firstChild.getType() + "> encountered";
            this.fOut.println("Error+" + msg);
            DataUtils.reportError(msg);
            return false;
        }
        String schemaVersion = firstChild.getProperty("schemaVersion");
        this.fSemVer = Version.valueOf((String)schemaVersion);
        if (!PdscUtils.isSchemaValid(this.fSemVer)) {
            Activator.log((String)("Unrecognised schema version " + schemaVersion));
            return false;
        }
        return true;
    }

    protected Node addUniqueVendor(Node parent, String vendorName, String vendorId) {
        if (parent.hasChildren()) {
            for (Leaf child : parent.getChildren()) {
                if (!vendorId.equals(child.getProperty("vendor.id"))) continue;
                return (Node)child;
            }
        }
        Node vendor = Node.addNewChild(parent, "vendor");
        vendor.setName(vendorName);
        vendor.putProperty("vendor.id", vendorId);
        return vendor;
    }

    protected String updatePosixSeparators(String spath) {
        return spath.replace('\\', '/');
    }
}

