/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.ui.properties;

import ilg.gnumcueclipse.core.ui.DirectoryNotStrictFieldEditor;
import ilg.gnumcueclipse.debug.gdbjtag.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.properties.PersistentProperties;
import ilg.gnumcueclipse.debug.gdbjtag.ui.Messages;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SvdTab
extends AbstractCPropertyTab {
    protected Text fFileText;
    protected Button fFileButton;
    protected DirectoryNotStrictFieldEditor fEditor;
    protected Preferences fPreferences;

    public void createControls(Composite parent) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("SvdTab.createControls()");
        }
        IProject project = this.page.getProject();
        this.fPreferences = new ProjectScope(project).getNode("ilg.gnumcueclipse.debug.gdbjtag");
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(3, false));
        this.usercomp.setLayoutData((Object)new GridData(768));
        Label introLabel = new Label(this.usercomp, 16448);
        introLabel.setText(Messages.SvdPathProperties_intro_label);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        introLabel.setLayoutData((Object)gd);
        Label fileLabel = ControlFactory.createLabel((Composite)this.usercomp, (String)Messages.SvdPathProperties_file_label);
        ((GridData)fileLabel.getLayoutData()).grabExcessHorizontalSpace = false;
        this.fFileText = ControlFactory.createTextField((Composite)this.usercomp, (int)2052);
        ((GridData)this.fFileText.getLayoutData()).widthHint = new PixelConverter((Control)parent).convertWidthInCharsToPixels(40);
        this.fFileText.setToolTipText(Messages.SvdPathProperties_file_tooltip);
        this.fFileButton = ControlFactory.createPushButton((Composite)this.usercomp, (String)Messages.SvdPathProperties_file_button);
        ((GridData)this.fFileButton.getLayoutData()).horizontalAlignment = 3;
        final Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.fFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(activeShell, 0);
                dialog.setText(Messages.SvdPathProperties_file_dialog);
                String fileName = SvdTab.this.fFileText.getText();
                dialog.setFilterPath(fileName);
                String chosenFile = dialog.open();
                if (chosenFile != null) {
                    SvdTab.this.fFileText.setText(chosenFile);
                }
            }
        });
    }

    private void storeValue(ICResourceDescription desc) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("SvdTab.storeValue('" + desc.getId() + "') = '" + this.fFileText.getText().trim() + "'");
        }
        String key = PersistentProperties.getSvdAbsolutePathKey(desc.getConfiguration().getId());
        this.fPreferences.put(key, this.fFileText.getText().trim());
        try {
            this.fPreferences.flush();
        }
        catch (BackingStoreException ex) {
            System.out.println((Object)ex);
        }
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("SvdTab.performApply(" + src.getConfiguration().getName() + "," + dst.getConfiguration().getName() + ")");
        }
        this.storeValue(src);
    }

    protected void performOK() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("SvdTab.performOK()");
        }
        ICResourceDescription desc = this.getResDesc();
        this.storeValue(desc);
    }

    protected void performDefaults() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("SvdTab.performDefaults()");
        }
        this.fFileText.setText("");
    }

    protected void updateData(ICResourceDescription cfg) {
        String key = PersistentProperties.getSvdAbsolutePathKey(cfg.getConfiguration().getId());
        String value = this.fPreferences.get(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("SvdTab.updateData(" + cfg.getConfiguration().getName() + ") '" + value + "'");
        }
        this.fFileText.setText(value);
    }

    protected void updateButtons() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("SvdTab.updateButtons()");
        }
    }

    public boolean canSupportMultiCfg() {
        return false;
    }
}

