/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.property;

import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emfcloud.jackson.annotations.EcoreIdentityInfo;
import org.eclipse.emfcloud.jackson.annotations.EcoreReferenceInfo;
import org.eclipse.emfcloud.jackson.annotations.EcoreTypeInfo;
import org.eclipse.emfcloud.jackson.annotations.JsonAnnotations;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.databind.property.EObjectFeatureProperty;
import org.eclipse.emfcloud.jackson.databind.property.EObjectIdentityProperty;
import org.eclipse.emfcloud.jackson.databind.property.EObjectOperationProperty;
import org.eclipse.emfcloud.jackson.databind.property.EObjectProperty;
import org.eclipse.emfcloud.jackson.databind.property.EObjectReferenceProperty;
import org.eclipse.emfcloud.jackson.databind.property.EObjectTypeProperty;
import org.eclipse.emfcloud.jackson.databind.type.EcoreTypeFactory;
import org.eclipse.emfcloud.jackson.module.EMFModule;

public final class EObjectPropertyMap {
    private final Map<String, EObjectProperty> propertiesMap;
    private final Set<EObjectProperty> properties;
    private final EClass type;
    private EObjectTypeProperty typeProperty;

    private EObjectPropertyMap(EClass type, Map<String, EObjectProperty> propertiesMap, Set<EObjectProperty> properties) {
        this.type = type;
        this.propertiesMap = propertiesMap;
        this.properties = properties;
    }

    public EObjectProperty findProperty(String field) {
        return this.propertiesMap.get(field);
    }

    public Iterable<EObjectProperty> getProperties() {
        return this.properties;
    }

    public EObjectTypeProperty getTypeProperty() {
        if (this.typeProperty == null) {
            for (EObjectProperty property : this.properties) {
                if (!(property instanceof EObjectTypeProperty)) continue;
                this.typeProperty = (EObjectTypeProperty)property;
            }
        }
        return this.typeProperty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EObjectPropertyMap that = (EObjectPropertyMap)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.type);
    }

    public static class Builder {
        private final Map<EClass, EObjectPropertyMap> cache = new WeakHashMap<EClass, EObjectPropertyMap>();
        private final EcoreIdentityInfo identityInfo;
        private final EcoreTypeInfo typeInfo;
        private final EcoreReferenceInfo referenceInfo;
        private final int features;

        public Builder(EcoreIdentityInfo identityInfo, EcoreTypeInfo typeInfo, EcoreReferenceInfo referenceInfo, int features) {
            this.identityInfo = identityInfo;
            this.typeInfo = typeInfo;
            this.referenceInfo = referenceInfo;
            this.features = features;
        }

        public static Builder from(EMFModule module, int features) {
            return new Builder(module.getIdentityInfo(), module.getTypeInfo(), module.getReferenceInfo(), features);
        }

        public EObjectPropertyMap construct(DatabindContext ctxt, EClass type) {
            EObjectPropertyMap propertyMap;
            if (type == null) {
                this.buildCache(ctxt);
            }
            EObjectPropertyMap eObjectPropertyMap = propertyMap = type == null ? null : this.cache.get(type);
            if (propertyMap == null) {
                propertyMap = this.createPropertyMap(ctxt, type);
                if (type != null) {
                    this.cache.put(type, propertyMap);
                }
            }
            return propertyMap;
        }

        private void buildCache(DatabindContext ctxt) {
            ResourceSet resourceSet = EMFContext.getResourceSet(ctxt);
            Set<EClass> types = resourceSet.getPackageRegistry().values().stream().flatMap(model -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(((EPackage)model).eAllContents(), 16), false)).filter(e -> e instanceof EClass).map(e -> (EClass)e).collect(Collectors.toSet());
            types.forEach(type -> this.cache.put((EClass)type, this.construct(ctxt, (EClass)type)));
        }

        private EObjectPropertyMap createPropertyMap(DatabindContext ctxt, EClass type) {
            EcoreTypeFactory factory = EMFContext.getTypeFactory(ctxt);
            HashMap propertiesMap = new HashMap();
            LinkedHashSet properties = new LinkedHashSet();
            Consumer<EObjectProperty> add = p -> {
                properties.add(p);
                propertiesMap.put(p.getFieldName(), p);
            };
            add.accept(new EObjectReferenceProperty(this.referenceInfo));
            add.accept(this.getTypeProperty(type, this.features));
            if (EMFModule.Feature.OPTION_USE_ID.enabledIn(this.features)) {
                add.accept(new EObjectIdentityProperty(this.identityInfo));
            }
            if (type != null) {
                for (EStructuralFeature feature : type.getEAllStructuralFeatures()) {
                    this.createFeatureProperty(ctxt, factory, type, feature).ifPresent(property -> {
                        add.accept((EObjectProperty)property);
                        for (String alias : JsonAnnotations.getAliases((ENamedElement)feature)) {
                            propertiesMap.put(alias, property);
                        }
                    });
                }
                for (EOperation operation : type.getEAllOperations()) {
                    EAnnotation annotation = operation.getEAnnotation("JsonProperty");
                    if (annotation == null || !operation.getEParameters().isEmpty()) continue;
                    add.accept(new EObjectOperationProperty(JsonAnnotations.getElementName((ENamedElement)operation), operation));
                }
            }
            return new EObjectPropertyMap(type, propertiesMap, properties);
        }

        private Optional<EObjectFeatureProperty> createFeatureProperty(DatabindContext ctxt, EcoreTypeFactory factory, EClass type, EStructuralFeature feature) {
            JavaType javaType;
            if (this.isCandidate(feature) && (javaType = factory.typeOf(ctxt, type, feature)) != null) {
                return Optional.of(new EObjectFeatureProperty(feature, javaType, this.features));
            }
            return Optional.empty();
        }

        boolean isFeatureMapEntry(EStructuralFeature feature) {
            EAnnotation annotation = feature.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
            return annotation != null && annotation.getDetails().containsKey((Object)"group");
        }

        boolean isCandidate(EStructuralFeature feature) {
            if (feature instanceof EAttribute) {
                return this.isCandidate((EAttribute)feature);
            }
            return this.isCandidate((EReference)feature);
        }

        boolean isCandidate(EAttribute attribute) {
            return this.isFeatureMapEntry((EStructuralFeature)attribute) || !FeatureMapUtil.isFeatureMap((EStructuralFeature)attribute) && !attribute.isDerived() && !attribute.isTransient() && !JsonAnnotations.shouldIgnore((EStructuralFeature)attribute);
        }

        boolean isCandidate(EReference eReference) {
            if (this.isFeatureMapEntry((EStructuralFeature)eReference)) {
                return true;
            }
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eReference) || eReference.isTransient() || JsonAnnotations.shouldIgnore((EStructuralFeature)eReference)) {
                return false;
            }
            EReference opposite = eReference.getEOpposite();
            return opposite == null || !opposite.isContainment();
        }

        private EObjectProperty getTypeProperty(EClass type, int features) {
            EcoreTypeInfo currentTypeInfo = null;
            if (type != null && !JsonAnnotations.shouldIgnoreType((EClassifier)type)) {
                currentTypeInfo = JsonAnnotations.getTypeProperty((EClassifier)type);
            }
            if (currentTypeInfo == null) {
                currentTypeInfo = this.typeInfo;
            }
            return new EObjectTypeProperty(currentTypeInfo, features);
        }

        public EObjectPropertyMap constructDefault(DatabindContext ctxt) {
            return this.construct(ctxt, null);
        }

        public EObjectPropertyMap find(DeserializationContext ctxt, EClass defaultType, Iterator<String> fields) {
            List<EClass> types = EMFContext.allSubTypes((DatabindContext)ctxt, defaultType);
            HashMap<String, EClass> properties = new HashMap<String, EClass>();
            for (EClass type : types) {
                EObjectProperty p = this.getTypeProperty(type, this.features);
                properties.put(p.getFieldName(), type);
            }
            while (fields.hasNext()) {
                String field = fields.next();
                if (!properties.containsKey(field)) continue;
                return this.construct((DatabindContext)ctxt, (EClass)properties.get(field));
            }
            return this.construct((DatabindContext)ctxt, defaultType);
        }
    }
}

