/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.editor.view;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecp.ide.editor.view.Activator;
import org.eclipse.emf.ecp.ide.editor.view.messages.Messages;
import org.eclipse.emf.ecp.ide.view.service.ViewModelEditorCallback;
import org.eclipse.emf.ecp.internal.ide.util.EcoreHelper;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigrationException;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigrator;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigratorUtil;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.reporting.AbstractReport;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.internal.ErrorViewPart;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class ViewEditorPart
extends EditorPart
implements ViewModelEditorCallback {
    private Resource resource;
    private BasicCommandStack basicCommandStack;
    private Composite parent;
    private ECPSWTView render;
    private boolean ecoreOutOfSync;
    private IPartListener2 partListener;
    private final ViewEditorPart instance = this;

    public void doSave(IProgressMonitor monitor) {
        try {
            this.resource.save(null);
            this.basicCommandStack.saveIsDone();
            this.firePropertyChange(257);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
        super.setPartName(input.getName());
        this.basicCommandStack = new BasicCommandStack();
        this.basicCommandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                ViewEditorPart.this.parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ViewEditorPart.this.firePropertyChange(257);
                    }
                });
            }
        });
        this.partListener = new ViewPartListener();
        this.getSite().getPage().addPartListener(this.partListener);
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getKind() == 2) {
                            FileEditorInput fei = (FileEditorInput)ViewEditorPart.this.instance.getEditorInput();
                            if (delta.getFullPath().equals((Object)fei.getFile().getFullPath())) {
                                final IWorkbenchPage page = ViewEditorPart.this.instance.getSite().getPage();
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        page.closeEditor((IEditorPart)ViewEditorPart.this.instance, false);
                                    }
                                });
                                return false;
                            }
                        }
                        return true;
                    }
                };
                try {
                    delta.accept(visitor);
                }
                catch (CoreException coreException) {}
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
    }

    private ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)}), (CommandStack)this.basicCommandStack, (ResourceSet)resourceSet);
        resourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        return resourceSet;
    }

    public boolean isDirty() {
        return this.basicCommandStack.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void loadView(boolean migrate) {
        FileEditorInput fei = (FileEditorInput)this.getEditorInput();
        ResourceSet resourceSet = this.createResourceSet();
        try {
            URI resourceURI = URI.createURI((String)fei.getURI().toURL().toExternalForm());
            if (migrate) {
                this.checkMigration(resourceURI);
            }
            HashMap<String, Boolean> loadOptions = new HashMap<String, Boolean>();
            loadOptions.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            this.resource = resourceSet.createResource(resourceURI);
            this.resource.load(loadOptions);
            int rsSize = resourceSet.getResources().size();
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
            while (rsSize != resourceSet.getResources().size()) {
                EcoreUtil.resolveAll((ResourceSet)resourceSet);
                rsSize = resourceSet.getResources().size();
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
        }
    }

    private void checkMigration(final URI resourceURI) {
        Shell shell;
        boolean migrate;
        boolean needsMigration;
        final ViewModelMigrator migrator = ViewModelMigratorUtil.getViewModelMigrator();
        if (migrator == null) {
            return;
        }
        boolean bl = needsMigration = !migrator.checkMigration(resourceURI);
        if (needsMigration && (migrate = MessageDialog.openQuestion((Shell)(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()), (String)Messages.ViewEditorPart_MigrationTitle, (String)Messages.ViewEditorPart_MigrationQuestion))) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        migrator.performMigration(resourceURI);
                    }
                    catch (ViewModelMigrationException ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(shell).run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ViewEditorPart_MigrationErrorTitle, (String)(String.valueOf(Messages.ViewEditorPart_MigrationErrorText1) + Messages.ViewEditorPart_MigrationErrorText2));
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", Messages.ViewEditorPart_MigrationErrorTitle, (Throwable)e));
            }
            catch (InterruptedException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ViewEditorPart_MigrationErrorTitle, (String)(String.valueOf(Messages.ViewEditorPart_MigrationErrorText1) + Messages.ViewEditorPart_MigrationErrorText2));
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", Messages.ViewEditorPart_MigrationErrorTitle, (Throwable)e));
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        this.loadView(false);
        this.registerEcore();
        try {
            this.loadView(true);
            VView view = this.getView();
            Activator.getViewModelRegistry().registerViewModel(view, this.resource.getURI().toString());
            try {
                Activator.getViewModelRegistry().registerViewModelEditor(view, (ViewModelEditorCallback)this);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
            }
            if (view.getRootEClass() != null) {
                if (view.getRootEClass().eResource() != null) {
                    Activator.getViewModelRegistry().register(view.getRootEClass().eResource().getURI().toString(), view);
                } else {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.ecp.ide.editor.view", "The Root EClass of the view cannot be resolved." + view.getRootEClass()));
                }
            }
            this.showView();
        }
        catch (RuntimeException e) {
            this.displayError(e);
        }
    }

    private void registerEcore() {
        String ecorePath = this.getEcorePath();
        if (ecorePath == null) {
            return;
        }
        try {
            EcoreHelper.registerEcore((String)ecorePath);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
        }
    }

    private void saveChangedView(VView view) {
        try {
            view.eResource().save(null);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
        }
    }

    private String selectEcoreFromWorkspace() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IFile file;
                if (selection.length == 1 && selection[0] instanceof IFile && (file = (IFile)selection[0]).getType() == 1) {
                    return new Status(0, "org.eclipse.emf.ecp.ide.editor.view", 0, null, null);
                }
                return new Status(4, "org.eclipse.emf.ecp.ide.editor.view", 4, Messages.ViewEditorPart_EcoreSelectionValidation, null);
            }
        });
        dialog.setTitle(Messages.ViewEditorPart_EcoreSelectionTitle);
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            return file.getFullPath().toString();
        }
        return null;
    }

    private void showView() {
        VView view = this.getView();
        try {
            this.render = ECPSWTViewRenderer.INSTANCE.render(this.parent, (EObject)view);
        }
        catch (ECPRendererException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emf.ecp.ide.editor.view", ex.getMessage(), (Throwable)ex)));
        }
    }

    public void setFocus() {
    }

    public void reloadViewModel() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String ecorePath;
                if (ViewEditorPart.this.render != null) {
                    ViewEditorPart.this.render.dispose();
                    ViewEditorPart.this.render.getSWTControl().dispose();
                }
                if ((ecorePath = ViewEditorPart.this.getView().getEcorePath()) != null) {
                    try {
                        EcoreHelper.registerEcore((String)ecorePath);
                    }
                    catch (IOException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
                    }
                }
                ViewEditorPart.this.loadView(true);
                VView view = ViewEditorPart.this.getView();
                try {
                    Activator.getViewModelRegistry().registerViewModelEditor(view, (ViewModelEditorCallback)ViewEditorPart.this.instance);
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
                }
                if (view.getRootEClass() != null) {
                    if (view.getRootEClass().eResource() != null) {
                        Activator.getViewModelRegistry().register(view.getRootEClass().eResource().getURI().toString(), view);
                    } else {
                        Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.ecp.ide.editor.view", "The Root EClass of the view cannot be resolved." + view.getRootEClass()));
                    }
                }
                ViewEditorPart.this.showView();
                ViewEditorPart.this.parent.layout(true);
            }
        });
    }

    public void dispose() {
        VView view = this.getView();
        Activator.getViewModelRegistry().unregisterViewModelEditor(view, (ViewModelEditorCallback)this);
        this.getSite().getPage().removePartListener(this.partListener);
        super.dispose();
    }

    public VView getView() {
        EObject eObject = (EObject)this.resource.getContents().get(0);
        return (VView)eObject;
    }

    private String getEcorePath() {
        EObject eObject = (EObject)this.resource.getContents().get(0);
        if (VView.class.isInstance(eObject)) {
            return ((VView)VView.class.cast(eObject)).getEcorePath();
        }
        if (AnyType.class.isInstance(eObject)) {
            FeatureMap anyAttribute = ((AnyType)AnyType.class.cast(eObject)).getAnyAttribute();
            int i = 0;
            while (i < anyAttribute.size()) {
                EStructuralFeature feature = anyAttribute.getEStructuralFeature(i);
                if ("ecorePath".equals(feature.getName())) {
                    return (String)anyAttribute.getValue(i);
                }
                ++i;
            }
        }
        return null;
    }

    private void displayError(Exception e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
        Status status = new Status(4, "org.eclipse.emf.ecp.ide.editor.view", Messages.ViewEditorPart_ViewCannotBeDisplayed, (Throwable)e);
        ErrorViewPart part = new ErrorViewPart((IStatus)status);
        part.createPartControl(this.parent);
    }

    public void signalEcoreOutOfSync() {
        this.ecoreOutOfSync = true;
    }

    private class ViewPartListener
    implements IPartListener2 {
        private ViewPartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (((Object)((Object)ViewEditorPart.this.instance)).equals(partRef.getPart(true))) {
                String selectedECorePath;
                VView view = ViewEditorPart.this.getView();
                if ((view.getEcorePath() == null || ResourcesPlugin.getWorkspace().getRoot().findMember(view.getEcorePath()) == null) && view.getRootEClass().eIsProxy() && (selectedECorePath = ViewEditorPart.this.selectEcoreFromWorkspace()) != null) {
                    view.setEcorePath(selectedECorePath);
                    ViewEditorPart.this.saveChangedView(view);
                    ViewEditorPart.this.reloadViewModel();
                }
                if (ViewEditorPart.this.ecoreOutOfSync) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialog dialog = new MessageDialog(activeShell, Messages.ViewEditorPart_Warning, null, Messages.ViewEditorPart_EditorViewChanged, 4, new String[]{Messages.ViewEditorPart_Yes, Messages.ViewEditorPart_No}, 0);
                            int result = dialog.open();
                            if (result == 0) {
                                Activator.getViewModelRegistry().unregisterViewModelEditor(ViewEditorPart.this.getView(), (ViewModelEditorCallback)ViewEditorPart.this.instance);
                                Activator.getViewModelRegistry().unregister(ViewEditorPart.this.getView().getRootEClass().eResource().getURI().toString(), ViewEditorPart.this.getView());
                                ViewEditorPart.this.reloadViewModel();
                            }
                            ViewEditorPart.this.ecoreOutOfSync = false;
                        }
                    });
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }
}

