/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ide.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class EcoreHelper {
    private static final String ECORE_PLUGIN_URI = "platform:/plugin/org.eclipse.emf.ecore/model/Ecore.ecore";
    private static final String ECORE_RESOURCE_URI = "platform:/resource/org.eclipse.emf.ecore/model/Ecore.ecore";
    private static final Map<String, Set<String>> ECOREPATH_TO_WORKSPACEURIS = new HashMap<String, Set<String>>();
    private static final Map<String, Integer> ECOREPATH_TO_REGISTEREDCOUNT = new HashMap<String, Integer>();
    private static final Set<String> ALL_NSURIS_REGISTERED_BY_TOOLING = new HashSet<String>();
    private static final Map<String, EPackage> WORKSPACEURI_TO_REGISTEREDPACKAGE = new LinkedHashMap<String, EPackage>();

    private EcoreHelper() {
    }

    public static void registerEcore(String ecorePath) throws IOException {
        if (ecorePath == null) {
            return;
        }
        Integer previousValue = ECOREPATH_TO_REGISTEREDCOUNT.get(ecorePath);
        if (previousValue == null || previousValue < 0) {
            previousValue = 0;
        }
        previousValue = previousValue + 1;
        ECOREPATH_TO_REGISTEREDCOUNT.put(ecorePath, previousValue);
        EcoreHelper.determineWorkspaceDepedencies(ecorePath);
        ResourceSetImpl physicalResourceSet = new ResourceSetImpl();
        EcoreHelper.initResourceSet((ResourceSet)physicalResourceSet, true);
        URI uri = URI.createPlatformResourceURI((String)ecorePath, (boolean)false);
        Resource r = physicalResourceSet.createResource(uri);
        r.load(null);
        int rsSize = physicalResourceSet.getResources().size();
        EcoreUtil.resolveAll((ResourceSet)physicalResourceSet);
        while (rsSize != physicalResourceSet.getResources().size()) {
            EcoreUtil.resolveAll((ResourceSet)physicalResourceSet);
            rsSize = physicalResourceSet.getResources().size();
        }
        ResourceSetImpl virtualResourceSet = new ResourceSetImpl();
        for (Resource physicalResource : physicalResourceSet.getResources()) {
            EPackage registeredPackage;
            if (physicalResource.getContents().size() == 0) continue;
            EObject eObject = (EObject)physicalResource.getContents().get(0);
            EcoreUtil.resolveAll((EObject)eObject);
            EPackage ePackage = (EPackage)EPackage.class.cast(eObject);
            if (EcoreHelper.isContainedInPackageRegistry(ePackage.getNsURI()) && (!ALL_NSURIS_REGISTERED_BY_TOOLING.contains(ePackage.getNsURI()) || EcoreUtil.equals((EObject)ePackage, (EObject)(registeredPackage = EPackage.Registry.INSTANCE.getEPackage(ePackage.getNsURI()))))) continue;
            EcoreHelper.updateRegistryAndLocalCache(ePackage, physicalResource, (ResourceSet)virtualResourceSet);
        }
    }

    private static void updateRegistryAndLocalCache(EPackage ePackage, Resource oldResource, ResourceSet newResourceSet) {
        String platformResourceURI = oldResource.getURI().toString();
        oldResource.getContents().remove((Object)ePackage);
        Resource virtualResource = newResourceSet.createResource(URI.createURI((String)ePackage.getNsURI()));
        virtualResource.getContents().add((Object)ePackage);
        EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
        ALL_NSURIS_REGISTERED_BY_TOOLING.add(ePackage.getNsURI());
        WORKSPACEURI_TO_REGISTEREDPACKAGE.put(platformResourceURI, ePackage);
    }

    private static URI determineWorkspaceDepedencies(String ecorePath) throws IOException {
        ResourceSetImpl physicalResourceSet = new ResourceSetImpl();
        EcoreHelper.initResourceSet((ResourceSet)physicalResourceSet, false);
        URI uri = URI.createPlatformResourceURI((String)ecorePath, (boolean)false);
        Resource tempResource = physicalResourceSet.createResource(uri);
        tempResource.load(null);
        int tempSize = physicalResourceSet.getResources().size();
        EcoreUtil.resolveAll((ResourceSet)physicalResourceSet);
        while (tempSize != physicalResourceSet.getResources().size()) {
            EcoreUtil.resolveAll((ResourceSet)physicalResourceSet);
            tempSize = physicalResourceSet.getResources().size();
        }
        for (Resource physicalResource : physicalResourceSet.getResources()) {
            if (physicalResource.getContents().size() == 0 || !physicalResource.getURI().isPlatformResource()) continue;
            if (ECOREPATH_TO_WORKSPACEURIS.get(ecorePath) == null) {
                ECOREPATH_TO_WORKSPACEURIS.put(ecorePath, new HashSet());
            }
            ECOREPATH_TO_WORKSPACEURIS.get(ecorePath).add(physicalResource.getURI().toString());
        }
        return uri;
    }

    private static boolean isContainedInPackageRegistry(String nsURI) {
        EPackage.Registry instance = EPackage.Registry.INSTANCE;
        return instance.containsKey((Object)nsURI);
    }

    public static void unregisterEcore(String ecorePath) {
        if (ecorePath == null || ECOREPATH_TO_WORKSPACEURIS.get(ecorePath) == null) {
            return;
        }
        int usages = ECOREPATH_TO_REGISTEREDCOUNT.get(ecorePath);
        ECOREPATH_TO_REGISTEREDCOUNT.put(ecorePath, --usages);
        if (usages > 0) {
            return;
        }
        Set<String> workspaceURIsNeededForEcorePath = ECOREPATH_TO_WORKSPACEURIS.remove(ecorePath);
        EcoreHelper.unregisterEcore(ecorePath, workspaceURIsNeededForEcorePath);
    }

    private static void unregisterEcore(String ecorePath, Set<String> workspaceURIsNeededByEcorePath) {
        if (workspaceURIsNeededByEcorePath == null || ecorePath == null) {
            return;
        }
        LinkedHashSet<String> workspaceURIsToRemove = new LinkedHashSet<String>();
        for (String workspaceURI : workspaceURIsNeededByEcorePath) {
            boolean okToRemove = true;
            for (Set<String> otherNeededWSURIs : ECOREPATH_TO_WORKSPACEURIS.values()) {
                if (!otherNeededWSURIs.contains(workspaceURI)) continue;
                okToRemove = false;
                break;
            }
            if (!okToRemove) continue;
            workspaceURIsToRemove.add(workspaceURI);
        }
        for (String toRemove : workspaceURIsToRemove) {
            EPackage pkgToRemove = WORKSPACEURI_TO_REGISTEREDPACKAGE.remove(toRemove);
            if (pkgToRemove == null) continue;
            EPackage.Registry.INSTANCE.remove((Object)pkgToRemove.getNsURI());
            ALL_NSURIS_REGISTERED_BY_TOOLING.remove(pkgToRemove.getNsURI());
        }
    }

    public static Object[] getDefaultPackageRegistryContents() {
        HashSet packages = new HashSet();
        packages.addAll(EPackage.Registry.INSTANCE.keySet());
        packages.removeAll(ALL_NSURIS_REGISTERED_BY_TOOLING);
        return packages.toArray();
    }

    private static void initResourceSet(ResourceSet resourceSet, boolean withLocalRegistry) {
        if (withLocalRegistry) {
            resourceSet.getPackageRegistry().putAll(WORKSPACEURI_TO_REGISTEREDPACKAGE);
        }
        if (!resourceSet.getURIConverter().exists(URI.createURI((String)ECORE_RESOURCE_URI), null)) {
            resourceSet.getURIConverter().getURIMap().put(URI.createURI((String)ECORE_RESOURCE_URI), URI.createURI((String)ECORE_PLUGIN_URI));
        }
    }
}

