/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.controller;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.model.controller.ForceRevertController;
import org.eclipse.emf.emfstore.client.ui.handlers.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.client.ui.views.historybrowserview.HistoryBrowserView;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UIForceRevertCommitController
extends AbstractEMFStoreUIController {
    private final HistoryInfo historyInfo;

    public UIForceRevertCommitController(Shell shell, HistoryInfo historyInfo) {
        super(shell);
        this.historyInfo = historyInfo;
    }

    public void revert() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        if (!(activePage.getActivePart() instanceof HistoryBrowserView)) {
            return;
        }
        HistoryBrowserView view = (HistoryBrowserView)activePage.getActivePart();
        MessageDialog dialog = new MessageDialog(null, "Confirmation", null, "Do you really want to force to revert changes of this version on project " + view.getProjectSpace().getProjectName(), 3, new String[]{"Yes", "No"}, 0);
        int result = dialog.open();
        if (result == 0) {
            PrimaryVersionSpec versionSpec = (PrimaryVersionSpec)ModelUtil.clone((EObject)this.historyInfo.getPrimerySpec());
            try {
                new ForceRevertController(view.getProjectSpace(), versionSpec).execute();
            }
            catch (EmfStoreException emfStoreException) {
                // empty catch block
            }
        }
    }
}

