/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.controller;

import java.io.IOException;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.client.model.Workspace;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.ui.handlers.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.views.CreateProjectDialog;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Shell;

public class UIProjectController
extends AbstractEMFStoreUIController {
    public UIProjectController(Shell shell) {
        super(shell);
    }

    public ProjectSpace createLocalProject() {
        CreateProjectDialog dialog = new CreateProjectDialog(this.getShell());
        if (dialog.open() == 0) {
            return this.createLocalProject(dialog.getName(), dialog.getDescription());
        }
        return null;
    }

    protected ProjectSpace createLocalProject(String name, String description) {
        return WorkspaceManager.getInstance().getCurrentWorkspace().createLocalProject(name, description);
    }

    public ProjectInfo createRemoteProject() throws EmfStoreException {
        return this.createRemoteProject(null);
    }

    public ProjectInfo createRemoteProject(Usersession usersession) throws EmfStoreException {
        CreateProjectDialog dialog = new CreateProjectDialog(this.getShell());
        if (dialog.open() == 0) {
            return this.createRemoteProject(usersession, dialog.getName(), dialog.getDescription());
        }
        return null;
    }

    protected ProjectInfo createRemoteProject(Usersession usersession, String name, String description) throws EmfStoreException {
        return WorkspaceManager.getInstance().getCurrentWorkspace().createRemoteProject(usersession, name, description);
    }

    public void deleteProject(ProjectSpace projectSpace) {
        try {
            if (!this.confirmation(projectSpace)) {
                return;
            }
            Workspace currentWorkspace = WorkspaceManager.getInstance().getCurrentWorkspace();
            currentWorkspace.deleteProjectSpace(projectSpace);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void deleteRemoteProject(ServerInfo serverInfo, ProjectId projectId, boolean deleteFiles) throws EmfStoreException {
        if (this.confirmationDialog("Do you really want to delete the remote project?")) {
            WorkspaceManager.getInstance().getCurrentWorkspace().deleteRemoteProject(serverInfo, projectId, deleteFiles);
        }
    }

    public void deleteRemoteProject(ProjectInfo info) throws EmfStoreException {
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getShell(), (String)("Delete " + info.getName()), (String)("Are you sure you want to delete '" + info.getName() + "'"), (String)"Delete project contents (cannot be undone)", (boolean)false, null, null);
        if (dialog.getReturnCode() == 0) {
            if (!(info.eContainer() instanceof ServerInfo)) {
                throw new EmfStoreException("ServerInfo couldn't be determined for the given project.");
            }
            ServerInfo serverInfo = (ServerInfo)info.eContainer();
            WorkspaceManager.getInstance().getCurrentWorkspace().deleteRemoteProject(serverInfo, info.getProjectId(), dialog.getToggleState());
        }
    }

    public void deleteRemoteProject(Usersession usersession, ProjectId projectId, boolean deleteFiles) throws EmfStoreException {
        if (this.confirmationDialog("Do you really want to delete the remote project?")) {
            WorkspaceManager.getInstance().getCurrentWorkspace().deleteRemoteProject(usersession, projectId, deleteFiles);
        }
    }

    protected boolean confirmation(ProjectSpace projectSpace) {
        String message = "Do you really want to delete your local copy of project \"" + projectSpace.getProjectName() + "\n";
        if (projectSpace.getBaseVersion() != null) {
            message = String.valueOf(message) + " in version " + projectSpace.getBaseVersion().getIdentifier();
        }
        message = String.valueOf(message) + " ?";
        return this.confirmationDialog(message);
    }

    public void showProjectProperties(ProjectInfo info) {
        ServerInfo serverInfo = info.eContainer() instanceof ServerInfo ? (ServerInfo)info.eContainer() : null;
        String revision = "<unknown>";
        if (serverInfo != null) {
            try {
                PrimaryVersionSpec versionSpec = WorkspaceManager.getInstance().getCurrentWorkspace().resolveVersionSpec(serverInfo, VersionSpec.HEAD_VERSION, info.getProjectId());
                revision = "" + versionSpec.getIdentifier();
            }
            catch (EmfStoreException emfStoreException) {
                // empty catch block
            }
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Project Information", (String)("Current revision: " + revision + "\n" + "ProjectId: " + info.getProjectId().getId()));
    }
}

