/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.views.changes;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.emfstore.client.ui.Activator;
import org.eclipse.emf.emfstore.client.ui.views.changes.DefaultOperationLabelProvider;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.ModelFactory;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.model.provider.AbstractOperationCustomLabelProvider;
import org.eclipse.emf.emfstore.server.model.provider.CustomOperationLabelProviderManager;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AttributeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceMoveOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.ReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.SingleReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.UnkownFeatureException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePackageVisualizationHelper {
    private Map<ModelElementId, EObject> modelElementMap = new HashMap<ModelElementId, EObject>();
    private CustomOperationLabelProviderManager customLabelProviderManager;
    private DefaultOperationLabelProvider defaultOperationLabelProvider;

    public ChangePackageVisualizationHelper(List<ChangePackage> changePackages, Project project) {
        for (ChangePackage changePackage : changePackages) {
            this.initModelElementMap(changePackage);
        }
        for (EObject eObject : project.getAllModelElements()) {
            this.modelElementMap.put(project.getModelElementId(eObject), eObject);
        }
        this.defaultOperationLabelProvider = new DefaultOperationLabelProvider();
        this.defaultOperationLabelProvider.setModelElementMap(this.modelElementMap);
        this.customLabelProviderManager = new CustomOperationLabelProviderManager(this.modelElementMap);
    }

    private void initModelElementMap(ChangePackage changePackage) {
        List operations = changePackage.getLeafOperations();
        for (AbstractOperation abstractOperation : operations) {
            if (!(abstractOperation instanceof CreateDeleteOperation)) continue;
            for (Map.Entry entry : ((CreateDeleteOperation)abstractOperation).getEObjectToIdMap().map().entrySet()) {
                ModelElementId orgModelElementId = (ModelElementId)entry.getValue();
                EObject modelElement = (EObject)entry.getKey();
                this.modelElementMap.put((ModelElementId)ModelUtil.clone((EObject)orgModelElementId), modelElement);
            }
        }
    }

    public ImageDescriptor getOverlayImage(AbstractOperation operation) {
        CreateDeleteOperation op;
        String overlay = null;
        if (operation instanceof CreateDeleteOperation) {
            op = (CreateDeleteOperation)operation;
            overlay = op.isDelete() ? "icons/delete_overlay.png" : "icons/add_overlay.png";
        } else if (operation instanceof AttributeOperation) {
            op = (AttributeOperation)operation;
            overlay = op.getNewValue() == null ? "icons/delete_overlay.png" : (op.getOldValue() == null ? "icons/add_overlay.png" : "icons/modify_overlay.png");
        } else if (operation instanceof SingleReferenceOperation) {
            op = (SingleReferenceOperation)operation;
            overlay = op.getNewValue() == null ? "icons/delete_overlay.png" : "icons/link_overlay.png";
        } else if (operation instanceof MultiReferenceOperation) {
            op = (MultiReferenceOperation)operation;
            if (op.getReferencedModelElements().size() > 0) {
                overlay = "icons/link_overlay.png";
            }
        } else {
            overlay = operation instanceof MultiReferenceMoveOperation ? "icons/link_overlay.png" : "icons/modify_overlay.png";
        }
        ImageDescriptor overlayDescriptor = Activator.getImageDescriptor(overlay);
        return overlayDescriptor;
    }

    public Image getImage(ILabelProvider emfProvider, AbstractOperation operation) {
        Image image = this.getCustomOperationProviderLabel(operation);
        if (image != null) {
            return image;
        }
        return emfProvider.getImage((Object)operation);
    }

    private Image getCustomOperationProviderLabel(AbstractOperation operation) {
        AbstractOperationCustomLabelProvider customLabelProvider = this.customLabelProviderManager.getCustomLabelProvider(operation);
        if (customLabelProvider != null) {
            try {
                return (Image)customLabelProvider.getImage(operation);
            }
            catch (RuntimeException e) {
                ModelUtil.logWarning((String)"Image load from custom operation item provider failed!", (Throwable)e);
            }
        }
        return null;
    }

    public String getDescription(AbstractOperation op) {
        CompositeOperation compositeOperation;
        AbstractOperationCustomLabelProvider customLabelProvider = this.customLabelProviderManager.getCustomLabelProvider(op);
        if (customLabelProvider != null) {
            return this.decorate(customLabelProvider, op);
        }
        if (op instanceof CompositeOperation && (compositeOperation = (CompositeOperation)op).getMainOperation() != null) {
            return this.getDescription(compositeOperation.getMainOperation());
        }
        return this.decorate(this.defaultOperationLabelProvider, op);
    }

    private String decorate(AbstractOperationCustomLabelProvider labelProvider, AbstractOperation op) {
        String namesResolved = this.resolveIds(labelProvider, labelProvider.getDescription(op), "%");
        String allResolved = this.resolveIds(labelProvider, namesResolved, "&");
        if (op instanceof ReferenceOperation) {
            return this.resolveTypes(allResolved, (ReferenceOperation)op);
        }
        return allResolved;
    }

    private String resolveTypes(String unresolvedString, ReferenceOperation op) {
        String type;
        EObject modelElement = this.getModelElement(op.getModelElementId());
        if (modelElement == null) {
            type = "ModelElement";
        } else {
            try {
                EStructuralFeature feature = op.getFeature(modelElement);
                type = feature.getEType().getName();
            }
            catch (UnkownFeatureException e) {
                type = "ModelElement";
            }
        }
        return unresolvedString.replace("#REFERENCE_TYPE_NAME#", type);
    }

    private String resolveIds(AbstractOperationCustomLabelProvider labelProvider, String unresolvedString, String devider) {
        String[] strings = unresolvedString.split(devider);
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < strings.length) {
            if (i % 2 == 1) {
                ModelElementId modelElementId = ModelFactory.eINSTANCE.createModelElementId();
                modelElementId.setId(strings[i]);
                stringBuilder.append(labelProvider.getModelElementName(modelElementId));
            } else {
                stringBuilder.append(strings[i]);
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    public <T extends Collection<EObject>, S extends Collection<ModelElementId>> T getModelElements(S modelElementIds, T resultCollection) {
        for (ModelElementId modelElementId : modelElementIds) {
            EObject modelElement = this.getModelElement(modelElementId);
            if (modelElement == null) continue;
            resultCollection.add((EObject)modelElement);
        }
        return resultCollection;
    }

    public EObject getModelElement(ModelElementId modelElementId) {
        if (modelElementId == null) {
            return null;
        }
        return this.modelElementMap.get(modelElementId);
    }

    public void dispose() {
        this.defaultOperationLabelProvider.dispose();
    }
}

