/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.dnd;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MEDropAdapter {
    private StructuredViewer viewer;

    public void init(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public void drop(DropTargetEvent event, EObject target, List<EObject> source) {
        this.dropContainment(target, source);
    }

    public abstract EClass isDropAdapterfor();

    protected void dropAfter(EObject targetContainer, EObject target, List<EObject> source) {
        EReference theRef = this.getTargetRef(targetContainer, source.get(0));
        if (theRef == null) {
            return;
        }
        Object object = targetContainer.eGet((EStructuralFeature)theRef);
        EList eList = (EList)object;
        int targetIndex = eList != null ? eList.indexOf((Object)target) : -1;
        if (targetIndex == -1) {
            return;
        }
        if (this.haveSameEContainer(target, source.get(0))) {
            int sourceIndex = eList.indexOf((Object)source.get(0));
            if (sourceIndex >= 0 && sourceIndex < targetIndex) {
                --targetIndex;
            }
            int i = source.size() - 1;
            while (i >= 0) {
                eList.move(targetIndex + 1, (Object)source.get(i));
                --i;
            }
        } else {
            eList.addAll(targetIndex + 1, source);
        }
    }

    protected EReference getTargetRef(EObject targetContainer, EObject dropee) {
        EList refs = targetContainer.eClass().getEAllContainments();
        for (EReference ref : refs) {
            if (ref.isContainer() || !ref.getEReferenceType().equals(dropee.eClass()) && !ref.getEReferenceType().isSuperTypeOf(dropee.eClass())) continue;
            return ref;
        }
        return null;
    }

    protected void dropBefore(EObject targetContainer, EObject target, List<EObject> source) {
        EReference theRef = this.getTargetRef(targetContainer, source.get(0));
        if (theRef == null) {
            return;
        }
        Object object = target.eContainer().eGet((EStructuralFeature)theRef);
        EList eList = (EList)object;
        int targetIndex = eList != null ? eList.indexOf((Object)target) : -1;
        if (targetIndex == -1) {
            return;
        }
        if (this.haveSameEContainer(target, source.get(0))) {
            int sourceIndex = eList.indexOf((Object)source.get(0));
            if (sourceIndex >= 0 && sourceIndex < targetIndex) {
                --targetIndex;
            }
            int i = source.size() - 1;
            while (i >= 0) {
                eList.move(targetIndex, (Object)source.get(i));
                --i;
            }
        } else {
            eList.addAll(targetIndex, source);
        }
    }

    protected boolean haveSameEContainer(EObject target, EObject dropee) {
        return target.eContainer().equals(dropee.eContainer());
    }

    protected void dropContainment(EObject target, List<EObject> source) {
        EReference theRef = this.getTargetRef(target, source.get(0));
        if (theRef == null) {
            return;
        }
        if (theRef.getEOpposite() != null) {
            EReference oppositeRef = theRef.getEOpposite();
            for (EObject me : source) {
                Object object = me.eGet((EStructuralFeature)oppositeRef);
                if (oppositeRef.isMany()) {
                    EList eList = (EList)object;
                    eList.add((Object)target);
                    continue;
                }
                me.eSet((EStructuralFeature)oppositeRef, (Object)target);
            }
        } else if (theRef.isMany()) {
            Object object = target.eGet((EStructuralFeature)theRef);
            EList eList = (EList)object;
            eList.addAll(source);
        } else {
            target.eSet((EStructuralFeature)theRef, (Object)source.get(0));
        }
    }

    public boolean canDrop(int eventFeedback, DropTargetEvent event, List<EObject> source, EObject target, EObject dropee) {
        if (source.size() > 1) {
            event.detail = 0;
            return false;
        }
        if (target.eContents().contains((Object)dropee) && (eventFeedback & 4) != 4 && (eventFeedback & 2) != 2) {
            event.detail = 0;
            return false;
        }
        if (target == dropee) {
            event.detail = 0;
            return false;
        }
        if (EcoreUtil.isAncestor((EObject)dropee, (EObject)target)) {
            event.detail = 0;
            return false;
        }
        if (!this.haveSameEContainer(source)) {
            return false;
        }
        return (eventFeedback & 4) != 4 && (eventFeedback & 2) != 2 || target.eContainer() == null || this.hasThisContainmentReference(target.eContainer(), dropee.eClass());
    }

    protected boolean haveSameEContainer(List<EObject> source) {
        EObject first = source.get(0);
        for (EObject me : source) {
            if (first.eContainer().equals(me.eContainer())) continue;
            return false;
        }
        return true;
    }

    protected boolean hasThisContainmentReference(EObject target, EClass refType) {
        boolean result = false;
        for (EReference ref : target.eClass().getEAllContainments()) {
            if (ref.isContainer() || !ref.getEReferenceType().equals(refType) && !ref.getEReferenceType().isSuperTypeOf(refType)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void dropMove(EObject targetContainer, EObject target, List<EObject> source, boolean after) {
        if (!this.getTargetRef(targetContainer, target).equals(this.getTargetRef(targetContainer, source.get(0)))) {
            return;
        }
        if (after) {
            this.dropAfter(targetContainer, target, source);
        } else {
            this.dropBefore(targetContainer, target, source);
        }
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }
}

