/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.connectionmanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.emf.emfstore.client.model.Configuration;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.exceptions.CertificateStoreException;
import org.eclipse.emf.emfstore.client.model.exceptions.InvalidCertificateException;
import org.eclipse.emf.emfstore.client.model.util.ConfigurationProvider;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPoint;
import org.eclipse.emf.emfstore.common.model.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyStoreManager {
    private static KeyStoreManager instance;
    public static final String KEYSTORENAME = "emfstoreClient.keystore";
    private static final String KEYSTOREPASSWORD = "654321";
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final String CIPHER_ALGORITHM = "RSA";
    public static final String DEFAULT_CERTIFICATE = "emfstore test certificate (do not use in production!)";
    private String defaultCertificate = null;
    private KeyStore keyStore;

    private KeyStoreManager() {
        this.setupKeys();
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        ConfigurationProvider provider = (ConfigurationProvider)new ExtensionPoint("org.eclipse.emf.emfstore.client.defaultConfigurationProvider").getClass("providerClass", ConfigurationProvider.class);
        if (provider == null) {
            return;
        }
        provider.initDefaultCertificates(this);
    }

    public static synchronized KeyStoreManager getInstance() {
        if (instance == null) {
            instance = new KeyStoreManager();
        }
        return instance;
    }

    public void setupKeys() {
        if (!this.keyStoreExists()) {
            File emfstoreDir = new File(Configuration.getWorkspaceDirectory());
            if (!emfstoreDir.exists()) {
                emfstoreDir.mkdir();
            }
            try {
                InputStream inputStream = this.getClass().getResourceAsStream(KEYSTORENAME);
                File clientKeyTarget = new File(String.valueOf(Configuration.getWorkspaceDirectory()) + KEYSTORENAME);
                FileUtil.copyFile((InputStream)inputStream, (File)clientKeyTarget);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.setProperty("javax.net.ssl.trustStore", this.getPathToKeyStore());
        System.setProperty("javax.net.ssl.keyStore", this.getPathToKeyStore());
        System.setProperty("javax.net.ssl.keyStorePassword", KEYSTOREPASSWORD);
    }

    public ArrayList<String> getCertificates() throws CertificateStoreException {
        this.loadKeyStore();
        ArrayList<String> certificates = new ArrayList<String>();
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String tmp = aliases.nextElement();
                certificates.add(tmp);
            }
        }
        catch (KeyStoreException e) {
            String message = "Loading certificates failed!";
            WorkspaceUtil.logException(message, e);
            throw new CertificateStoreException(message, e);
        }
        return certificates;
    }

    public void deleteCertificate(String alias) throws CertificateStoreException {
        if (this.isDefaultCertificate(alias)) {
            throw new CertificateStoreException("Cannot delete default certificate!");
        }
        this.loadKeyStore();
        try {
            this.keyStore.deleteEntry(alias);
            this.storeKeyStore();
        }
        catch (KeyStoreException e) {
            String message = "Deleting certificate failed!";
            WorkspaceUtil.logException(message, e);
            throw new CertificateStoreException(message, e);
        }
    }

    public void addCertificate(String alias, String path) throws InvalidCertificateException, CertificateStoreException {
        try {
            this.addCertificate(alias, new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            String message = "Storing certificate failed!";
            WorkspaceUtil.logException(message, e);
            throw new CertificateStoreException(message, e);
        }
    }

    public void addCertificate(String alias, InputStream certificate) throws InvalidCertificateException, CertificateStoreException {
        if (!this.isDefaultCertificate(alias)) {
            this.loadKeyStore();
            try {
                CertificateFactory factory = CertificateFactory.getInstance(CERTIFICATE_TYPE);
                Certificate newCertificate = factory.generateCertificate(certificate);
                this.keyStore.setCertificateEntry(alias, newCertificate);
                this.storeKeyStore();
            }
            catch (CertificateException e) {
                String message = "Please choose a valid certificate!";
                throw new InvalidCertificateException(message);
            }
            catch (KeyStoreException e) {
                String message = "Storing certificate failed!";
                WorkspaceUtil.logException(message, e);
                throw new CertificateStoreException(message, e);
            }
        }
    }

    private void storeKeyStore() throws CertificateStoreException {
        this.loadKeyStore();
        try {
            this.keyStore.store(new FileOutputStream(this.getPathToKeyStore()), KEYSTOREPASSWORD.toCharArray());
        }
        catch (KeyStoreException e) {
            String message = "Storing certificate failed!";
            WorkspaceUtil.logWarning(message, e);
            throw new CertificateStoreException(message, e);
        }
        catch (NoSuchAlgorithmException e) {
            String message = "Storing certificate failed!";
            WorkspaceUtil.logWarning(message, e);
            throw new CertificateStoreException(message, e);
        }
        catch (CertificateException e) {
            String message = "Storing certificate failed!";
            WorkspaceUtil.logWarning(message, e);
            throw new CertificateStoreException(message, e);
        }
        catch (FileNotFoundException e) {
            String message = "Storing certificate failed!";
            WorkspaceUtil.logWarning(message, e);
            throw new CertificateStoreException(message, e);
        }
        catch (IOException e) {
            String message = "Storing certificate failed!";
            WorkspaceUtil.logWarning(message, e);
            throw new CertificateStoreException(message, e);
        }
    }

    public void reloadKeyStore() throws CertificateStoreException {
        this.keyStore = null;
        this.loadKeyStore();
    }

    private void loadKeyStore() throws CertificateStoreException {
        if (this.keyStore == null) {
            try {
                this.keyStore = KeyStore.getInstance("JKS");
                this.keyStore.load(new FileInputStream(this.getPathToKeyStore()), KEYSTOREPASSWORD.toCharArray());
            }
            catch (KeyStoreException e) {
                String message = "Loading certificate failed!";
                WorkspaceUtil.logWarning(message, e);
                throw new CertificateStoreException(message, e);
            }
            catch (NoSuchAlgorithmException e) {
                String message = "Loading certificate failed!";
                WorkspaceUtil.logWarning(message, e);
                throw new CertificateStoreException(message, e);
            }
            catch (CertificateException e) {
                String message = "Loading certificate failed!";
                WorkspaceUtil.logWarning(message, e);
                throw new CertificateStoreException(message, e);
            }
            catch (FileNotFoundException e) {
                String message = "Loading certificate failed!";
                WorkspaceUtil.logWarning(message, e);
                throw new CertificateStoreException(message, e);
            }
            catch (IOException e) {
                String message = "Loading certificate failed!";
                WorkspaceUtil.logWarning(message, e);
                throw new CertificateStoreException(message, e);
            }
        }
    }

    public SSLContext getSSLContext() throws CertificateStoreException {
        try {
            this.loadKeyStore();
            KeyManagerFactory managerFactory = KeyManagerFactory.getInstance("SunX509");
            managerFactory.init(this.keyStore, KEYSTOREPASSWORD.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(this.keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(managerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateStoreException("Loading certificate failed!", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CertificateStoreException("Loading certificate failed!", e);
        }
        catch (KeyStoreException e) {
            throw new CertificateStoreException("Loading certificate failed!", e);
        }
        catch (KeyManagementException e) {
            throw new CertificateStoreException("Loading certificate failed!", e);
        }
    }

    public boolean keyStoreExists() {
        File keyStore = new File(this.getPathToKeyStore());
        return keyStore.exists();
    }

    public String getPathToKeyStore() {
        return String.valueOf(Configuration.getWorkspaceDirectory()) + KEYSTORENAME;
    }

    public String encrypt(String password, ServerInfo serverInfo) {
        try {
            Certificate publicKey = this.getCertificateForEncryption(serverInfo);
            PublicKey key = publicKey.getPublicKey();
            byte[] inpBytes = password.getBytes();
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(1, key);
            byte[] encryptededByteAr = cipher.doFinal(inpBytes);
            byte[] base64EncodedByteAr = Base64.encodeBase64((byte[])encryptededByteAr);
            return new String(base64EncodedByteAr);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (CertificateStoreException e) {
            e.printStackTrace();
        }
        WorkspaceUtil.logException("Couldn't encrypt password.", new CertificateStoreException("Couldn't encrypt password."));
        return "";
    }

    private Certificate getCertificateForEncryption(ServerInfo serverInfo) throws CertificateStoreException {
        Certificate publicKey = serverInfo == null ? this.getCertificate(this.getDefaultCertificate()) : this.getCertificate(serverInfo.getCertificateAlias());
        if (publicKey == null && (publicKey = this.getCertificate(this.getDefaultCertificate())) == null) {
            throw new CertificateStoreException("Unable to get certificate for password encryption.");
        }
        return publicKey;
    }

    public boolean isDefaultCertificate(String alias) {
        return this.getDefaultCertificate().equals(alias);
    }

    public String getDefaultCertificate() {
        if (this.defaultCertificate != null) {
            return this.defaultCertificate;
        }
        if (Configuration.isDeveloperVersion()) {
            return DEFAULT_CERTIFICATE;
        }
        return DEFAULT_CERTIFICATE;
    }

    public boolean contains(String alias) throws CertificateStoreException {
        return this.getCertificate(alias) != null;
    }

    public void setDefaultCertificate(String defaultCertificate) {
        this.defaultCertificate = defaultCertificate;
    }

    public Certificate getCertificate(String alias) throws CertificateStoreException {
        if (alias == null) {
            return null;
        }
        this.loadKeyStore();
        try {
            return this.keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new CertificateStoreException("Loading certificate failed!");
        }
    }

    public boolean certificateExists(String alias) throws CertificateStoreException {
        try {
            return this.getCertificate(alias) != null;
        }
        catch (CertificateStoreException e) {
            if (!(e.getCause() instanceof FileNotFoundException)) {
                throw e;
            }
            return false;
        }
    }
}

