/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.core.subinterfaces;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.emf.emfstore.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.server.ServerConfiguration;
import org.eclipse.emf.emfstore.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.FileNotOnServerException;
import org.eclipse.emf.emfstore.server.exceptions.FileTransferException;
import org.eclipse.emf.emfstore.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.server.filetransfer.FilePartitionerUtil;
import org.eclipse.emf.emfstore.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.server.model.ProjectId;

public class FileTransferSubInterfaceImpl
extends AbstractSubEmfstoreInterface {
    private static final String FILELOAD = "filetransfer";
    public static final String TEMP_FOLDER = "tmp";
    public static final String ATTACHMENT_FOLDER = "attachment";
    public static final String FILE_NAME_DELIMITER = "_";

    public FileTransferSubInterfaceImpl(AbstractEmfstoreInterface parentInterface) throws FatalEmfStoreException {
        super(parentInterface);
    }

    public FileChunk readChunk(ProjectId projectId, FileTransferInformation fileInformation) throws FileTransferException {
        File file;
        this.createDirectories(projectId);
        try {
            file = this.findFile(fileInformation, projectId);
        }
        catch (FileNotFoundException e) {
            throw new FileNotOnServerException(projectId, fileInformation.getFileIdentifier());
        }
        return FilePartitionerUtil.readChunk(file, fileInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileTransferInformation writeChunk(FileChunk fileChunk, ProjectId projectId) throws FileTransferException {
        Object object = MonitorProvider.getInstance().getMonitor(FILELOAD);
        synchronized (object) {
            File tmpFile;
            this.createDirectories(projectId);
            FileTransferInformation fileInfo = fileChunk.getFileInformation();
            try {
                tmpFile = fileChunk.getChunkNumber() == 0 ? this.getTempFile(fileInfo, projectId) : this.findFileInTemp(fileInfo, projectId);
            }
            catch (FileNotFoundException e) {
                throw new FileTransferException("The file has either been removed from the server or is not accessible!", e);
            }
            FilePartitionerUtil.writeChunk(tmpFile, fileChunk);
            if (fileChunk.isLast()) {
                try {
                    File attachmentFile = this.getCachedFile(fileInfo, projectId);
                    FileUtil.copyFile((File)tmpFile, (File)attachmentFile);
                    tmpFile.delete();
                }
                catch (IOException e) {
                    throw new FileTransferException("Could not move file to final destination!", e);
                }
            }
            return fileInfo;
        }
    }

    private void createDirectories(ProjectId projectId) {
        File createFolders = new File(this.getProjectAttachmentTempFolder(projectId));
        if (!createFolders.exists()) {
            createFolders.mkdirs();
        }
    }

    private File findFileInTemp(FileTransferInformation fileInfo, ProjectId projectId) throws FileNotFoundException {
        File file = this.getTempFile(fileInfo, projectId);
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException("Could not locate the specified file (" + fileInfo.getFileIdentifier() + ") in the temp folder.");
    }

    private File findFile(FileTransferInformation fileInfo, ProjectId projectId) throws FileNotFoundException {
        File file = this.getCachedFile(fileInfo, projectId);
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException("File " + fileInfo.getFileIdentifier() + " could not be located in the cache folder.");
    }

    private File getTempFile(FileTransferInformation fileInfo, ProjectId projectId) {
        return new File(String.valueOf(this.getProjectAttachmentTempFolder(projectId)) + File.separator + this.constructFileName(fileInfo));
    }

    private File getCachedFile(FileTransferInformation fileInfo, ProjectId projectId) {
        return new File(String.valueOf(this.getProjectAttachmentFolder(projectId)) + File.separator + this.constructFileName(fileInfo));
    }

    private String constructFileName(FileTransferInformation fileInfo) {
        return fileInfo.getFileIdentifier().getIdentifier();
    }

    private String getProjectAttachmentFolder(ProjectId projectId) {
        return String.valueOf(ServerConfiguration.getServerHome()) + "project-" + projectId.getId() + File.separator + ATTACHMENT_FOLDER;
    }

    private String getProjectAttachmentTempFolder(ProjectId projectId) {
        return String.valueOf(this.getProjectAttachmentFolder(projectId)) + File.separator + TEMP_FOLDER;
    }
}

