/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertiesComposite
extends Composite {
    private AdminBroker adminBroker;
    private Group grpTable;
    private Group grpAttributes;
    private Label lblName;
    private Text txtName;
    private Label lblDescription;
    private Text txtDescription;
    private TableViewer tableViewer;

    public PropertiesComposite(Composite parent, int style, AdminBroker adminBroker) {
        super(parent, style);
        this.adminBroker = adminBroker;
    }

    protected void createControls() {
        this.setLayout((Layout)new GridLayout());
        this.createSimpleAttributes();
        this.createTableGroup();
        this.createButtons((Composite)this.grpTable);
    }

    protected void createSimpleAttributes() {
        this.grpAttributes = new Group((Composite)this, 512);
        this.grpAttributes.setLayoutData((Object)new GridData(4, 4, true, false));
        this.grpAttributes.setText("Properties");
        this.grpAttributes.setLayout((Layout)new GridLayout(2, false));
        this.lblName = new Label((Composite)this.grpAttributes, 0);
        this.lblName.setText("Name: ");
        this.txtName = new Text((Composite)this.grpAttributes, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                PropertiesComposite.this.saveOrgUnitAttributes();
            }
        });
        this.lblDescription = new Label((Composite)this.grpAttributes, 0);
        this.lblDescription.setText("Description: ");
        this.txtDescription = new Text((Composite)this.grpAttributes, 2048);
        this.txtDescription.setLayoutData((Object)new GridData(768));
        this.txtDescription.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                PropertiesComposite.this.saveOrgUnitAttributes();
            }
        });
    }

    protected abstract void createTableGroup();

    protected void saveOrgUnitAttributes() {
    }

    protected void createTableGroup(String groupName) {
        this.grpTable = new Group((Composite)this, 0);
        this.grpTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.grpTable.setText(groupName);
        this.grpTable.setLayout((Layout)new GridLayout(5, true));
        this.createTableViewer((Composite)this.grpTable);
    }

    protected void createTableViewer(Composite parent) {
        int style = 68356;
        Table table = new Table(parent, style);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 5;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0x1000000, 0);
        column.setText("(/*\\)");
        column.setWidth(20);
        column = new TableColumn(table, 16384, 1);
        column.setText("Name");
        column.setWidth(100);
        column = new TableColumn(table, 16384, 2);
        column.setText("Description");
        column.setWidth(200);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.addDragNDropSupport();
    }

    protected void createButtons(Composite parent) {
        Button add = new Button(parent, 0x1000008);
        add.setText("Add...");
        GridData gridData = new GridData();
        gridData.widthHint = 80;
        gridData.horizontalAlignment = 3;
        gridData.horizontalSpan = 4;
        add.setLayoutData((Object)gridData);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesComposite.this.addNewOrgUnit();
            }
        });
        Button remove = new Button(parent, 0x1000008);
        remove.setText("Remove");
        gridData = new GridData(0x1000008);
        gridData.widthHint = 80;
        remove.setLayoutData((Object)gridData);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACOrgUnit ou = (ACOrgUnit)((IStructuredSelection)PropertiesComposite.this.tableViewer.getSelection()).getFirstElement();
                if (ou != null) {
                    PropertiesComposite.this.removeOrgUnit(ou);
                }
            }
        });
    }

    protected void addDragNDropSupport() {
        int ops = 2;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DragSourceListener dragListener = new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                PropertiesComposite.this.getTableViewer().refresh();
                PropertiesForm.setDragNDropObject(null);
            }

            public void dragSetData(DragSourceEvent event) {
                EObject eObject = PropertiesComposite.this.getSelectedItem();
                if (eObject != null && eObject instanceof ACOrgUnit) {
                    ACOrgUnit orgUnit = (ACOrgUnit)eObject;
                    PropertiesForm.setDragNDropObject((EObject)orgUnit);
                }
            }

            public void dragStart(DragSourceEvent event) {
            }
        };
        this.getTableViewer().addDragSupport(ops, transfers, dragListener);
    }

    protected void addNewOrgUnit() {
    }

    protected void addExistingOrgUnit(ACOrgUnit orgUnit) {
    }

    protected abstract void removeOrgUnit(ACOrgUnit var1);

    public abstract void updateControls(EObject var1);

    protected Object[] showDialog(Collection<ACOrgUnit> content, String title) {
        ElementListSelectionDialog dlg = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new ILabelProviderImplementation());
        dlg.setElements(content.toArray(new Object[content.size()]));
        dlg.setTitle(title);
        dlg.setBlockOnOpen(true);
        dlg.setMultipleSelection(true);
        Object[] result = new Object[]{};
        if (dlg.open() == 0) {
            result = dlg.getResult();
        }
        return result;
    }

    protected EObject getSelectedItem() {
        ACOrgUnit result = null;
        ISelection sel = this.tableViewer.getSelection();
        IStructuredSelection ssel = null;
        if (sel != null) {
            ssel = (IStructuredSelection)sel;
        }
        if (ssel != null) {
            Object obj = ssel.getFirstElement();
            result = (ACOrgUnit)obj;
        }
        return result;
    }

    protected Group getTableGroup() {
        return this.grpTable;
    }

    protected Group getAttributesGroup() {
        return this.grpAttributes;
    }

    protected AdminBroker getAdminBroker() {
        return this.adminBroker;
    }

    protected Text getTxtName() {
        return this.txtName;
    }

    protected Text getTxtDescription() {
        return this.txtDescription;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private final class ILabelProviderImplementation
    implements ILabelProvider {
        private ILabelProviderImplementation() {
        }

        public Image getImage(Object element) {
            if (element instanceof ACGroup) {
                return Activator.getImageDescriptor("icons/Group.gif").createImage();
            }
            return Activator.getImageDescriptor("icons/user.png").createImage();
        }

        public String getText(Object element) {
            return ((ACOrgUnit)element).getName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = new Object[]{};
            try {
                if (inputElement instanceof ACUser) {
                    List groups = PropertiesComposite.this.adminBroker.getGroups(((ACUser)inputElement).getId());
                    result = groups.toArray(new ACOrgUnit[groups.size()]);
                } else if (inputElement instanceof ACGroup) {
                    List members = PropertiesComposite.this.adminBroker.getMembers(((ACGroup)inputElement).getId());
                    result = members.toArray(new ACOrgUnit[members.size()]);
                } else if (inputElement instanceof ProjectInfo) {
                    List participants = PropertiesComposite.this.adminBroker.getParticipants(((ProjectInfo)inputElement).getProjectId());
                    result = participants.toArray(new ACOrgUnit[participants.size()]);
                }
            }
            catch (ESException e) {
                e.printStackTrace();
            }
            return result;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    extends AdapterFactoryLabelProvider {
        public TableLabelProvider() {
            super((AdapterFactory)Activator.getAdapterFactory());
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return super.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ACOrgUnit orgUnit = (ACOrgUnit)element;
            String result = "";
            switch (columnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    result = orgUnit.getName();
                    break;
                }
                case 2: {
                    result = orgUnit.getDescription();
                    break;
                }
            }
            return result;
        }
    }
}

