/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.configuration;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.model.util.DefaultWorkspaceLocationProvider;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.ESLocationProvider;

public class FileInfo {
    private static ESLocationProvider locationProvider;
    private static final String PLUGIN_BASEDIR = "pluginData";
    private static final String ERROR_DIAGNOSIS_DIR_NAME = "errorLog";
    private static final String MODEL_VERSION_FILENAME = "modelReleaseNumber";
    public static final String PROJECT_SPACE_FILE_NAME = "projectspace";
    public static final String PROJECT_SPCAE_FILE_EXTENSION;
    public static final String LOCAL_CHANGEPACKAGE_NAME = "operations";
    public static final String LOCAL_CHANGEPACKAGE_EXTENSION = ".eoc";
    public static final String PROJECT_FILE_NAME = "project";
    public static final String PROJECT_FILE_EXTENSION;
    public static final String PROJECT_SPACE_DIR_PREFIX = "ps-";

    static {
        PROJECT_SPCAE_FILE_EXTENSION = ExportImportDataUnits.ProjectSpace.getExtension();
        PROJECT_FILE_EXTENSION = ExportImportDataUnits.Project.getExtension();
    }

    public ESLocationProvider getLocationProvider() {
        if (locationProvider == null) {
            try {
                locationProvider = (ESLocationProvider)new ESExtensionPoint("org.eclipse.emf.emfstore.client.workspaceLocationProvider").setThrowException(true).getClass("providerClass", ESLocationProvider.class);
            }
            catch (ESExtensionPointException e) {
                ModelUtil.logInfo((String)e.getMessage());
                String message = "Error while instantiating location provider or none configured, switching to default location!";
                ModelUtil.logInfo((String)message);
            }
            if (locationProvider == null) {
                locationProvider = new DefaultWorkspaceLocationProvider();
            }
        }
        return locationProvider;
    }

    public String getWorkspaceDirectory() {
        String workspaceDirectory = this.getLocationProvider().getWorkspaceDirectory();
        File workspace = new File(workspaceDirectory);
        if (!workspace.exists()) {
            workspace.mkdirs();
        }
        if (!workspaceDirectory.endsWith(File.separator)) {
            return String.valueOf(workspaceDirectory) + File.separatorChar;
        }
        return workspaceDirectory;
    }

    public String getPluginDataBaseDirectory() {
        return String.valueOf(this.getWorkspaceDirectory()) + PLUGIN_BASEDIR + File.separatorChar;
    }

    public String getWorkspacePath() {
        return String.valueOf(this.getWorkspaceDirectory()) + "workspace.ucw";
    }

    public String getErrorLogDirectory() {
        String workspaceDirectory = this.getWorkspaceDirectory();
        File errorDiagnosisDir = new File(StringUtils.join(Arrays.asList(workspaceDirectory, ERROR_DIAGNOSIS_DIR_NAME), (char)File.separatorChar));
        if (!errorDiagnosisDir.exists()) {
            errorDiagnosisDir.mkdir();
            errorDiagnosisDir.deleteOnExit();
        }
        return errorDiagnosisDir.getAbsolutePath();
    }

    public String getModelReleaseNumberFileName() {
        return String.valueOf(this.getWorkspaceDirectory()) + MODEL_VERSION_FILENAME;
    }

    public String getProjectSpaceFileName() {
        return PROJECT_SPACE_FILE_NAME;
    }

    public String getProjectSpaceFileExtension() {
        return PROJECT_SPCAE_FILE_EXTENSION;
    }

    public String getLocalChangePackageFileName() {
        return LOCAL_CHANGEPACKAGE_NAME;
    }

    public String getLocalChangePackageFileExtension() {
        return LOCAL_CHANGEPACKAGE_EXTENSION;
    }

    public String getProjectSpaceDirectoryPrefix() {
        return PROJECT_SPACE_DIR_PREFIX;
    }

    public String getProjectFragmentFileName() {
        return PROJECT_FILE_NAME;
    }

    public String getProjectFragmentFileExtension() {
        return PROJECT_FILE_EXTENSION;
    }
}

