/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictContext;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.FeatureOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VisualConflict
extends Observable {
    private DecisionManager decisionManager;
    private ArrayList<ConflictOption> options;
    private ConflictOption solution;
    private ConflictContext conflictContext;
    private ConflictDescription conflictDescription;
    private Set<AbstractOperation> leftOperations;
    private Set<AbstractOperation> rightOperations;
    private boolean leftIsMy;
    private AbstractOperation rightOperation;
    private AbstractOperation leftOperation;
    private ConflictBucket conflictBucket;

    public VisualConflict(ConflictBucket conflictBucket, AbstractOperation leftOperation, AbstractOperation rightOperation, DecisionManager decisionManager, boolean leftIsMy, boolean init) {
        this(VisualConflict.set(leftOperation), VisualConflict.set(rightOperation), leftOperation, rightOperation, decisionManager, leftIsMy, init);
        this.conflictBucket = conflictBucket;
    }

    public VisualConflict(ConflictBucket conflictBucket, DecisionManager decisionManager) {
        this(conflictBucket, decisionManager, true, true);
    }

    public VisualConflict(ConflictBucket conflictBucket, DecisionManager decisionManager, boolean isLeftMy, boolean init) {
        this(isLeftMy ? conflictBucket.getMyOperations() : conflictBucket.getTheirOperations(), isLeftMy ? conflictBucket.getTheirOperations() : conflictBucket.getMyOperations(), isLeftMy ? conflictBucket.getMyOperation() : conflictBucket.getTheirOperation(), isLeftMy ? conflictBucket.getTheirOperation() : conflictBucket.getMyOperation(), decisionManager, isLeftMy, init);
        this.conflictBucket = conflictBucket;
    }

    private VisualConflict(Set<AbstractOperation> leftOperations, Set<AbstractOperation> rightOperations, AbstractOperation leftOperation, AbstractOperation rightOperation, DecisionManager decisionManager, boolean leftIsMy, boolean init) {
        this.leftOperation = leftOperation;
        this.rightOperation = rightOperation;
        this.leftIsMy = leftIsMy;
        this.leftOperations = leftOperations;
        this.rightOperations = rightOperations;
        this.decisionManager = decisionManager;
        if (init) {
            this.init();
        }
    }

    private static <T> Set<T> set(T object) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.add(object);
        return set;
    }

    public boolean isLeftMy() {
        return this.leftIsMy;
    }

    protected void init() {
        this.conflictContext = this.initConflictContext();
        this.conflictDescription = this.initConflictDescription();
        this.options = new ArrayList();
        this.initConflictOptions(this.options);
    }

    protected abstract void initConflictOptions(List<ConflictOption> var1);

    protected abstract ConflictDescription initConflictDescription(ConflictDescription var1);

    private ConflictDescription initConflictDescription() {
        ConflictDescription description = new ConflictDescription("");
        description.setImage("notset.gif");
        EObject modelElement = this.getDecisionManager().getModelElement(this.getMyOperation().getModelElementId());
        if (modelElement != null) {
            description.add("modelelement", modelElement);
        }
        if (this.getMyOperation() instanceof FeatureOperation) {
            description.add("feature", ((FeatureOperation)this.getMyOperation()).getFeatureName());
        }
        description.setDecisionManager(this.getDecisionManager());
        return this.initConflictDescription(description);
    }

    protected ConflictContext initConflictContext() {
        return new ConflictContext(this.getDecisionManager(), this.getMyOperation(), this.getTheirOperation());
    }

    public ConflictContext getConflictContext() {
        return this.conflictContext;
    }

    public ConflictDescription getConflictDescription() {
        return this.conflictDescription;
    }

    public List<ConflictOption> getOptions() {
        return this.options;
    }

    public boolean isResolved() {
        return this.solution != null;
    }

    public boolean hasDetails() {
        for (ConflictOption option : this.getOptions()) {
            if (!option.isDetailsProvider()) continue;
            return true;
        }
        return false;
    }

    public void setSolution(ConflictOption conflictOption) {
        this.solution = conflictOption;
        this.setChanged();
        this.notifyObservers();
    }

    public DecisionManager getDecisionManager() {
        return this.decisionManager;
    }

    public ConflictOption getSolution() {
        return this.solution;
    }

    public Set<AbstractOperation> getRejectedTheirs() {
        if (!this.isResolved()) {
            throw new IllegalStateException("Can't call this method, unless conflict is resolved.");
        }
        if (this.solution.getType() == ConflictOption.OptionType.TheirOperation) {
            return Collections.emptySet();
        }
        for (ConflictOption options : this.getOptions()) {
            if (options.getType() != ConflictOption.OptionType.TheirOperation) continue;
            return options.getOperations();
        }
        throw new IllegalStateException("No TheirOperations found.");
    }

    public Set<AbstractOperation> getAcceptedMine() {
        if (!this.isResolved()) {
            throw new IllegalStateException("Can't call this method, unless conflict is resolved.");
        }
        if (this.solution.getType() == ConflictOption.OptionType.TheirOperation) {
            return Collections.emptySet();
        }
        return this.solution.getOperations();
    }

    public ConflictOption getOptionOfType(ConflictOption.OptionType type) {
        return DecisionUtil.getConflictOptionByType(this.getOptions(), type);
    }

    public Set<AbstractOperation> getMyOperations() {
        return this.leftIsMy ? this.leftOperations : this.rightOperations;
    }

    public Set<AbstractOperation> getTheirOperations() {
        return !this.leftIsMy ? this.leftOperations : this.rightOperations;
    }

    public Set<AbstractOperation> getLeftOperations() {
        return this.leftOperations;
    }

    public Set<AbstractOperation> getRightOperations() {
        return this.rightOperations;
    }

    public AbstractOperation getLeftOperation() {
        return this.leftOperation;
    }

    public AbstractOperation getRightOperation() {
        return this.rightOperation;
    }

    public AbstractOperation getMyOperation() {
        return this.leftIsMy ? this.leftOperation : this.rightOperation;
    }

    public AbstractOperation getTheirOperation() {
        return !this.leftIsMy ? this.leftOperation : this.rightOperation;
    }

    public <T> T getMyOperation(Class<T> clazz) {
        return (T)this.getMyOperation();
    }

    public <T> T getTheirOperation(Class<T> clazz) {
        return (T)this.getTheirOperation();
    }

    public void resolve() {
        this.conflictBucket.resolveConflict(this.getAcceptedMine(), this.getRejectedTheirs());
    }

    public boolean isLeftIsMy() {
        return this.leftIsMy;
    }

    public void setLeftIsMy(boolean leftIsMy) {
        this.leftIsMy = leftIsMy;
    }
}

