/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictContext;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiReferenceConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.SingleReferenceConflict;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.ReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.SingleReferenceOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceCompositeConflict
extends VisualConflict {
    private final VisualConflict conflict;

    public ReferenceCompositeConflict(boolean underlyingSingleConflict, ConflictBucket conflictBucket, ReferenceOperation myOperation, AbstractOperation theirOperation, DecisionManager decisionManager) {
        super(conflictBucket, decisionManager, true, false);
        if (underlyingSingleConflict) {
            this.conflict = new SingleReferenceConflict(conflictBucket, (AbstractOperation)((SingleReferenceOperation)myOperation), (AbstractOperation)((SingleReferenceOperation)theirOperation), decisionManager);
        } else {
            this.conflict = this.createMultiMultiConflict(conflictBucket, (MultiReferenceOperation)myOperation, (MultiReferenceOperation)theirOperation, decisionManager);
            this.setLeftIsMy(((MultiReferenceOperation)conflictBucket.getMyOperation()).isAdd());
        }
        this.init();
    }

    private VisualConflict createMultiMultiConflict(ConflictBucket conflictBucket, MultiReferenceOperation my, MultiReferenceOperation their, DecisionManager decisionManager) {
        if (my.isAdd()) {
            return new MultiReferenceConflict(conflictBucket, (AbstractOperation)my, (AbstractOperation)their, decisionManager, true);
        }
        return new MultiReferenceConflict(conflictBucket, (AbstractOperation)their, (AbstractOperation)my, decisionManager, false);
    }

    @Override
    protected ConflictContext initConflictContext() {
        return this.conflict.getConflictContext();
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription desc) {
        return this.conflict.getConflictDescription();
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        for (ConflictOption option : this.conflict.getOptions()) {
            if (option.getType() == ConflictOption.OptionType.MyOperation) {
                option.addOperations(this.getLeftOperations());
            } else if (option.getType() == ConflictOption.OptionType.TheirOperation) {
                option.addOperations(this.getRightOperations());
            }
            options.add(option);
        }
    }
}

