/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.common;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ui.ESClassFilter;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.OperationUtil;

public final class EClassFilter {
    public static final EClassFilter INSTANCE = new EClassFilter();
    private Set<EClass> filteredEClasses = new LinkedHashSet<EClass>();
    private String filterLabel;

    private EClassFilter() {
        this.initFilteredEClasses();
    }

    private void initFilteredEClasses() {
        ESExtensionPoint extensionPoint = new ESExtensionPoint("org.eclipse.emf.emfstore.client.ui.filteredTypes");
        if (extensionPoint.size() == 0) {
            return;
        }
        for (ESExtensionElement element : extensionPoint.getExtensionElements()) {
            ESClassFilter filter = (ESClassFilter)element.getClass("filteredTypes", ESClassFilter.class);
            if (filter != null) {
                this.filteredEClasses.addAll(filter.getFilteredEClasses());
            }
            if (this.filterLabel != null) continue;
            this.filterLabel = filter.getLabel();
        }
    }

    public boolean isEnabled() {
        return this.filteredEClasses.size() > 0;
    }

    public boolean isFilteredEClass(EClass eClass) {
        return this.filteredEClasses.contains(eClass);
    }

    public boolean involvesOnlyFilteredEClasses(ModelElementIdToEObjectMapping idToEObjectMapping, AbstractOperation operation) {
        if (operation instanceof CompositeOperation) {
            CompositeOperation composite = (CompositeOperation)operation;
            for (AbstractOperation op : composite.getSubOperations()) {
                if (this.involvesOnlyFilteredEClasses(idToEObjectMapping, op)) continue;
                return false;
            }
            return true;
        }
        if (OperationUtil.isCreateDelete((AbstractOperation)operation)) {
            CreateDeleteOperation createDeleteOperation = (CreateDeleteOperation)operation;
            for (EObject modelElement : createDeleteOperation.getEObjectToIdMap().keySet()) {
                if (modelElement != null && !this.isFilteredEClass(modelElement.eClass())) {
                    return false;
                }
                if (modelElement != null) continue;
                return false;
            }
            return true;
        }
        ModelElementId id = operation.getModelElementId();
        EObject modelElement = idToEObjectMapping.get((Object)id);
        if (modelElement == null) {
            return false;
        }
        return this.isFilteredEClass(modelElement.eClass());
    }

    public String getFilterLabel() {
        return this.filterLabel;
    }
}

