/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.text.MessageFormat;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.callbacks.ESCommitCallback;
import org.eclipse.emf.emfstore.client.util.ESVoidCallable;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.common.model.ESModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.controller.UIUpdateProjectController;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.CommitDialog;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.impl.ESModelElementIdToEObjectMappingImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESChangePackageImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessageFactory;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.exceptions.ESUpdateRequiredException;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UICommitProjectController
extends AbstractEMFStoreUIController<ESPrimaryVersionSpec>
implements ESCommitCallback {
    private final ESLocalProject localProject;
    private int dialogReturnValue;

    public UICommitProjectController(Shell shell, ESLocalProject localProject) {
        super(shell, false, true);
        this.localProject = localProject;
    }

    public void noLocalChanges(ESLocalProject localProject) {
        RunInUI.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MessageDialog.openInformation((Shell)UICommitProjectController.this.getShell(), (String)Messages.UICommitProjectController_NoLocalChanges_Title, (String)Messages.UICommitProjectController_NoLocalChanges_Message);
                return null;
            }
        });
    }

    public boolean baseVersionOutOfDate(ESLocalProject projectSpace, IProgressMonitor progressMonitor) {
        final String message = Messages.UICommitProjectController_ProjectOutdated;
        boolean shouldUpdate = RunInUI.runWithResult(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return MessageDialog.openConfirm((Shell)UICommitProjectController.this.getShell(), (String)Messages.UICommitProjectController_Confirmation, (String)message);
            }
        });
        if (shouldUpdate) {
            ESPrimaryVersionSpec baseVersion = this.localProject.getBaseVersion();
            int baseVersionIdentifier = baseVersion.getIdentifier();
            ESPrimaryVersionSpec version = (ESPrimaryVersionSpec)new UIUpdateProjectController(this.getShell(), projectSpace).executeSub(progressMonitor);
            if (version.equals(baseVersion) || version.getIdentifier() == baseVersionIdentifier) {
                return false;
            }
        }
        return shouldUpdate;
    }

    public boolean inspectChanges(ESLocalProject localProject, ESChangePackage changePackage, ESModelElementIdToEObjectMapping idToEObjectMapping) {
        final ChangePackage internalChangePackage = (ChangePackage)((ESChangePackageImpl)changePackage).toInternalAPI();
        final ProjectSpace projectSpace = (ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI();
        if (internalChangePackage.getOperations().isEmpty()) {
            RunInUI.run(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MessageDialog.openInformation((Shell)UICommitProjectController.this.getShell(), (String)"No local changes", (String)(String.valueOf(Messages.UICommitProjectController_NoPendingChanges_0) + Messages.UICommitProjectController_NoPendingChanges_1 + Messages.UICommitProjectController_NoPendingChanges_2));
                    return null;
                }
            });
            return false;
        }
        final CommitDialog commitDialog = new CommitDialog(this.getShell(), internalChangePackage, projectSpace, (ModelElementIdToEObjectMapping)((ESModelElementIdToEObjectMappingImpl)idToEObjectMapping).toInternalAPI());
        this.dialogReturnValue = RunInUI.runWithResult(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return commitDialog.open();
            }
        });
        if (this.dialogReturnValue == 0) {
            RunESCommand.run((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    String commitText = commitDialog.getLogText();
                    EList oldLogMessages = projectSpace.getOldLogMessages();
                    if (oldLogMessages.size() == 0 || !oldLogMessages.contains((Object)commitText)) {
                        oldLogMessages.add((Object)commitText);
                    } else if (oldLogMessages.contains((Object)commitText)) {
                        oldLogMessages.move(oldLogMessages.size() - 1, oldLogMessages.indexOf((Object)commitText));
                    }
                    if (projectSpace.getOldLogMessages().size() > 10) {
                        projectSpace.getOldLogMessages().remove(0);
                    }
                    internalChangePackage.setLogMessage(LogMessageFactory.INSTANCE.createLogMessage(commitDialog.getLogText(), projectSpace.getUsersession().getUsername()));
                    return null;
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public ESPrimaryVersionSpec doRun(IProgressMonitor progressMonitor) throws ESException {
        try {
            ESPrimaryVersionSpec primaryVersionSpec = this.localProject.commit(null, (ESCommitCallback)this, progressMonitor);
            return primaryVersionSpec;
        }
        catch (ESUpdateRequiredException eSUpdateRequiredException) {
        }
        catch (ESException e) {
            WorkspaceUtil.logException((String)e.getMessage(), (Exception)((Object)e));
            if (e.getCause() instanceof Error) {
                RunInUI.run((Callable<Void>)new ESVoidCallable(){

                    public void run() {
                        MessageDialog.openError((Shell)UICommitProjectController.this.getShell(), (String)Messages.UICommitProjectController_CommitFailed, (String)MessageFormat.format("A serious {0} occurred during commit. The failure message was: {1}\nPlease consult your administrator.", e.getCause().getMessage(), e.getCause().getClass().getSimpleName()));
                    }
                });
            }
            RunInUI.run(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MessageDialog.openError((Shell)UICommitProjectController.this.getShell(), (String)Messages.UICommitProjectController_CommitFailed, (String)e.getMessage());
                    return null;
                }
            });
        }
        return null;
    }
}

