/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.cases;

import java.text.MessageFormat;
import java.util.concurrent.Callable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.test.common.cases.ESTest;
import org.eclipse.emf.emfstore.client.util.ESVoidCallable;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.model.impl.WorkspaceBase;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.SerializationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class ComparingESTest
extends ESTest {
    private static final String CLONED_PROJECT_NAME = "ClonedProject";
    private ProjectSpaceBase clonedProjectSpace;
    private boolean isCompareAtEnd;

    public void disableCompareAtEnd() {
        this.isCompareAtEnd = false;
    }

    public ProjectSpaceBase getClonedProjectSpace() {
        return this.clonedProjectSpace;
    }

    @Before
    public void before() {
        super.before();
        this.isCompareAtEnd = true;
        RunESCommand.run((Callable)new ESVoidCallable(){

            public void run() {
                WorkspaceBase workspace = (WorkspaceBase)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI();
                workspace.cloneProject(ComparingESTest.CLONED_PROJECT_NAME, ComparingESTest.this.getProject());
                ComparingESTest.this.clonedProjectSpace = (ProjectSpaceBase)workspace.cloneProject(ComparingESTest.CLONED_PROJECT_NAME, ComparingESTest.this.getProject());
                Assert.assertTrue((boolean)ModelUtil.areEqual((IdEObjectCollection)ComparingESTest.this.getProject(), (IdEObjectCollection)ComparingESTest.this.clonedProjectSpace.getProject()));
            }
        });
    }

    public void clearOperations() {
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (ComparingESTest.this.isCompareAtEnd) {
                    ComparingESTest.this.clonedProjectSpace.applyOperations(ComparingESTest.this.getProjectSpace().getOperations(), false);
                    ComparingESTest.this.clonedProjectSpace.applyOperations(ComparingESTest.this.getProjectSpace().getOperationManager().clearOperations(), false);
                } else {
                    ComparingESTest.this.getProjectSpace().getOperationManager().clearOperations();
                }
                ComparingESTest.this.getProjectSpace().getOperations().clear();
                return null;
            }
        });
    }

    @After
    public void after() {
        boolean areEqual = false;
        this.getProjectSpace().save();
        String projectString = "";
        String clonedProjectString = "";
        if (this.isCompareAtEnd) {
            this.clonedProjectSpace.applyOperations(this.getProjectSpace().getOperations(), true);
            try {
                projectString = ModelUtil.eObjectToString((EObject)this.getProjectSpace().getProject());
                clonedProjectString = ModelUtil.eObjectToString((EObject)this.clonedProjectSpace.getProject());
                areEqual = ModelUtil.areEqual((IdEObjectCollection)this.getProject(), (IdEObjectCollection)this.clonedProjectSpace.getProject());
            }
            catch (SerializationException ex) {
                Assert.fail((String)ex.getMessage());
            }
            this.clonedProjectSpace.save();
            Assert.assertTrue((String)MessageFormat.format("Projects are not equal.\n\n{0}\n\n{1}", projectString, clonedProjectString), (boolean)areEqual);
        }
        super.after();
    }
}

