/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.filetransfer;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileDownloadJob;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileDownloadStatus;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileInformation;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileTransferCacheManager;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileUploadJob;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.Messages;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.util.ProjectSpaceUploadQueue;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.util.SimpleUploadQueue;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.util.UploadQueue;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreClientUtil;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.server.exceptions.FileTransferException;
import org.eclipse.emf.emfstore.internal.server.model.FileIdentifier;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;

public class FileTransferManager {
    private static final String LOGGING_PREFIX = "UPLOAD";
    private final FileTransferCacheManager cacheManager;
    private final ProjectSpaceBase projectSpace;
    private final UploadQueue uploadQueue;
    private ProjectId projectId;
    private Usersession usersession;

    public FileTransferManager(ProjectSpaceBase projectSpaceImpl) {
        this.cacheManager = new FileTransferCacheManager(projectSpaceImpl);
        this.uploadQueue = new ProjectSpaceUploadQueue(projectSpaceImpl);
        this.projectSpace = projectSpaceImpl;
    }

    public FileTransferManager(ProjectId projectId, Usersession usersession) {
        this.projectId = projectId;
        this.usersession = usersession;
        this.cacheManager = new FileTransferCacheManager();
        this.uploadQueue = new SimpleUploadQueue();
        this.projectSpace = null;
    }

    public FileIdentifier addFile(File file) throws FileTransferException {
        return this.addFile(file, null);
    }

    public FileIdentifier addFile(File file, String id) throws FileTransferException {
        if (file == null) {
            throw new FileTransferException(Messages.FileTransferManager_FileIsNull);
        }
        if (file.isDirectory()) {
            throw new FileTransferException(String.valueOf(Messages.FileTransferManager_UploadIsDirectory) + file.getAbsolutePath());
        }
        if (!file.exists()) {
            throw new FileTransferException(String.valueOf(Messages.FileTransferManager_FileDoesNotExist) + file.getAbsolutePath());
        }
        FileIdentifier identifier = ModelFactory.eINSTANCE.createFileIdentifier();
        if (id != null) {
            identifier.setIdentifier(id);
        }
        try {
            this.cacheManager.cacheFile(file, identifier);
        }
        catch (IOException e) {
            throw new FileTransferException(String.valueOf(Messages.FileTransferManager_ExceptionDuringCaching) + e.getMessage(), (Throwable)e);
        }
        this.addToCommitQueue(identifier);
        return identifier;
    }

    private void addToCommitQueue(FileIdentifier identifier) {
        for (FileIdentifier f : this.uploadQueue.getPendingUploads()) {
            if (!f.getIdentifier().equals(identifier.getIdentifier())) continue;
            return;
        }
        this.uploadQueue.add(identifier);
    }

    public void uploadQueuedFiles(IProgressMonitor progress) {
        try {
            List<FileIdentifier> uploads = this.uploadQueue.getPendingUploads();
            while (!uploads.isEmpty()) {
                FileIdentifier fi = uploads.get(0);
                if (!this.cacheManager.hasCachedFile(fi)) {
                    WorkspaceUtil.logException(MessageFormat.format(String.valueOf(Messages.FileTransferManager_FileNoInCache_1) + Messages.FileTransferManager_FileNoInCache_2 + Messages.FileTransferManager_FileNoInCache_3, fi.getIdentifier()), null);
                    this.uploadQueue.remove(fi);
                    continue;
                }
                EMFStoreClientUtil.logProjectDetails(LOGGING_PREFIX, MessageFormat.format("Uploading file with identifier {0}", fi.getIdentifier()));
                FileUploadJob job = new FileUploadJob(this, fi, true);
                IStatus result = job.run(progress);
                if (job.getException() != null) {
                    WorkspaceUtil.logException(Messages.FileTransferManager_ExceptionDuringUpload, job.getException());
                    return;
                }
                if (result.getCode() != 8) continue;
                return;
            }
        }
        catch (FileTransferException e) {
            WorkspaceUtil.logException(Messages.FileTransferManager_UploadFailed, (Exception)((Object)e));
        }
    }

    public FileDownloadStatus getFile(FileIdentifier fileIdentifier, boolean isTriggeredByUI, boolean forceDownload) throws FileTransferException {
        if (fileIdentifier == null) {
            throw new FileTransferException(Messages.FileTransferManager_FileIdentifierIsNull);
        }
        if (forceDownload || !this.cacheManager.hasCachedFile(fileIdentifier)) {
            return this.startDownload(fileIdentifier, isTriggeredByUI);
        }
        return FileDownloadStatus.Factory.createAlreadyFinished(this.getProjectSpace(), fileIdentifier, this.cacheManager.getCachedFile(fileIdentifier));
    }

    public FileDownloadStatus getFile(FileIdentifier fileIdentifier, boolean isTriggeredByUI) throws FileTransferException {
        return this.getFile(fileIdentifier, isTriggeredByUI, false);
    }

    private FileDownloadStatus startDownload(FileIdentifier fileIdentifier, boolean isTriggeredByUI) {
        FileDownloadStatus fds = FileDownloadStatus.Factory.createNew(this.getProjectSpace(), fileIdentifier);
        FileDownloadJob job = new FileDownloadJob(fds, this, fileIdentifier, isTriggeredByUI);
        job.schedule();
        return fds;
    }

    FileTransferCacheManager getCache() {
        return this.cacheManager;
    }

    private int getWaitingUploadIndex(FileIdentifier fileId) {
        if (fileId == null) {
            return -1;
        }
        int i = 0;
        for (FileIdentifier upload : this.uploadQueue.getPendingUploads()) {
            if (upload.getIdentifier().equals(fileId.getIdentifier())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void removeWaitingUpload(FileIdentifier fileId) throws FileTransferException {
        int index = this.getWaitingUploadIndex(fileId);
        if (index == -1) {
            throw new FileTransferException(MessageFormat.format(Messages.FileTransferManager_NoUploadPendingWithThatId, fileId));
        }
        this.uploadQueue.remove(index);
    }

    public boolean hasWaitingUpload(FileIdentifier fileIdentifier) {
        return this.getWaitingUploadIndex(fileIdentifier) != -1;
    }

    public void cancelPendingUpload(FileIdentifier fileIdentifier) {
        try {
            this.removeWaitingUpload(fileIdentifier);
        }
        catch (FileTransferException fileTransferException) {
            return;
        }
        this.cacheManager.removeCachedFile(fileIdentifier);
    }

    public FileInformation getFileInfo(FileIdentifier fileIdentifier) {
        return new FileInformation(fileIdentifier, this);
    }

    ProjectSpaceBase getProjectSpace() {
        return this.projectSpace;
    }

    ProjectId getProjectId() {
        if (this.getProjectSpace() != null) {
            return this.getProjectSpace().getProjectId();
        }
        return this.projectId;
    }

    Usersession getUsersession() {
        if (this.getProjectSpace() != null) {
            return this.getProjectSpace().getUsersession();
        }
        return this.usersession;
    }
}

