/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.conflictDetection;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.impl.ESModelElementIdToEObjectMappingImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.OperationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementIdToEObjectMappingImpl
implements ModelElementIdToEObjectMapping {
    private final Map<String, EObject> idToEObjectMapping;
    private final ModelElementIdToEObjectMapping delegateMapping;
    private ESModelElementIdToEObjectMappingImpl apiImpl;

    public ModelElementIdToEObjectMappingImpl(ModelElementIdToEObjectMapping mapping) {
        this.delegateMapping = mapping;
        this.idToEObjectMapping = new LinkedHashMap<String, EObject>();
    }

    public ModelElementIdToEObjectMappingImpl(ModelElementIdToEObjectMapping mapping, List<ChangePackage> changePackages) {
        this(mapping);
        for (ChangePackage changePackage : changePackages) {
            this.put(changePackage);
        }
    }

    public ModelElementIdToEObjectMappingImpl(ModelElementIdToEObjectMapping mapping, List<AbstractOperation> operationsList1, List<AbstractOperation> operationsList2) {
        this(mapping);
        this.put((Collection<AbstractOperation>)operationsList1);
        this.put((Collection<AbstractOperation>)operationsList2);
    }

    public ModelElementIdToEObjectMappingImpl(Project project, ChangePackage changePackage) {
        this((ModelElementIdToEObjectMapping)project);
        this.put(changePackage);
    }

    public void put(List<ChangePackage> changePackages) {
        for (ChangePackage changePackage : changePackages) {
            this.put(changePackage);
        }
    }

    public void put(ChangePackage changePackage) {
        this.put((Collection<AbstractOperation>)changePackage.getOperations());
    }

    public void put(Collection<AbstractOperation> operations) {
        for (AbstractOperation op : operations) {
            this.scanOperationIntoMapping(op);
        }
    }

    private void scanOperationIntoMapping(AbstractOperation operation) {
        if (operation instanceof CompositeOperation) {
            CompositeOperation composite = (CompositeOperation)operation;
            for (AbstractOperation subOp : composite.getSubOperations()) {
                this.scanOperationIntoMapping(subOp);
            }
            return;
        }
        if (OperationUtil.isCreateDelete((AbstractOperation)operation)) {
            CreateDeleteOperation createDeleteOperation = (CreateDeleteOperation)operation;
            for (EObject modelElement : createDeleteOperation.getEObjectToIdMap().keySet()) {
                this.idToEObjectMapping.put(((ModelElementId)createDeleteOperation.getEObjectToIdMap().get((Object)modelElement)).toString(), modelElement);
            }
        }
    }

    public EObject get(ModelElementId modelElementId) {
        EObject eObject = this.delegateMapping.get((Object)modelElementId);
        if (eObject != null) {
            return eObject;
        }
        if (modelElementId == null) {
            return null;
        }
        return this.idToEObjectMapping.get(modelElementId.toString());
    }

    public ESModelElementIdToEObjectMappingImpl toAPI() {
        if (this.apiImpl == null) {
            this.apiImpl = this.createAPI();
        }
        return this.apiImpl;
    }

    public ESModelElementIdToEObjectMappingImpl createAPI() {
        return new ESModelElementIdToEObjectMappingImpl((ModelElementIdToEObjectMapping)this);
    }
}

