/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.helper;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Version;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.impl.CreateDeleteOperationImpl;
import org.eclipse.emf.emfstore.server.ESServerURIUtil;

public class ResourceHelper {
    private final ServerSpace serverSpace;

    public ResourceHelper(ServerSpace serverSpace) throws FatalESException {
        this.serverSpace = serverSpace;
    }

    public void createResourceForProjectHistory(ProjectHistory projectHistory) throws FatalESException {
        URI projectHistoryURI = ESServerURIUtil.createProjectHistoryURI(projectHistory.getProjectId());
        this.saveInResource((EObject)projectHistory, projectHistoryURI);
    }

    public void createResourceForVersion(Version version, ProjectId projectId) throws FatalESException {
        URI versionURI = ESServerURIUtil.createVersionURI(projectId, version.getPrimarySpec());
        this.saveInResource((EObject)version, versionURI);
    }

    public void createResourceForProject(Project project, PrimaryVersionSpec versionId, ProjectId projectId) throws FatalESException {
        URI projectStateURI = ESServerURIUtil.createProjectStateURI(projectId, versionId);
        this.saveInResourceWithProject((EObject)project, projectStateURI, project);
    }

    public void createResourceForChangePackage(ChangePackage changePackage, PrimaryVersionSpec versionId, ProjectId projectId) throws FatalESException {
        URI changePackageURI = ESServerURIUtil.createChangePackageURI(projectId, versionId);
        ArrayList<Map.Entry> ignoredDatatypes = new ArrayList<Map.Entry>();
        for (AbstractOperation op : changePackage.getOperations()) {
            if (!(op instanceof CreateDeleteOperation)) continue;
            CreateDeleteOperation createDeleteOp = (CreateDeleteOperation)op;
            for (Map.Entry e : ((CreateDeleteOperationImpl)createDeleteOp).getEObjectToIdMap().entrySet()) {
                EObject modelElement = (EObject)e.getKey();
                if (!ModelUtil.isIgnoredDatatype((EObject)modelElement)) continue;
                ignoredDatatypes.add(e);
            }
            createDeleteOp.getEObjectToIdMap().removeAll(ignoredDatatypes);
        }
        this.saveInResource((EObject)changePackage, changePackageURI);
    }

    public void deleteProjectState(Version version, ProjectId projectId) {
        try {
            version.getProjectState().eResource().delete(null);
        }
        catch (IOException e) {
            ModelUtil.logWarning((String)("Could not delete project state with id " + projectId.getId() + " and version " + version.getPrimarySpec().getIdentifier() + "."), (Throwable)e);
        }
    }

    public int getXFromPolicy(String policy, String defaultPolicy, boolean allowZero) {
        int x;
        try {
            x = Integer.parseInt(ServerConfiguration.getProperties().getProperty(policy, defaultPolicy));
        }
        catch (NumberFormatException e) {
            x = 1;
            ModelUtil.logWarning((String)("Couldn't read property: " + policy + " , x set to 1"), (Throwable)e);
        }
        if (x < 0) {
            x = 1;
            ModelUtil.logWarning((String)("Policy " + policy + " with x < 0 not possible, x set to 1."));
        }
        if (!allowZero && x == 0) {
            x = 1;
            ModelUtil.logWarning((String)("Policy " + policy + " with x = 0 not possible, x set to 1."));
        }
        return x;
    }

    public String getProjectFolder(ProjectId projectId) {
        return String.valueOf(ServerConfiguration.getServerHome()) + "project-" + projectId.getId() + File.separatorChar;
    }

    private void saveInResource(EObject obj, URI resourceURI) throws FatalESException {
        Resource resource = this.serverSpace.eResource().getResourceSet().createResource(resourceURI);
        resource.getContents().add((Object)obj);
        this.save(obj);
    }

    private void saveInResourceWithProject(EObject obj, URI resourceURI, Project project) throws FatalESException {
        Resource resource = this.serverSpace.eResource().getResourceSet().createResource(resourceURI);
        resource.getContents().add((Object)obj);
        if (resource instanceof XMIResource) {
            XMIResource xmiResource = (XMIResource)resource;
            for (EObject modelElement : project.getAllModelElements()) {
                ModelElementId modelElementId = project.getModelElementId(modelElement);
                xmiResource.setID(modelElement, modelElementId.getId());
            }
        }
        this.save(obj);
    }

    public void saveWithProject(EObject eObject, Project project) throws FatalESException {
        Resource resource = eObject.eResource();
        if (resource instanceof XMIResource) {
            XMIResource xmiResource = (XMIResource)resource;
            for (EObject modelElement : project.getAllModelElements()) {
                ModelElementId modelElementId = project.getModelElementId(modelElement);
                xmiResource.setID(modelElement, modelElementId.getId());
            }
        }
        this.save(eObject);
    }

    public void save(EObject object) throws FatalESException {
        try {
            ModelUtil.saveResource((Resource)object.eResource(), (IResourceLogger)ModelUtil.getResourceLogger());
        }
        catch (Exception e) {
            throw new FatalESException("Couldn't save data in database.", e);
        }
    }

    public void saveAll() throws FatalESException {
        for (Resource res : this.serverSpace.eResource().getResourceSet().getResources()) {
            if (!res.isLoaded() || !res.isModified()) continue;
            try {
                ModelUtil.saveResource((Resource)res, (IResourceLogger)ModelUtil.getResourceLogger());
            }
            catch (Exception e) {
                throw new FatalESException("Couldn't save data in database.", e);
            }
        }
    }
}

