/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core;

import com.google.common.base.Optional;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.ESCollections;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.EMFStore;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AccessControl;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.Messages;
import org.eclipse.emf.emfstore.internal.server.core.ServerCallObserverNotifier;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.ChangePackageFragmentProviderAdapter;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.ChangePackageFragmentUploadAdapter;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.EMFStorePropertiesSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.EMFStoreVersionSubInterface;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.EPackageSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.FileTransferSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.HistorySubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.ProjectPropertiesSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.ProjectSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.UserSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.VersionSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageProxy;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.server.auth.ESMethod;
import org.eclipse.emf.emfstore.server.auth.ESMethodInvocation;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESSessionId;
import org.eclipse.emf.emfstore.server.observer.ESServerCallObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFStoreImpl
extends AbstractEmfstoreInterface
implements InvocationHandler {
    private static final String CLASS = "class";
    private static final String ORG_ECLIPSE_EMF_EMFSTORE_SERVER_SERVER_CALL_OBSERVER = "org.eclipse.emf.emfstore.server.serverCallObserver";
    private EnumMap<ESMethod.MethodId, SubInterfaceMethod> subInterfaceMethods;
    private final Set<ESServerCallObserver> serverCallObservers = this.initServerCallObservers();

    public EMFStoreImpl(ServerSpace serverSpace, AccessControl accessControl) throws FatalESException {
        super(serverSpace, accessControl);
    }

    private Set<ESServerCallObserver> initServerCallObservers() {
        LinkedHashSet<ESServerCallObserver> result = new LinkedHashSet<ESServerCallObserver>();
        for (ESExtensionElement e : new ESExtensionPoint(ORG_ECLIPSE_EMF_EMFSTORE_SERVER_SERVER_CALL_OBSERVER).getExtensionElements()) {
            ESServerCallObserver observer = (ESServerCallObserver)e.getClass(CLASS, ESServerCallObserver.class);
            if (observer == null) continue;
            result.add(observer);
        }
        return result;
    }

    @Override
    protected void initSubInterfaces() throws FatalESException {
        this.subInterfaceMethods = new EnumMap(ESMethod.MethodId.class);
        this.addSubInterface(new HistorySubInterfaceImpl(this));
        this.addSubInterface(new ProjectSubInterfaceImpl(this));
        this.addSubInterface(new UserSubInterfaceImpl(this));
        this.addSubInterface(new VersionSubInterfaceImpl(this));
        this.addSubInterface(new FileTransferSubInterfaceImpl(this));
        this.addSubInterface(new ProjectPropertiesSubInterfaceImpl(this));
        this.addSubInterface(new EMFStorePropertiesSubInterfaceImpl(this));
        this.addSubInterface(new EPackageSubInterfaceImpl(this));
        this.addSubInterface(new EMFStoreVersionSubInterface(this));
    }

    @Override
    protected void addSubInterface(AbstractSubEmfstoreInterface iface) {
        super.addSubInterface(iface);
        Method[] methodArray = iface.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            ESMethod implSpec = method.getAnnotation(ESMethod.class);
            if (implSpec != null) {
                this.subInterfaceMethods.put(implSpec.value(), new SubInterfaceMethod(iface, method));
            }
            ++n2;
        }
    }

    @Override
    public Object invoke(Object obj, final Method method, final Object[] args) throws ESException {
        ESMethodInvocation methodInvocation = new ESMethodInvocation(method.getName(), args);
        this.getAccessControl().getAuthorizationService().checkAccess(methodInvocation);
        final Object[] adjustedArgs = this.adjustParameters(args);
        this.notifyServerCallObservers(new ServerCallObserverNotifier(){

            public void notify(ESServerCallObserver observer) {
                observer.notifyPreServerCallExecution(method, adjustedArgs);
            }
        });
        SubInterfaceMethod subIfaceMethod = this.subInterfaceMethods.get((Object)methodInvocation.getType());
        try {
            Object result = subIfaceMethod.getIface().execute(subIfaceMethod.getMethod(), adjustedArgs);
            final Object adjustedResult = this.adjustResult((Optional<SessionId>)ESCollections.find((Object[])adjustedArgs, SessionId.class), result);
            this.notifyServerCallObservers(new ServerCallObserverNotifier(){

                public void notify(ESServerCallObserver observer) {
                    observer.notifyPostServerCallExecution(method, args, adjustedResult);
                }
            });
            return adjustedResult;
        }
        catch (ESException esException) {
            this.notifyServerCallObservers(new ServerCallObserverNotifier(){

                public void notify(ESServerCallObserver observer) {
                    observer.notifyServerCallExecutionESExceptionFailure(method, args, esException);
                }
            });
            throw esException;
        }
        catch (RuntimeException runtimeException) {
            this.notifyServerCallObservers(new ServerCallObserverNotifier(){

                public void notify(ESServerCallObserver observer) {
                    observer.notifyServerCallExecutionRuntimeExceptionFailure(method, args, runtimeException);
                }
            });
            throw runtimeException;
        }
    }

    private Object[] adjustParameters(Object[] args) throws ESException {
        int i = 0;
        while (i < args.length) {
            Object object = args[i];
            if (ChangePackageProxy.class.isInstance(object)) {
                args[i] = this.resolveChangePackageProxy((Optional<SessionId>)ESCollections.find((Object[])args, SessionId.class), (ChangePackageProxy)ChangePackageProxy.class.cast(object));
            }
            ++i;
        }
        return args;
    }

    private Object adjustResult(Optional<SessionId> maybeSessionId, Object result) throws ESException {
        if (!ServerConfiguration.getChangePackageFragmentSize().isPresent()) {
            return result;
        }
        if (!maybeSessionId.isPresent()) {
            throw new ESException(Messages.EMFStoreImpl_Missing_SessionAndOrProjectId);
        }
        return this.adjustResult((SessionId)maybeSessionId.get(), result);
    }

    private Object adjustResult(SessionId sessionId, Object result) {
        if (result instanceof List) {
            List results = (List)result;
            int i = 0;
            while (i < results.size()) {
                Object item = results.get(i);
                results.set(i, this.adjustResult(sessionId, item));
                ++i;
            }
            return results;
        }
        if (result instanceof Object[]) {
            Object[] results = (Object[])result;
            int i = 0;
            while (i < results.length) {
                results[i] = this.adjustResult(sessionId, results[i]);
                ++i;
            }
            return results;
        }
        if (FileBasedChangePackage.class.isInstance(result) && !ChangePackageProxy.class.isInstance(result)) {
            ChangePackageProxy changePackageProxy = this.createAndRegisterChangePackageProxy(sessionId, (FileBasedChangePackage)FileBasedChangePackage.class.cast(result));
            return changePackageProxy;
        }
        return result;
    }

    private ChangePackageProxy createAndRegisterChangePackageProxy(SessionId session, FileBasedChangePackage changePackage) {
        ChangePackageFragmentProviderAdapter adapter;
        ESSessionId resolvedSession = this.getAccessControl().getSessions().resolveSessionById(session.getId());
        SessionId sessionId = (SessionId)APIUtil.toInternal(SessionId.class, (Object)resolvedSession);
        Optional maybeAdapter = ESCollections.find((List)sessionId.eAdapters(), ChangePackageFragmentProviderAdapter.class);
        if (!maybeAdapter.isPresent()) {
            adapter = new ChangePackageFragmentProviderAdapter();
            sessionId.eAdapters().add((Object)adapter);
        } else {
            adapter = (ChangePackageFragmentProviderAdapter)((Object)maybeAdapter.get());
        }
        String proxyId = this.generateProxyId();
        adapter.addAsFragments(proxyId, changePackage);
        ChangePackageProxy proxy = VersioningFactory.eINSTANCE.createChangePackageProxy();
        proxy.setId(proxyId);
        proxy.setLogMessage((LogMessage)ModelUtil.clone((EObject)changePackage.getLogMessage()));
        return proxy;
    }

    private String generateProxyId() {
        return UUID.randomUUID().toString();
    }

    private AbstractChangePackage resolveChangePackageProxy(Optional<SessionId> maybeSession, ChangePackageProxy changePackageProxy) throws ESException {
        AbstractChangePackage changePackage;
        if (!maybeSession.isPresent()) {
            throw new ESException(Messages.EMFStoreImpl_NoValidSessiondIdFound);
        }
        ESSessionId resolvedSession = this.getAccessControl().getSessions().resolveSessionById(((SessionId)maybeSession.get()).getId());
        SessionId sessionId = (SessionId)APIUtil.toInternal(SessionId.class, (Object)resolvedSession);
        Optional maybeAdapter = ESCollections.find((List)sessionId.eAdapters(), ChangePackageFragmentUploadAdapter.class);
        if (!maybeAdapter.isPresent()) {
            throw new ESException(Messages.EMFStoreImpl_NoFragmentAdapterFound);
        }
        ChangePackageFragmentUploadAdapter adapter = (ChangePackageFragmentUploadAdapter)((Object)maybeAdapter.get());
        if (ServerConfiguration.useFileBasedChangePackageOnServer()) {
            Optional<FileBasedChangePackage> fileBasedChangePackage = adapter.getFileBasedChangePackage(changePackageProxy.getId());
            if (!fileBasedChangePackage.isPresent()) {
                throw new ESException(Messages.EMFStoreImpl_NoCompletedChangePackageFound);
            }
            changePackage = (AbstractChangePackage)fileBasedChangePackage.get();
        } else {
            Optional<ChangePackage> maybeCompletedChangePackage = adapter.convertFileBasedToInMemoryChangePackage(changePackageProxy.getId());
            if (!maybeCompletedChangePackage.isPresent()) {
                throw new ESException(Messages.EMFStoreImpl_NoCompletedChangePackageFound);
            }
            changePackage = (AbstractChangePackage)maybeCompletedChangePackage.get();
        }
        adapter.clearCompleted(changePackageProxy.getId());
        changePackage.setLogMessage((LogMessage)ModelUtil.clone((EObject)changePackageProxy.getLogMessage()));
        return changePackage;
    }

    private void notifyServerCallObservers(ServerCallObserverNotifier serverCallObserverNotifier) {
        for (ESServerCallObserver callObserver : this.serverCallObservers) {
            try {
                serverCallObserverNotifier.notify(callObserver);
            }
            catch (RuntimeException runtimeException) {
                ModelUtil.logWarning((String)Messages.EMFStoreImpl_ServerCallObserverNotifier_Failed, (Throwable)runtimeException);
            }
        }
    }

    public static EMFStore createInterface(ServerSpace serverSpace, AccessControl accessControl) throws IllegalArgumentException, FatalESException {
        return (EMFStore)Proxy.newProxyInstance(EMFStoreImpl.class.getClassLoader(), new Class[]{EMFStore.class}, (InvocationHandler)new EMFStoreImpl(serverSpace, accessControl));
    }

    private class SubInterfaceMethod {
        private final AbstractSubEmfstoreInterface iface;
        private final Method method;

        public SubInterfaceMethod(AbstractSubEmfstoreInterface iface, Method m) {
            this.method = m;
            this.iface = iface;
        }

        public AbstractSubEmfstoreInterface getIface() {
            return this.iface;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

