/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.prefixes;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixMap;
import org.apache.jena.riot.system.PrefixLib;
import org.apache.jena.riot.system.PrefixMapBase;
import org.apache.jena.riot.system.Prefixes;

public class PrefixMapOverStorage
extends PrefixMapBase {
    private final StoragePrefixMap prefixes;

    protected StoragePrefixMap spm() {
        return this.prefixes;
    }

    public PrefixMapOverStorage(StoragePrefixMap storage) {
        this.prefixes = storage;
    }

    @Override
    public Map<String, String> getMapping() {
        return this.getMappingCopy();
    }

    @Override
    public Map<String, String> getMappingCopy() {
        return this.spm().stream().collect(Collectors.toMap(e2 -> e2.getPrefix(), e2 -> e2.getUri()));
    }

    @Override
    public void add(String prefix, String iriString) {
        prefix = PrefixLib.canonicalPrefix(prefix);
        this.spm().put(prefix, iriString);
    }

    @Override
    public void delete(String prefix) {
        prefix = PrefixLib.canonicalPrefix(prefix);
        this.spm().remove(prefix);
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        this.spm().forEach((? super T entry) -> action.accept(entry.getPrefix(), entry.getUri()));
    }

    @Override
    public void clear() {
        this.spm().clear();
    }

    @Override
    public boolean isEmpty() {
        return this.spm().isEmpty();
    }

    @Override
    public int size() {
        return this.spm().size();
    }

    @Override
    public String get(String prefix) {
        prefix = PrefixLib.canonicalPrefix(prefix);
        return this.spm().get(prefix);
    }

    @Override
    public boolean containsPrefix(String prefix) {
        prefix = PrefixLib.canonicalPrefix(prefix);
        return this.spm().containsPrefix(prefix);
    }

    @Override
    public String toString() {
        return Prefixes.toString(this);
    }
}

