/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.query.QueryExecException;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter1;

public class QueryIterSlice
extends QueryIter1 {
    long count = 0L;
    long limit;
    long offset;

    public QueryIterSlice(QueryIterator cIter, long startPosition, long numItems, ExecutionContext context2) {
        super(cIter, context2);
        this.offset = startPosition;
        if (this.offset == Long.MIN_VALUE) {
            this.offset = 0L;
        }
        this.limit = numItems;
        if (this.limit == Long.MIN_VALUE) {
            this.limit = Long.MAX_VALUE;
        }
        if (this.limit < 0L) {
            throw new QueryExecException("Negative LIMIT: " + this.limit);
        }
        if (this.offset < 0L) {
            throw new QueryExecException("Negative OFFSET: " + this.offset);
        }
        this.count = 0L;
        int i = 0;
        while ((long)i < this.offset) {
            if (!cIter.hasNext()) {
                this.close();
                break;
            }
            cIter.next();
            ++i;
        }
    }

    @Override
    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        if (!this.getInput().hasNext()) {
            return false;
        }
        return this.count < this.limit;
    }

    @Override
    protected Binding moveToNextBinding() {
        ++this.count;
        return this.getInput().nextBinding();
    }

    @Override
    protected void closeSubIterator() {
    }

    @Override
    protected void requestSubCancel() {
    }
}

