/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.diagram.parsers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.RGBColor;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.tooling.simplemap.diagram.parsers.MessageFormatParser;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleCompartment;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleMappingElementWithFigure;

public class SimpleCompartmentFormatParser
extends MessageFormatParser
implements ISemanticParser {
    public SimpleCompartmentFormatParser(EAttribute[] features) {
        super(features);
    }

    public SimpleCompartmentFormatParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public static SimpleCompartmentFormatParser getInstance(EAttribute[] features, EAttribute[] editableFeatures) {
        if (editableFeatures == null) {
            return new SimpleCompartmentFormatParser(features);
        }
        return new SimpleCompartmentFormatParser(features, editableFeatures);
    }

    public List getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> parserElements = new ArrayList<Object>(1);
        if (element instanceof SimpleCompartment) {
            parserElements.add((SimpleCompartment)element);
            parserElements.add(((SimpleCompartment)element).getCompartment());
        }
        if (element instanceof SimpleMappingElementWithFigure) {
            parserElements.add(this.getFigureBackgroundColor((SimpleMappingElementWithFigure)element));
            parserElements.add(this.getFigureForegroundColor((SimpleMappingElementWithFigure)element));
        }
        return parserElements;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return true;
    }

    private RGBColor getFigureBackgroundColor(SimpleMappingElementWithFigure childNode) {
        Figure nodeFigure = childNode.getNodeFigure();
        if (nodeFigure != null && nodeFigure.getBackgroundColor() instanceof RGBColor) {
            return (RGBColor)nodeFigure.getBackgroundColor();
        }
        return null;
    }

    private RGBColor getFigureForegroundColor(SimpleMappingElementWithFigure childNode) {
        Figure nodeFigure = childNode.getNodeFigure();
        if (nodeFigure != null && nodeFigure.getForegroundColor() instanceof RGBColor) {
            return (RGBColor)nodeFigure.getForegroundColor();
        }
        return null;
    }
}

