/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.model.triggers.parent;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.tooling.simplemap.model.triggers.parent.NewElementTrigger;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleChildNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleCompartment;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleNode;

class NewCompartmentTrigger
extends NewElementTrigger {
    private SimpleCompartment newSimpleCompartment;
    private SimpleNode parent;

    public NewCompartmentTrigger(TransactionalEditingDomain domain, SimpleNode parent, SimpleCompartment newCompartment) {
        super(domain, (SimpleChildNode)newCompartment);
        this.newSimpleCompartment = newCompartment;
        this.parent = parent;
    }

    @Override
    public void executeTrigger() {
        Compartment newCompartment = GMFGraphFactory.eINSTANCE.createCompartment();
        newCompartment.setNeedsTitle(this.newSimpleCompartment.isNeedsTitle());
        this.updateCanvas(newCompartment);
        this.updateMapping(newCompartment);
    }

    private void updateCanvas(Compartment newCompartment) {
        FigureDescriptor parentFigureDesc = this.parent.getDiagramNode().getFigure();
        this.canvasFactory.createDefaultCompartmentWithoutLabel(parentFigureDesc, newCompartment);
    }

    private void updateMapping(Compartment newCompartment) {
        CompartmentMapping compartmentMapping = GMFMapFactory.eINSTANCE.createCompartmentMapping();
        compartmentMapping.setCompartment(newCompartment);
        this.parent.getNodeReference().getChild().getCompartments().add((Object)compartmentMapping);
        this.newSimpleCompartment.setCompartmentMapping(compartmentMapping);
    }
}

