/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.util.Collection;

public class ParserException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final ErrorLocationInfo[] errors;
    private final String qualifiedResourceName;

    public ParserException(String qualifiedName, Collection<? extends ErrorLocationInfo> errors) {
        this(qualifiedName, errors.toArray(new ErrorLocationInfo[errors.size()]));
    }

    public ParserException(String qualifiedName, ErrorLocationInfo ... errors) {
        assert (errors != null && errors.length > 0);
        this.errors = errors;
        this.qualifiedResourceName = qualifiedName;
    }

    public ErrorLocationInfo[] getParsingErrors() {
        return this.errors;
    }

    public String getResourceName() {
        return this.qualifiedResourceName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(", @");
        sb.append(this.getResourceName());
        ErrorLocationInfo[] errorLocationInfoArray = this.getParsingErrors();
        int n = errorLocationInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorLocationInfo l = errorLocationInfoArray[n2];
            sb.append('\n');
            sb.append('\t');
            if (l.startLine == -1 || l.startOffset == -1) {
                sb.append("[unspecified location]");
            } else {
                sb.append('[');
                if (l.startLine != -1 && l.endLine != -1) {
                    sb.append(l.startLine);
                    sb.append(':');
                    sb.append(l.startColumn);
                    sb.append('-');
                    sb.append(l.endLine);
                    sb.append(':');
                    sb.append(l.endColumn);
                } else {
                    sb.append(l.startOffset);
                    sb.append('-');
                    sb.append(l.endOffset);
                }
                sb.append(']');
            }
            sb.append(' ');
            sb.append(l.message);
            ++n2;
        }
        return sb.toString();
    }

    public static class ErrorLocationInfo {
        public final int startLine;
        public final int startColumn;
        public final int endLine;
        public final int endColumn;
        public final String message;
        public final int startOffset;
        public final int endOffset;

        public ErrorLocationInfo(String message) {
            this(message, -1, -1, -1, -1, -1, -1);
        }

        public ErrorLocationInfo(String message, int startLine, int startColumn, int endLine, int endColumn) {
            this(message, startLine, startColumn, endLine, endColumn, -1, -1);
        }

        public ErrorLocationInfo(String message, int startLine, int startColumn, int endLine, int endColumn, int startOffset, int endOffset) {
            this.message = message;
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }
}

