/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.initializer;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.initializer.Activator;
import org.eclipse.equinox.internal.initializer.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class FileInitializer
implements IPlatformRunnable {
    private LinkedList extractedFiles;
    private boolean justThisArchOSWS;
    private final String ARG_FILE = "-fileInitializer";
    private final String ARG_JUSTTHISARCHOSWS = "-justThisArchOSWS";

    public Object run(Object args) throws Exception {
        Properties bundleAndFilePatterns = this.getBundleAndFileNamePatterns((String[])args);
        if (bundleAndFilePatterns == null || bundleAndFilePatterns.size() == 0) {
            return IPlatformRunnable.EXIT_OK;
        }
        this.justThisArchOSWS = this.getJustThisArchOSWS((String[])args);
        this.extractedFiles = new LinkedList();
        Bundle[] installedBundles = Activator.getContext().getBundles();
        Set<Object> bundlePatterns = bundleAndFilePatterns.keySet();
        Iterator<Object> bundlePatternIter = bundlePatterns.iterator();
        while (bundlePatternIter.hasNext()) {
            Object bundlePattern = bundlePatternIter.next();
            Object fileNamePattern = bundleAndFilePatterns.get(bundlePattern);
            String[] fileNamePatterns = ((String)fileNamePattern).split(",");
            int i = 0;
            while (i < fileNamePatterns.length) {
                fileNamePatterns[i] = fileNamePatterns[i].trim();
                ++i;
            }
            i = 0;
            while (i < installedBundles.length) {
                String bundleName = installedBundles[i].getSymbolicName();
                if (Pattern.matches((String)bundlePattern, bundleName)) {
                    int j = 0;
                    while (j < fileNamePatterns.length) {
                        this.extractMatchingFilesFromBundle(fileNamePatterns[j], installedBundles[i]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return IPlatformRunnable.EXIT_OK;
    }

    private void extractMatchingFilesFromBundle(String fileNamePattern, Bundle bundle) throws IOException {
        Enumeration e = bundle.findEntries("/", fileNamePattern, true);
        while (e != null && e.hasMoreElements()) {
            String localURLPath;
            int index;
            URL localURL;
            Path filePath;
            String[] path;
            URL fileURL = (URL)e.nextElement();
            if (this.justThisArchOSWS && ((path = (filePath = new Path(fileURL.getPath())).segments()).length == 4 && path[0].equals("os") && (!path[1].equals(Platform.getOS()) || !path[2].equals(Platform.getOSArch())) || path.length == 3 && path[0].equals("ws") && !path[1].equals(Platform.getWS())) || (localURL = FileLocator.toFileURL((URL)fileURL)) == null || (index = Collections.binarySearch(this.extractedFiles, localURLPath = localURL.getPath())) >= 0) continue;
            this.extractedFiles.add(-(index + 1), localURLPath);
            System.out.println("FileInitializer: " + localURLPath);
        }
    }

    private Properties getBundleAndFileNamePatterns(String[] argsArray) {
        int i = 0;
        while (i < argsArray.length) {
            if (argsArray[i].equalsIgnoreCase("-fileInitializer")) {
                if (argsArray.length < i + 2) {
                    String msg = NLS.bind((String)Messages.fileInitializer_missingFileName, (Object)this.getClass().getName());
                    Status status = new Status(4, "org.eclipse.core.runtime", 2, msg, null);
                    Activator.log((IStatus)status);
                    return null;
                }
                try {
                    FileInputStream fin = new FileInputStream(argsArray[i + 1]);
                    Properties bundleAndFileNameProperties = new Properties();
                    bundleAndFileNameProperties.load(fin);
                    fin.close();
                    return bundleAndFileNameProperties;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String msg = NLS.bind((String)Messages.fileInitializer_fileNotFound, (Object)this.getClass().getName(), (Object)argsArray[i + 1]);
                    Status status = new Status(4, "org.eclipse.core.runtime", 2, msg, null);
                    Activator.log((IStatus)status);
                    return null;
                }
                catch (IOException e) {
                    String msg = NLS.bind((String)Messages.fileInitializer_IOError, (Object)this.getClass().getName(), (Object)argsArray[i + 1]);
                    Status status = new Status(4, "org.eclipse.core.runtime", 2, msg, (Throwable)e);
                    Activator.log((IStatus)status);
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    private boolean getJustThisArchOSWS(String[] argsArray) {
        int i = 0;
        while (i < argsArray.length) {
            if (argsArray[i].equalsIgnoreCase("-justThisArchOSWS")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

