/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.io;

import java.util.Map;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.setext.parser.SeTextParser;
import org.eclipse.escet.setext.parser.ast.Specification;
import org.eclipse.escet.setext.parser.ast.regex.RegEx;
import org.eclipse.escet.setext.parser.ast.scanner.Terminal;
import org.eclipse.escet.setext.runtime.io.BaseReader;
import org.eclipse.escet.setext.typechecker.SeTextTypeChecker;

public class SeTextReader
extends BaseReader<SeTextReader, Specification, Specification, SeTextParser, SeTextTypeChecker> {
    public SeTextReader() {
        super(Specification.class);
    }

    protected SeTextParser createParser() {
        return new SeTextParser();
    }

    protected SeTextTypeChecker createTypeChecker() {
        return new SeTextTypeChecker();
    }

    protected String getLangName() {
        return "SeText";
    }

    public static RegEx parseRegEx(String regEx) {
        String path = "/dummy.setext";
        String txt = "@scanner SomeScannerClass;\n\n" + Strings.fmt((String)"@terminals: \"%s\"; @eof; end", (Object[])new Object[]{regEx});
        SeTextTypeChecker.skipEmptyTermCheck = true;
        Specification spec = (Specification)((SeTextReader)new SeTextReader().init(path, path, false)).read(txt);
        SeTextTypeChecker.skipEmptyTermCheck = false;
        Assert.check((spec.terminals.size() == 2 ? 1 : 0) != 0);
        Assert.check((boolean)((Terminal)spec.terminals.get(1)).isEof());
        return ((Terminal)spec.terminals.get((int)0)).regEx;
    }

    public static RegEx parseRegEx(String regEx, Map<String, String> shortcuts) {
        String path = "/dummy.setext";
        Object txt = "@scanner SomeScannerClass;\n\n@terminals:\n";
        txt = (String)txt + Strings.fmt((String)"  \"%s\";\n", (Object[])new Object[]{regEx});
        txt = (String)txt + "  @eof;\n";
        txt = (String)txt + "end\n";
        for (Map.Entry<String, String> entry : shortcuts.entrySet()) {
            txt = (String)txt + Strings.fmt((String)"@shortcut %s = \"%s\";\n", (Object[])new Object[]{entry.getKey(), entry.getValue()});
        }
        SeTextTypeChecker.skipEmptyTermCheck = true;
        Specification spec = (Specification)((SeTextReader)new SeTextReader().init(path, path, false)).read((String)txt);
        SeTextTypeChecker.skipEmptyTermCheck = false;
        Assert.check((spec.terminals.size() == 2 ? 1 : 0) != 0);
        Assert.check((boolean)((Terminal)spec.terminals.get(1)).isEof());
        return ((Terminal)spec.terminals.get((int)0)).regEx;
    }

    protected String getXmiFileExt() {
        return null;
    }
}

