/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.management;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.management.AppManagerData;
import org.eclipse.escet.common.app.framework.management.AppStatus;
import org.eclipse.escet.common.app.framework.management.AppStatusListener;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;

public class AppManager {
    private static final Map<Application<?>, AppManagerData> APPLICATIONS = Maps.mapc((int)32);
    private static final List<AppStatusListener> LISTENERS = Lists.listc((int)1);

    private AppManager() {
    }

    public static synchronized boolean checkExists(Application<?> app) {
        return APPLICATIONS.containsKey(app);
    }

    public static synchronized void add(Application<?> app, Application<?> parent) {
        if (APPLICATIONS.containsKey(app)) {
            throw new RuntimeException("Duplicate application: " + String.valueOf(app));
        }
        if (parent != null && !APPLICATIONS.containsKey(parent)) {
            throw new RuntimeException("Unknown parent application: " + String.valueOf(parent));
        }
        Application<?> ancestor = parent;
        while (ancestor != null) {
            if (ancestor == app) {
                throw new RuntimeException("App is own ancestor: " + String.valueOf(app));
            }
            ancestor = AppManager.getParent(ancestor);
        }
        AppManagerData data = new AppManagerData(app, parent);
        APPLICATIONS.put(app, data);
        AppManager.notifyStatusListeners(data, true);
    }

    public static synchronized void update(Application<?> app, AppStatus status) {
        AppManagerData data = APPLICATIONS.get(app);
        if (data == null) {
            if (status == AppStatus.TERMINATING) {
                return;
            }
            throw new RuntimeException("Unknown application: " + String.valueOf(app));
        }
        if (status == AppStatus.TERMINATING) {
            switch (data.status) {
                case TERMINATED: 
                case FINISHED: 
                case FAILED: 
                case CRASHED: {
                    return;
                }
            }
        }
        data.status = status;
        AppManager.notifyStatusListeners(data, false);
    }

    public static synchronized void remove(Application<?> app) {
        if (!APPLICATIONS.containsKey(app)) {
            throw new RuntimeException("Unknown application: " + String.valueOf(app));
        }
        for (Map.Entry<Application<?>, AppManagerData> entry : APPLICATIONS.entrySet()) {
            if (entry.getValue().parent != app) continue;
            throw new RuntimeException("Can't remove application, child present: " + String.valueOf(app));
        }
        APPLICATIONS.remove(app);
    }

    public static synchronized void terminate(Application<?> appToTerminate) {
        LinkedList queue = new LinkedList();
        queue.push(appToTerminate);
        while (!queue.isEmpty()) {
            Application app = (Application)queue.pop();
            app.terminate();
            for (Map.Entry<Application<?>, AppManagerData> entry : APPLICATIONS.entrySet()) {
                if (entry.getValue().parent != app) continue;
                queue.push(entry.getKey());
            }
        }
    }

    public static synchronized void terminateAll() {
        for (Application<?> app : APPLICATIONS.keySet()) {
            app.terminate();
        }
    }

    private static synchronized Application<?> getParent(Application<?> app) {
        AppManagerData data = APPLICATIONS.get(app);
        if (data == null) {
            throw new RuntimeException("Unknown application: " + String.valueOf(app));
        }
        return data.parent;
    }

    public static synchronized void addStatusListener(AppStatusListener listener, boolean notifyCurrent) {
        if (LISTENERS.contains(listener)) {
            throw new RuntimeException("Duplicate listener: " + String.valueOf(listener));
        }
        LISTENERS.add(listener);
        if (notifyCurrent) {
            for (AppManagerData data : APPLICATIONS.values()) {
                listener.appStatusChanged(data.copy(), true);
            }
        }
    }

    public static synchronized void removeStatusListener(AppStatusListener listener) {
        LISTENERS.remove(listener);
    }

    private static synchronized void notifyStatusListeners(AppManagerData data, boolean newApp) {
        AppManagerData dataCopy = data.copy();
        for (AppStatusListener listener : LISTENERS) {
            listener.appStatusChanged(dataCopy, newApp);
        }
    }
}

