/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime;

import org.apache.batik.bridge.BridgeContext;
import org.eclipse.escet.chi.runtime.SvgModification;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.svg.SvgUtils;
import org.eclipse.escet.common.svg.SvgVisualizer;
import org.w3c.dom.Document;

public class SvgAbsmoveModification
extends SvgModification {
    public double xDest;
    public double yDest;

    @Override
    public void apply(SvgVisualizer svgVis) {
        SvgUtils.move((Document)svgVis.getDocument(), (BridgeContext)svgVis.getSvgCanvas().getBridgeContext(), (String)this.nodeName, (double)this.xDest, (double)this.yDest, (String)this.svgPath);
    }

    public static SvgAbsmoveModification decode(String line, String svgPath) {
        if (!line.startsWith("absmove")) {
            return null;
        }
        int i = 7;
        int j = line.indexOf(40, i);
        if (j < 0) {
            String msg = Strings.fmt((String)"Cannot find \"(\" in the move command \"%s\".", (Object[])new Object[]{line});
            throw new InputOutputException(msg);
        }
        int k = line.indexOf(44, j + 1);
        if (k < 0) {
            String msg = Strings.fmt((String)"Cannot find \",\" in the move command \"%s\".", (Object[])new Object[]{line});
            throw new InputOutputException(msg);
        }
        int m = line.indexOf(41, k + 1);
        if (m < 0) {
            String msg = Strings.fmt((String)"Cannot find \")\" in the move command \"%s\".", (Object[])new Object[]{line});
            throw new InputOutputException(msg);
        }
        SvgAbsmoveModification sam = new SvgAbsmoveModification();
        sam.svgPath = svgPath;
        sam.nodeName = SvgAbsmoveModification.getWord(line, i, j);
        if (sam.nodeName.isEmpty()) {
            String msg = Strings.fmt((String)"Node name is empty in the move command \"%s\".", (Object[])new Object[]{line});
            throw new InputOutputException(msg);
        }
        try {
            sam.xDest = Double.parseDouble(line.substring(j + 1, k));
        }
        catch (NumberFormatException e) {
            String msg = Strings.fmt((String)"Cannot convert the x destination in the move command \"%s\".", (Object[])new Object[]{line});
            throw new InputOutputException(msg, (Throwable)e);
        }
        try {
            sam.yDest = Double.parseDouble(line.substring(k + 1, m));
        }
        catch (NumberFormatException e) {
            String msg = Strings.fmt((String)"Cannot convert the y destination in the move command \"%s\".", (Object[])new Object[]{line});
            throw new InputOutputException(msg, (Throwable)e);
        }
        return sam;
    }
}

