/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.MultiClassLoader;
import org.eclipse.escet.common.java.UncachedUrlClassLoader;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public abstract class ClassLoaderObtainer {
    public ClassLoader getClassLoader(String name) {
        IWorkspaceRoot root;
        IProject proj;
        if (!Platform.isRunning()) {
            return ClassLoader.getSystemClassLoader();
        }
        if (name == null) {
            return ClassLoader.getSystemClassLoader();
        }
        if (PlatformUI.isWorkbenchRunning() && Path.ROOT.isValidSegment(name) && (proj = (root = ResourcesPlugin.getWorkspace().getRoot()).getProject(name)).exists() && proj.isAccessible()) {
            return this.getPdeClassLoader(proj);
        }
        return this.getOsgiClassLoader(name);
    }

    private ClassLoader getPdeClassLoader(IProject proj) {
        IPluginModelBase plugin = PluginRegistry.findModel((IProject)proj);
        if (plugin == null) {
            throw this.createNotPluginProjException(proj.getName());
        }
        BundleDescription descr = plugin.getBundleDescription();
        if (descr == null) {
            throw this.createPluginClassicFormatException(proj.getName());
        }
        List reqsLoaders = Lists.list();
        BundleSpecification[] bundleSpecificationArray = descr.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification reqBundle = bundleSpecificationArray[n2];
            String reqName = reqBundle.getName();
            ClassLoader reqLoader = this.getClassLoader(reqName);
            reqsLoaders.add(reqLoader);
            ++n2;
        }
        ClassLoader reqsLoader = reqsLoaders.isEmpty() ? ClassLoader.getSystemClassLoader() : new MultiClassLoader(reqsLoaders);
        return this.getJdtClassLoader(proj, reqsLoader);
    }

    protected abstract RuntimeException createNotPluginProjException(String var1);

    protected abstract RuntimeException createPluginClassicFormatException(String var1);

    private ClassLoader getJdtClassLoader(IProject proj, ClassLoader parent) {
        String[] cp;
        IJavaProject jproj = JavaCore.create((IProject)proj);
        try {
            cp = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)jproj);
        }
        catch (CoreException ex) {
            throw this.createComputeClassPathException(proj.getName(), ex);
        }
        List urlList = Lists.list();
        int i = 0;
        while (i < cp.length) {
            URL url;
            Path path = new Path(cp[i]);
            try {
                url = path.toFile().toURI().toURL();
            }
            catch (MalformedURLException ex) {
                throw this.createMalformedUrlException(proj.getName(), ex);
            }
            urlList.add(url);
            ++i;
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        try {
            return new UncachedUrlClassLoader(urls, parent);
        }
        catch (UncachedUrlClassLoader.OpenUrlException ex) {
            throw this.createOpenUrlException(proj.getName(), ex);
        }
    }

    protected abstract RuntimeException createComputeClassPathException(String var1, CoreException var2);

    protected abstract RuntimeException createMalformedUrlException(String var1, MalformedURLException var2);

    protected abstract RuntimeException createOpenUrlException(String var1, UncachedUrlClassLoader.OpenUrlException var2);

    private ClassLoader getOsgiClassLoader(String name) {
        boolean stateOk;
        Bundle bundle = Platform.getBundle((String)name);
        if (bundle == null) {
            throw this.createNotFoundException(name);
        }
        int state = bundle.getState();
        boolean bl = stateOk = state == 4 || state == 8 || state == 32;
        if (!stateOk) {
            throw this.createWrongStateException(name, bundle, state);
        }
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            throw this.createNoWiringException(name, bundle);
        }
        ClassLoader classLoader = bundleWiring.getClassLoader();
        if (classLoader == null) {
            throw this.createNoClassLoaderException(name, bundle);
        }
        return classLoader;
    }

    protected abstract RuntimeException createNotFoundException(String var1);

    protected abstract RuntimeException createWrongStateException(String var1, Bundle var2, int var3);

    protected RuntimeException createNoWiringException(String name, Bundle bundle) {
        return this.createNoClassLoaderException(name, bundle);
    }

    protected abstract RuntimeException createNoClassLoaderException(String var1, Bundle var2);
}

