/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.ElimMonitors;
import org.eclipse.escet.cif.cif2cif.LinearizeBase;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifGuardUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Triple;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class LinearizeMerge
extends LinearizeBase {
    public LinearizeMerge(WarnOutput warnOutput) {
        this(false, warnOutput);
    }

    public LinearizeMerge(boolean optInits, WarnOutput warnOutput) {
        super(optInits, warnOutput);
    }

    @Override
    protected void createEdges(List<Automaton> auts, Automaton mergedAut, Location mergedLoc) {
        List events = Lists.set2list((Set)CifEventUtils.getAlphabet((Automaton)mergedAut));
        List syncAlphabets = Lists.listc((int)auts.size());
        List sendAlphabets = Lists.listc((int)auts.size());
        List recvAlphabets = Lists.listc((int)auts.size());
        List moniAlphabets = Lists.listc((int)auts.size());
        for (CifEventUtils.Alphabets autAlphabets : this.alphabets) {
            syncAlphabets.add(autAlphabets.syncAlphabet);
            sendAlphabets.add(autAlphabets.sendAlphabet);
            recvAlphabets.add(autAlphabets.recvAlphabet);
            moniAlphabets.add(autAlphabets.moniAlphabet);
        }
        List syncAuts = CifEventUtils.filterAutomata(auts, (List)syncAlphabets, (List)events);
        List sendAuts = CifEventUtils.filterAutomata(auts, (List)sendAlphabets, (List)events);
        List recvAuts = CifEventUtils.filterAutomata(auts, (List)recvAlphabets, (List)events);
        List moniAuts = CifEventUtils.filterMonitorAuts(auts, (List)moniAlphabets, (List)events);
        CifGuardUtils.LocRefExprCreator creator = new CifGuardUtils.LocRefExprCreator(){

            public Expression create(Location loc) {
                return LinearizeMerge.this.lpIntroducer.createLocRef(loc);
            }
        };
        List guards = Lists.listc((int)events.size());
        int i = 0;
        while (i < events.size()) {
            Expression guard = CifGuardUtils.mergeGuards((List)((List)syncAuts.get(i)), (List)((List)sendAuts.get(i)), (List)((List)recvAuts.get(i)), (Set)((Set)moniAuts.get(i)), (Event)((Event)events.get(i)), (CifGuardUtils.LocRefExprCreator)creator);
            guards.add(guard);
            ++i;
        }
        ElimMonitors monitorElim = new ElimMonitors();
        for (Automaton aut : auts) {
            monitorElim.transform(aut);
        }
        int i2 = 0;
        for (Event event : events) {
            List evtSyncAuts = (List)syncAuts.get(i2);
            List evtSendAuts = (List)sendAuts.get(i2);
            List evtRecvAuts = (List)recvAuts.get(i2);
            Expression guard = (Expression)guards.get(i2);
            ++i2;
            List<Update> updates = this.mergeUpdates(evtSyncAuts, evtSendAuts, evtRecvAuts, event);
            EventExpression eventRef = CifConstructors.newEventExpression();
            eventRef.setEvent(event);
            eventRef.setType((CifType)CifConstructors.newBoolType());
            EdgeEvent edgeEvent = CifConstructors.newEdgeEvent();
            edgeEvent.setEvent((Expression)eventRef);
            Edge edge = CifConstructors.newEdge();
            edge.getEvents().add((Object)edgeEvent);
            edge.getGuards().add((Object)guard);
            edge.getUpdates().addAll(updates);
            mergedLoc.getEdges().add((Object)edge);
        }
    }

    private List<Update> mergeUpdates(List<Automaton> syncAuts, List<Automaton> sendAuts, List<Automaton> recvAuts, Event event) {
        boolean isChannel = event.getType() != null;
        boolean isVoid = isChannel && event.getType() instanceof VoidType;
        Expression sendValue = null;
        if (isChannel && !isVoid && (sendValue = this.getSendValue(sendAuts, event)) == null) {
            this.warnOutput.line("Event \"%s\" does not have a 'send' edge and is never enabled.", new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
            return Lists.list();
        }
        List updates = Lists.list();
        List triples = Lists.list();
        if (isChannel) {
            triples.clear();
            for (Automaton aut : sendAuts) {
                this.collectUpdates(aut, event, null, triples);
            }
            this.addUpdates(triples, updates);
            triples.clear();
            for (Automaton aut : recvAuts) {
                this.collectUpdates(aut, event, sendValue, triples);
            }
            this.addUpdates(triples, updates);
        }
        for (Automaton aut : syncAuts) {
            triples.clear();
            this.collectUpdates(aut, event, null, triples);
            this.addUpdates(triples, updates);
        }
        return updates;
    }

    private Expression getSendValue(List<Automaton> auts, Event event) {
        List pairs = Lists.list();
        for (Automaton aut : auts) {
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        Event e;
                        if (!(edgeEvent instanceof EdgeSend) || (e = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)edgeEvent)) != event) continue;
                        Expression lexpr = this.lpIntroducer.createLocRef(loc);
                        Expression guards = CifValueUtils.createConjunction((List)EMFHelper.deepclone((List)edge.getGuards()));
                        EdgeSend sendEdge = (EdgeSend)edgeEvent;
                        Pair pair = Pair.pair((Object)CifValueUtils.createConjunction((List)Lists.list((Object[])new Expression[]{lexpr, guards})), (Object)((Expression)EMFHelper.deepclone((EObject)sendEdge.getValue())));
                        pairs.add(pair);
                    }
                }
            }
        }
        if (pairs.isEmpty()) {
            return null;
        }
        if (pairs.size() == 1) {
            return (Expression)((Pair)Lists.first((List)pairs)).right;
        }
        IfExpression rslt = CifConstructors.newIfExpression();
        rslt.getGuards().add((Object)((Expression)((Pair)Lists.first((List)pairs)).left));
        rslt.setThen((Expression)((Pair)Lists.first((List)pairs)).right);
        int i = 1;
        while (i < pairs.size() - 1) {
            ElifExpression elif = CifConstructors.newElifExpression();
            rslt.getElifs().add((Object)elif);
            elif.getGuards().add((Object)((Expression)((Pair)pairs.get((int)i)).left));
            elif.setThen((Expression)((Pair)pairs.get((int)i)).right);
            ++i;
        }
        rslt.setElse((Expression)((Pair)Lists.last((List)pairs)).right);
        CifType eventType = event.getType();
        rslt.setType((CifType)EMFHelper.deepclone((EObject)eventType));
        return rslt;
    }

    private void collectUpdates(Automaton aut, Event event, Expression sendValue, List<Triple<Expression, Location, List<Update>>> triples) {
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                EList edgeEvents = edge.getEvents();
                for (EdgeEvent edgeEvent : edgeEvents) {
                    Event e = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)edgeEvent);
                    if (e != event) continue;
                    Expression lexpr = this.lpIntroducer.createLocRef(loc);
                    Expression guards = CifValueUtils.createConjunction((List)EMFHelper.deepclone((List)edge.getGuards()));
                    List<Update> edgeUpdates = LinearizeMerge.replaceUpdates((List<Update>)edge.getUpdates(), sendValue);
                    Triple trip = Triple.triple((Object)CifValueUtils.createConjunction((List)Lists.list((Object[])new Expression[]{lexpr, guards})), (Object)loc, edgeUpdates);
                    triples.add((Triple<Expression, Location, List<Update>>)trip);
                }
            }
        }
    }

    private void addUpdates(List<Triple<Expression, Location, List<Update>>> triples, List<Update> updates) {
        boolean allEmpty = true;
        Expression updatableVar = null;
        for (Triple<Expression, Location, List<Update>> trip : triples) {
            if (((List)trip.third).isEmpty()) continue;
            allEmpty = false;
            updatableVar = this.getUpdatedVarRefExpr((Update)Lists.first((List)((List)trip.third)));
            break;
        }
        if (allEmpty) {
            return;
        }
        for (Triple<Expression, Location, List<Update>> trip : triples) {
            List tripUpdates = (List)trip.third;
            if (!tripUpdates.isEmpty()) continue;
            Location loc = (Location)trip.second;
            Expression lexpr = this.lpIntroducer.createLocRef(loc);
            Assignment asgn = CifConstructors.newAssignment();
            if (lexpr instanceof BinaryExpression) {
                BinaryExpression binExpr = (BinaryExpression)lexpr;
                asgn.setAddressable(binExpr.getLeft());
                asgn.setValue(binExpr.getRight());
            } else if (lexpr instanceof BoolExpression) {
                asgn.setAddressable((Expression)EMFHelper.deepclone((EObject)updatableVar));
                asgn.setValue((Expression)EMFHelper.deepclone((EObject)updatableVar));
            } else {
                throw new RuntimeException("Unexpected expression: " + lexpr.toString());
            }
            tripUpdates.add(asgn);
        }
        if (triples.size() == 1) {
            updates.addAll((Collection)((Triple)Lists.first(triples)).third);
            return;
        }
        IfUpdate rslt = CifConstructors.newIfUpdate();
        rslt.getGuards().add((Object)((Expression)((Triple)Lists.first(triples)).first));
        rslt.getThens().addAll((Collection)((Triple)Lists.first(triples)).third);
        int i = 1;
        while (i < triples.size()) {
            ElifUpdate elif = CifConstructors.newElifUpdate();
            rslt.getElifs().add((Object)elif);
            elif.getGuards().add((Object)((Expression)triples.get((int)i).first));
            elif.getThens().addAll((Collection)triples.get((int)i).third);
            ++i;
        }
        updates.add((Update)rslt);
    }

    private Expression getUpdatedVarRefExpr(Update update) {
        if (update instanceof Assignment) {
            Assignment ass = (Assignment)update;
            return ass.getAddressable();
        }
        if (update instanceof IfUpdate) {
            IfUpdate ifUpdate = (IfUpdate)update;
            return this.getUpdatedVarRefExpr((Update)Lists.first((List)ifUpdate.getThens()));
        }
        throw new RuntimeException("Unexpected update: " + update.toString());
    }
}

