/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.EventCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeEventKind;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SpecCodeGenerator {
    private SpecCodeGenerator() {
    }

    public static void gencodeSpec(CifCompilerContext ctxt) {
        String eventClassName;
        int runtimeEventIdx;
        JavaCodeFile file = ctxt.addCodeFile("Spec");
        CodeBox h = file.header;
        h.add("/** Runtime specification. */");
        h.add("public final class Spec extends RuntimeSpec<State> {");
        CodeBox c = file.body;
        c.add("public static final Spec SPEC = new Spec();");
        c.add("public static final RuntimeMonitorEdge<State> MONITOR_EDGE = new RuntimeMonitorEdge<>();");
        c.add();
        for (EventCodeGenerator.EnvironmentEventInfo info : ctxt.getEnvironmentEventInfos()) {
            runtimeEventIdx = ctxt.getRuntimeEventIdx(info);
            eventClassName = ctxt.getEventClassName(info);
            c.add("public static final %s %s = new %s();", new Object[]{eventClassName, ctxt.getEventFieldName(runtimeEventIdx), eventClassName});
        }
        for (Event event : ctxt.getEvents()) {
            runtimeEventIdx = ctxt.getRuntimeEventIdx(event);
            eventClassName = ctxt.getEventClassName(event);
            c.add("public static final %s %s = new %s();", new Object[]{eventClassName, ctxt.getEventFieldName(runtimeEventIdx), eventClassName});
        }
        c.add();
        c.add("@Override");
        c.add("protected void initAutomata() {");
        c.indent();
        List<Automaton> automata = ctxt.getAutomata();
        for (Automaton aut : automata) {
            c.add("automata.add(new %s());", new Object[]{ctxt.getAutClassName(aut)});
        }
        c.dedent();
        c.add("}");
        List<Declaration> stateVars = ctxt.getStateVars();
        List<AlgVariable> algVars = ctxt.getAlgVars();
        List stateObjs = Lists.concat((List[])new List[]{automata, stateVars, algVars});
        int subMethodCount = (int)Math.ceil((double)stateObjs.size() / 1000.0);
        int automataOffset = 0;
        int stateVarsOffset = automataOffset + automata.size();
        int algVarsOffset = stateVarsOffset + stateVars.size();
        c.add();
        c.add("@Override");
        c.add("protected void initStateObjectsMeta() {");
        c.indent();
        int i = 0;
        while (i < subMethodCount) {
            c.add("initStateObjectsMeta%d();", new Object[]{i});
            ++i;
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("private void initStateObjectsMeta0() {");
        c.indent();
        i = 0;
        while (i < stateObjs.size()) {
            PositionObject stateObj;
            if (i > 0 && i % 1000 == 0) {
                c.dedent();
                c.add("}");
                c.add();
                c.add("private void initStateObjectsMeta%d() {", new Object[]{i / 1000});
                c.indent();
            }
            if ((stateObj = (PositionObject)stateObjs.get(i)) instanceof Automaton) {
                Automaton aut = (Automaton)stateObj;
                c.add("stateObjectsMeta.add(new RuntimeStateObjectMeta(%d, StateObjectType.AUTOMATON, \"%s\"));", new Object[]{i - automataOffset, CifTextUtils.getAbsName((PositionObject)aut)});
            } else if (stateObj instanceof DiscVariable) {
                var = (DiscVariable)stateObj;
                c.add("stateObjectsMeta.add(new RuntimeStateObjectMeta(%d, StateObjectType.DISCRETE, \"%s\"));", new Object[]{i - stateVarsOffset, CifTextUtils.getAbsName((PositionObject)var)});
            } else if (stateObj instanceof InputVariable) {
                var = (InputVariable)stateObj;
                c.add("stateObjectsMeta.add(new RuntimeStateObjectMeta(%d, StateObjectType.INPUT, \"%s\"));", new Object[]{i - stateVarsOffset, CifTextUtils.getAbsName((PositionObject)var)});
            } else if (stateObj instanceof ContVariable) {
                var = (ContVariable)stateObj;
                String absVarName = CifTextUtils.getAbsName((PositionObject)var);
                c.add("stateObjectsMeta.add(new RuntimeStateObjectMeta(%d, StateObjectType.CONTINUOUS, \"%s\"));", new Object[]{i - stateVarsOffset, absVarName});
                c.add("stateObjectsMeta.add(new RuntimeStateObjectMeta(%d, StateObjectType.DERIVATIVE, \"%s\"));", new Object[]{i - stateVarsOffset, absVarName + "'"});
            } else if (stateObj instanceof AlgVariable) {
                var = (AlgVariable)stateObj;
                c.add("stateObjectsMeta.add(new RuntimeStateObjectMeta(%d, StateObjectType.ALGEBRAIC, \"%s\"));", new Object[]{i - algVarsOffset, CifTextUtils.getAbsName((PositionObject)var)});
            } else {
                throw new RuntimeException("Unknown state object: " + String.valueOf(stateObj));
            }
            ++i;
        }
        c.dedent();
        c.add("}");
        int runtimeEventCount = ctxt.getRuntimeEventCount();
        subMethodCount = (int)Math.ceil((double)runtimeEventCount / 1000.0);
        c.add();
        c.add("@Override");
        c.add("protected void initEvents() {");
        c.indent();
        int i2 = 0;
        while (i2 < subMethodCount) {
            c.add("initEvents%d();", new Object[]{i2});
            ++i2;
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("private void initEvents0() {");
        c.indent();
        int runtimeEventIdx2 = 0;
        while (runtimeEventIdx2 < runtimeEventCount) {
            if (runtimeEventIdx2 > 0 && runtimeEventIdx2 % 1000 == 0) {
                c.dedent();
                c.add("}");
                c.add();
                c.add("private void initEvents%d() {", new Object[]{runtimeEventIdx2 / 1000});
                c.indent();
            }
            c.add("events.add(%s);", new Object[]{ctxt.getEventFieldName(runtimeEventIdx2)});
            ++runtimeEventIdx2;
        }
        c.dedent();
        c.add("}");
        subMethodCount = (int)Math.ceil((double)runtimeEventCount / 100.0);
        c.add();
        c.add("@Override");
        c.add("protected void initEventData() {");
        c.indent();
        i2 = 0;
        while (i2 < subMethodCount) {
            c.add("initEventData%d();", new Object[]{i2});
            ++i2;
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("private void initEventData0() {");
        c.indent();
        c.add("List<List<RuntimeEdge<State>>> outer;");
        c.add("List<RuntimeEdge<State>> inner;");
        runtimeEventIdx2 = 0;
        while (runtimeEventIdx2 < runtimeEventCount) {
            if (runtimeEventIdx2 > 0 && runtimeEventIdx2 % 100 == 0) {
                c.dedent();
                c.add("}");
                c.add();
                c.add("private void initEventData%d() {", new Object[]{runtimeEventIdx2 / 100});
                c.indent();
                c.add("List<List<RuntimeEdge<State>>> outer;");
                c.add("List<RuntimeEdge<State>> inner;");
            }
            RuntimeEventKind kind = ctxt.getRuntimeEventKind(runtimeEventIdx2);
            EventCodeGenerator.EnvironmentEventInfo envInfo = ctxt.tryGetEnvironmentEventInfo(runtimeEventIdx2);
            Event event = ctxt.tryGetRegularOrTauCifEvent(runtimeEventIdx2);
            String name = switch (kind) {
                case RuntimeEventKind.ENVIRONMENT -> envInfo.eventName;
                case RuntimeEventKind.REGULAR -> CifTextUtils.getAbsName((PositionObject)event);
                case RuntimeEventKind.TAU -> "tau";
                default -> throw new MatchException(null, null);
            };
            c.add();
            c.add("// Event \"%s\".", new Object[]{name});
            if (kind == RuntimeEventKind.ENVIRONMENT || kind == RuntimeEventKind.TAU) {
                c.add("syncData.add(null);");
                c.add("sendData.add(null);");
                c.add("recvData.add(null);");
            } else {
                Assert.check((kind == RuntimeEventKind.REGULAR ? 1 : 0) != 0);
                Assert.notNull((Object)event);
                Assert.check((event != ctxt.tauEvent ? 1 : 0) != 0);
                int syncAutCount = ctxt.getSyncAuts(event).size();
                c.add("outer = listc(%d);", new Object[]{syncAutCount});
                c.add("for (int i = 0; i < %d; i++) {", new Object[]{syncAutCount});
                c.indent();
                c.add("inner = listc(1);");
                c.add("outer.add(inner);");
                c.dedent();
                c.add("}");
                c.add("syncData.add(outer);");
                c.add();
                if (event.getType() == null) {
                    c.add("sendData.add(null);");
                    c.add("recvData.add(null);");
                } else {
                    c.add("inner = listc(1);");
                    c.add("sendData.add(inner);");
                    c.add("inner = listc(1);");
                    c.add("recvData.add(inner);");
                }
            }
            ++runtimeEventIdx2;
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public State createInitialState(RuntimeSpec<?> spec) {");
        c.indent();
        c.add("return State.create(spec);");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public State copyState(State state) {");
        c.indent();
        c.add("return State.copy(state);");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public boolean hasTauEdge() {");
        c.indent();
        c.add("return %s;", new Object[]{ctxt.hasTauEdge});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected boolean evalInitPreds(State state) {");
        c.indent();
        c.add("return InitPreds.evalInitPreds(state);");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public boolean evalStateInvPreds(State state, boolean initial) {");
        c.indent();
        c.add("return StateInvPreds.evalStateInvPreds(state, initial);");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected boolean evalUrgLocs(State state) {");
        c.indent();
        c.add("return UrgLocs.evalUrgLocs(state);");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected boolean evalUrgEdges(State state) {");
        c.indent();
        c.add("return UrgEdges.evalUrgEdges(state);");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected List<OdeStateEvent<State>> getOdeStateEvents(State state) {");
        c.indent();
        c.add("return OdeStateEvents.getOdeStateEvents(state);");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public OdeSolver<State> getOdeSolver() {");
        c.indent();
        c.add("return Solver.getSolver();");
        c.dedent();
        c.add("}");
        int svgFileCount = ctxt.getSvgFileToDecls().size();
        c.add();
        c.add("@Override");
        c.add("public List<RuntimeCifSvgDecls> getCifSvgDecls() {");
        c.indent();
        c.add("List<RuntimeCifSvgDecls> rslt = listc(%d);", new Object[]{svgFileCount});
        int i3 = 0;
        while (i3 < svgFileCount) {
            c.add("rslt.add(new CifSvg%d());", new Object[]{i3});
            ++i3;
        }
        c.add("return rslt;");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public List<RuntimePrintDecls> getPrintDecls() {");
        c.indent();
        c.add("List<RuntimePrintDecls> rslt = listc(%d);", new Object[]{ctxt.printFileCount});
        Assert.check((ctxt.printFileCount != -1 ? 1 : 0) != 0);
        i3 = 0;
        while (i3 < ctxt.printFileCount) {
            c.add("rslt.add(new CifPrint%d());", new Object[]{i3});
            ++i3;
        }
        c.add("return rslt;");
        c.dedent();
        c.add("}");
    }
}

