/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.emf;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.emf.ecore.xmi.RealXMIResourceFactory;

public final class LanguageRegistry {
    private LanguageRegistry() {
    }

    public static void registerEcore() {
        LanguageRegistry.registerFactory("ecore", (Resource.Factory)new EcoreResourceFactoryImpl());
    }

    public static void registerFactory(String fileExt, Resource.Factory fact) {
        Resource.Factory old = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(fileExt, fact);
        if (old != null) {
            OutputProvider.warn((String)"Reregistered factory for file extension \"%s\".", (Object[])new Object[]{fileExt});
        }
    }

    public static void registerPackageXmi(String fileExt, EPackage pkg) {
        LanguageRegistry.registerFactory(fileExt, (Resource.Factory)new RealXMIResourceFactory());
        LanguageRegistry.registerPackage(pkg);
    }

    public static void registerPackageXml(String fileExt, EPackage pkg) {
        LanguageRegistry.registerFactory(fileExt, (Resource.Factory)new XMIResourceFactoryImpl());
        LanguageRegistry.registerPackage(pkg);
    }

    public static void registerPackage(EPackage pkg) {
        EPackage old = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(pkg.getNsURI(), pkg);
        if (old != null) {
            OutputProvider.warn((String)"Reregistered package for namespace URI \"%s\".", (Object[])new Object[]{pkg.getNsURI()});
        }
    }
}

