/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.options;

import java.util.Locale;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.datasynth.settings.CifDataSynthesisSettingsDefaults;
import org.eclipse.escet.cif.datasynth.settings.FixedPointComputation;
import org.eclipse.escet.cif.datasynth.settings.FixedPointComputationsOrder;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public class FixedPointComputationsOrderOption
extends StringOption {
    private static final String DESCRIPTION = "Specify the order in which the fixed-point computations are to be performed during synthesis. Multiple fixed-point computations are performed (depending on other settings), to compute the non-blocking states, states satisfying the reachability requirements, controllable states and reachable states. Each computation must be specified exactly once. Specify \"nonblock\", \"reach-reqs\", \"ctrl\", and \"reach\", in the desired order, joined by commas. For instance, specify \"ctrl,reach-reqs,reach,nonblock\" or \"reach,reach-reqs,ctrl,nonblock\".";
    private static final String DEFAULT_VALUE = FixedPointComputationsOrderOption.toString(CifDataSynthesisSettingsDefaults.FIXED_POINT_COMPUTATIONS_ORDER_DEFAULT);

    public FixedPointComputationsOrderOption() {
        super("Fixed-point computations order", DESCRIPTION + Strings.fmt((String)" [DEFAULT=%s]", (Object[])new Object[]{DEFAULT_VALUE}), null, "fixed-point-order", "ORDER", DEFAULT_VALUE, false, true, DESCRIPTION, "Order:");
    }

    public static FixedPointComputationsOrder getOrder() {
        String optionText;
        block22: {
            optionText = (String)Options.get(FixedPointComputationsOrderOption.class);
            if (optionText.contains(",")) break block22;
            switch (optionText.trim()) {
                case "reach-ctrl-nonblock": 
                case "nonblock-ctrl-reach": 
                case "nonblock-reach-ctrl": 
                case "ctrl-nonblock-reach": 
                case "reach-nonblock-ctrl": 
                case "ctrl-reach-nonblock": {
                    OutputProvider.warn((String)"Fixed-point computations order \"%s\" is deprecated. The old syntax with \"-\" characters between the computation names will be removed in a future version. Use the new syntax with commas between the computation names instead. Consult the option's help text and the tool's documentation for more information.", (Object[])new Object[]{optionText});
                    optionText = optionText.replace('-', ',');
                    optionText = optionText.replace("nonblock", "nonblock,reach-reqs");
                }
            }
        }
        String[] parts = optionText.split(",");
        FixedPointComputation[] computations = new FixedPointComputation[parts.length];
        int i = 0;
        while (i < parts.length) {
            String part = parts[i].trim();
            String partName = part.replace('-', '_').toUpperCase(Locale.US);
            try {
                computations[i] = FixedPointComputation.valueOf(partName);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidOptionException(Strings.fmt((String)"Invalid fixed-point computations order \"%s\": \"%s\" is not a valid fixed-point computation name.", (Object[])new Object[]{optionText, part}));
            }
            ++i;
        }
        int actualCount = computations.length;
        int expectedCount = FixedPointComputation.values().length;
        if (actualCount != expectedCount) {
            throw new InvalidOptionException(Strings.fmt((String)"Invalid fixed-point computations order \"%s\": expected %d fixed-point computations, but found %d.", (Object[])new Object[]{optionText, expectedCount, actualCount}));
        }
        if (!Sets.set((Object[])FixedPointComputation.values()).equals(Sets.set((Object[])computations))) {
            throw new InvalidOptionException(Strings.fmt((String)"Invalid fixed-point computations order \"%s\": each fixed-point computation must be specified exactly once.", (Object[])new Object[]{optionText}));
        }
        return new FixedPointComputationsOrder(computations);
    }

    private static String toString(FixedPointComputationsOrder order) {
        return order.computations.stream().map(c -> c.toString().replace('_', '-').toLowerCase(Locale.US)).collect(Collectors.joining(","));
    }
}

