/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class Lists {
    public static final int MAX_SAFE_LIST_SIZE = 0x7FFFFFF7;

    private Lists() {
    }

    public static <T> List<T> add(List<T> lst, T elem) {
        lst.add(elem);
        return lst;
    }

    public static <TI, TR extends TI> List<TR> filter(List<TI> lst, Class<TR> rsltType) {
        List rslt = Lists.list();
        for (TI elem : lst) {
            if (!rsltType.isInstance(elem)) continue;
            rslt.add(elem);
        }
        return rslt;
    }

    public static <TR, TI extends TR> List<TR> copy(List<TI> lst) {
        List rslt = Lists.listc(lst.size());
        for (TI elem : lst) {
            rslt.add(elem);
        }
        return rslt;
    }

    public static <TR, TI extends TR> List<TR> cast(List<TI> lst) {
        return lst;
    }

    @SafeVarargs
    public static <T> List<T> concat(List<? extends T> ... lsts) {
        int cnt = 0;
        List<? extends T>[] listArray = lsts;
        int n = lsts.length;
        int n2 = 0;
        while (n2 < n) {
            List<T> lst = listArray[n2];
            cnt += lst.size();
            ++n2;
        }
        List<T> rslt = Lists.listc(cnt);
        List<? extends T>[] listArray2 = lsts;
        int n3 = lsts.length;
        n = 0;
        while (n < n3) {
            List<? extends T> lst = listArray2[n];
            rslt.addAll(lst);
            ++n;
        }
        return rslt;
    }

    public static <TR, T1 extends TR, T2 extends TR> List<TR> concat(List<T1> l1, List<T2> l2) {
        List rslt = Lists.listc(l1.size() + l2.size());
        rslt.addAll(l1);
        rslt.addAll(l2);
        return rslt;
    }

    public static <TR, TE extends TR, TL extends TR> List<TR> concat(TE elem, List<TL> lst) {
        List rslt = Lists.listc(lst.size() + 1);
        rslt.add(elem);
        rslt.addAll(lst);
        return rslt;
    }

    public static <TR, TE extends TR, TL extends TR> List<TR> concat(List<TL> lst, TE elem) {
        List rslt = Lists.listc(lst.size() + 1);
        rslt.addAll(lst);
        rslt.add(elem);
        return rslt;
    }

    @SafeVarargs
    public static <TR, TI extends TR> List<TR> list(TI ... elems) {
        List rslt = Lists.listc(elems.length);
        TI[] TIArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            TI elem = TIArray[n2];
            rslt.add(elem);
            ++n2;
        }
        return rslt;
    }

    public static <TR, TI extends TR> List<TR> list(TI elem) {
        List rslt = Lists.listc(1);
        rslt.add(elem);
        return rslt;
    }

    public static <T> List<T> list() {
        return new ArrayList();
    }

    public static <T> List<T> listc(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public static <T> T last(List<T> lst) {
        return lst.get(lst.size() - 1);
    }

    public static <T> T first(List<T> lst) {
        return lst.get(0);
    }

    public static <T> boolean areEqualOrShifted(List<T> lst1, List<T> lst2) {
        if (lst1.size() != lst2.size()) {
            return false;
        }
        if (lst1 == lst2 || lst1.equals(lst2)) {
            return true;
        }
        int n = lst1.size();
        int i = 1;
        while (i < n) {
            if (lst1.subList(i, n).equals(lst2.subList(0, n - i)) && lst1.subList(0, i).equals(lst2.subList(n - i, n))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <TR, TI extends TR> List<TR> reverse(List<TI> lst) {
        List<TR> rslt = Lists.copy(lst);
        Collections.reverse(rslt);
        return rslt;
    }

    public static <TL, TS extends TL> List<TL> set2list(Set<TS> set) {
        return new ArrayList<TS>(set);
    }

    public static <T> List<T> slice(List<T> lst, Integer beginIndex, Integer endIndex) {
        int e;
        int len = lst.size();
        int b = beginIndex == null ? 0 : beginIndex;
        int n = e = endIndex == null ? len : endIndex;
        if (b < 0) {
            b = len + b;
        }
        if (e < 0) {
            e = len + e;
        }
        if (b < 0) {
            b = 0;
        }
        if (e < 0) {
            e = 0;
        }
        if (b > len) {
            b = len;
        }
        if (e > len) {
            e = len;
        }
        if (b > e) {
            b = e;
        }
        return lst.subList(b, e);
    }

    public static <T> T single(List<T> list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException("List does not have exactly one element: " + String.valueOf(list));
        }
        return list.get(0);
    }

    public static <T> Collector<T, List<T>, List<T>> toList() {
        return new Collector<T, List<T>, List<T>>(){

            @Override
            public Supplier<List<T>> supplier() {
                return () -> Lists.list();
            }

            @Override
            public BiConsumer<List<T>, T> accumulator() {
                return (lst, val) -> {
                    boolean bl = lst.add(val);
                };
            }

            @Override
            public BinaryOperator<List<T>> combiner() {
                return (lst1, lst2) -> {
                    lst1.addAll(lst2);
                    return lst1;
                };
            }

            @Override
            public Function<List<T>, List<T>> finisher() {
                return result -> result;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
            }
        };
    }
}

