/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.emf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.escet.common.emf.EMFResourceException;
import org.eclipse.escet.common.emf.ecore.xmi.RealXMIResource;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Exceptions;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public final class EMFHelper {
    private EMFHelper() {
    }

    public static Resource copyResource(Resource orig, URI newUri, boolean preserveXmiIds) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource rslt = resourceSet.createResource(newUri);
        EList rootObjs = orig.getContents();
        Collection newRootObjs = EcoreUtil.copyAll((Collection)rootObjs);
        rslt.getContents().addAll(newRootObjs);
        if (preserveXmiIds && orig.getClass() == RealXMIResource.class && rslt.getClass() == RealXMIResource.class) {
            EMFHelper.syncXmiIds((List<EObject>)rslt.getContents(), (List<EObject>)orig.getContents());
        }
        return rslt;
    }

    public static void syncXmiIds(List<EObject> target, List<EObject> source) {
        Assert.check((target.size() == source.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < target.size()) {
            EObject targetElem = target.get(i);
            EObject sourceElem = source.get(i);
            EMFHelper.syncXmiIds(targetElem, sourceElem);
            ++i;
        }
    }

    public static void syncXmiIds(EObject target, EObject source) {
        Assert.check((target.eClass() == source.eClass() ? 1 : 0) != 0);
        Resource sourceRes = source.eResource();
        Resource targetRes = target.eResource();
        if (sourceRes instanceof XMLResource && targetRes instanceof XMLResource) {
            XMLResource sourceXRes = (XMLResource)sourceRes;
            XMLResource targetXRes = (XMLResource)targetRes;
            String sourceXmiId = sourceXRes.getID(source);
            targetXRes.setID(target, sourceXmiId);
        }
        EMFHelper.syncXmiIds((List<EObject>)target.eContents(), (List<EObject>)source.eContents());
    }

    public static void normalizeXmiIds(XMLResource resource) {
        int id = 0;
        TreeIterator iter = resource.getAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            resource.setID(obj, Integer.toString(++id));
        }
    }

    public static void checkResourceWarningsErrors(Resource resource, boolean strict) throws EMFResourceException {
        StringBuilder diagMsg;
        if (resource.getErrors().isEmpty() && (!strict || resource.getWarnings().isEmpty())) {
            return;
        }
        List messages = Lists.list();
        for (Resource.Diagnostic diagnostic : resource.getWarnings()) {
            diagMsg = new StringBuilder();
            diagMsg.append("WARNING: ");
            diagMsg.append(diagnostic.getMessage());
            if (diagnostic.getLocation() != null) {
                diagMsg.append(" (location: " + diagnostic.getLocation());
                if (diagnostic.getLine() > 0) {
                    diagMsg.append(", line: " + diagnostic.getLine());
                    if (diagnostic.getColumn() > 0) {
                        diagMsg.append(", column: " + diagnostic.getColumn());
                    }
                }
                diagMsg.append(")");
            }
            messages.add(diagMsg.toString());
        }
        for (Resource.Diagnostic diagnostic : resource.getErrors()) {
            diagMsg = new StringBuilder();
            diagMsg.append("ERROR: ");
            diagMsg.append(diagnostic.getMessage());
            if (diagnostic.getLocation() != null) {
                diagMsg.append(" (location: " + diagnostic.getLocation());
                if (diagnostic.getLine() > 0) {
                    diagMsg.append(", line: " + diagnostic.getLine());
                    if (diagnostic.getColumn() > 0) {
                        diagMsg.append(", column: " + diagnostic.getColumn());
                    }
                }
                diagMsg.append(")");
            }
            messages.add(diagMsg.toString());
        }
        String message = String.join((CharSequence)Strings.NL, messages);
        EMFResourceException cause = new EMFResourceException(message);
        String msg = Strings.fmt((String)"Could not load resource \"%s\": resource has %,d errors, %,d warnings.", (Object[])new Object[]{resource.getURI(), resource.getErrors().size(), resource.getWarnings().size()});
        throw new EMFResourceException(msg, cause);
    }

    public static void checkResourceWarningsErrors(Resource resource, Collection<Diagnostic> diagnostics, boolean strict) throws EMFResourceException {
        boolean anyError = false;
        boolean anyWarning = false;
        for (Diagnostic diagnostic : diagnostics) {
            if (diagnostic.getSeverity() == 4) {
                anyError = true;
            }
            if (diagnostic.getSeverity() != 2) continue;
            anyWarning = true;
        }
        if (!(anyError || strict && anyWarning)) {
            return;
        }
        List messages = Lists.list();
        int errorCount = 0;
        int warningCount = 0;
        LinkedList<Diagnostic> todos = new LinkedList<Diagnostic>();
        todos.addAll(diagnostics);
        while (!todos.isEmpty()) {
            Diagnostic diagnostic = (Diagnostic)todos.pollFirst();
            StringBuilder diagMsg = new StringBuilder();
            if (diagnostic.getSeverity() == 4) {
                diagMsg.append("ERROR: ");
                ++errorCount;
            } else {
                if (diagnostic.getSeverity() != 2) continue;
                diagMsg.append("ERROR: ");
                ++warningCount;
            }
            diagMsg.append(diagnostic.getMessage());
            if (diagnostic.getException() != null) {
                diagMsg.append(" (exception: ");
                diagMsg.append(Exceptions.exToLine((Throwable)diagnostic.getException()));
            }
            if (diagnostic.getSource() != null) {
                if (diagnostic.getException() == null) {
                    diagMsg.append(" (source: ");
                } else {
                    diagMsg.append(", source: ");
                }
                diagMsg.append(diagnostic.getSource());
            }
            if (diagnostic.getException() != null || diagnostic.getSource() != null) {
                diagMsg.append(")");
            }
            messages.add(diagMsg.toString());
            todos.addAll(diagnostic.getChildren());
        }
        String message = String.join((CharSequence)Strings.NL, messages);
        EMFResourceException cause = new EMFResourceException(message);
        String msg = Strings.fmt((String)"Could not load resource \"%s\": resource has %,d errors, %,d warnings.", (Object[])new Object[]{resource.getURI(), errorCount, warningCount});
        throw new EMFResourceException(msg, cause);
    }

    public static <T extends EObject> T deepclone(T obj) {
        return (T)EcoreUtil.copy(obj);
    }

    public static <T extends EObject> Collection<T> deepclone(Collection<T> objs) {
        return EcoreUtil.copyAll(objs);
    }

    public static <T extends EObject> List<T> deepclone(List<T> objs) {
        return (List)EcoreUtil.copyAll(objs);
    }

    public static void printEObjectXML(EObject obj, String fileExt, OutputStream stream) {
        ResourceSetImpl s = new ResourceSetImpl();
        Resource r = s.createResource(URI.createURI((String)("memory:///dummy." + fileExt)));
        if (obj.eContainer() != null) {
            throw new IllegalArgumentException("obj.eContainer() != null");
        }
        r.getContents().add((Object)obj);
        try {
            r.save(stream, null);
            stream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void updateParentContainment(EObject child, EObject newChild) {
        if (child == newChild) {
            return;
        }
        EObject parent = child.eContainer();
        Assert.notNull((Object)parent);
        EReference feature = child.eContainmentFeature();
        if (feature.isMany()) {
            List children = (List)parent.eGet((EStructuralFeature)feature);
            int idx = children.indexOf(child);
            Assert.check((idx != -1 ? 1 : 0) != 0);
            children.set(idx, newChild);
        } else {
            parent.eSet((EStructuralFeature)feature, (Object)newChild);
        }
    }

    public static void removeFromParentContainment(EObject child) {
        EObject parent = child.eContainer();
        Assert.notNull((Object)parent);
        EReference feature = child.eContainmentFeature();
        if (feature.isMany()) {
            List children = (List)parent.eGet((EStructuralFeature)feature);
            int idx = children.indexOf(child);
            Assert.check((idx != -1 ? 1 : 0) != 0);
            children.remove(idx);
        } else {
            parent.eSet((EStructuralFeature)feature, null);
        }
    }
}

