/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.Objects;
import org.eclipse.escet.common.java.Strings;

public class Pair<T1, T2> {
    public final T1 left;
    public final T2 right;

    public Pair(T1 left, T2 right) {
        this.left = left;
        this.right = right;
    }

    public static <TL, TR> Pair<TL, TR> pair(TL left, TR right) {
        return new Pair<TL, TR>(left, right);
    }

    public int hashCode() {
        return Objects.hashCode(this.left) ^ Objects.hashCode(this.right);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }

    public String toString() {
        return Strings.fmt("(%s, %s)", this.left, this.right);
    }
}

