/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.ElimAlgVariables;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimConsts;
import org.eclipse.escet.cif.cif2cif.ElimIfUpdates;
import org.eclipse.escet.cif.cif2cif.ElimStateEvtExclInvs;
import org.eclipse.escet.cif.cif2cif.ElimStateInvs;
import org.eclipse.escet.cif.cif2cif.ElimTypeDecls;
import org.eclipse.escet.cif.cif2cif.LinearizeProduct;
import org.eclipse.escet.cif.cif2cif.RemoveAnnotations;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.SimplifyValues;
import org.eclipse.escet.cif.cif2cif.SwitchesToIfs;
import org.eclipse.escet.cif.cif2mcrl2.CifToMcrl2PreChecker;
import org.eclipse.escet.cif.cif2mcrl2.ProcessValueActions;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEnumUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifMarkedUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifToMcrl2Transformer {
    private final Termination termination;
    private final WarnOutput warnOutput;
    private Map<EnumDecl, EnumDecl> enums;
    private Map<DiscVariable, String> origDiscVarNames;
    private Map<DiscVariable, String> origAutNames;

    public CifToMcrl2Transformer(Termination termination, WarnOutput warnOutput) {
        this.termination = termination;
        this.warnOutput = warnOutput;
    }

    public CodeBox transform(Specification spec, String absSpecPath, String valueActionPatterns, boolean addMarked, WarnOutput warnOutput) {
        this.preprocess1(spec);
        CifToMcrl2PreChecker checker = new CifToMcrl2PreChecker(this.termination);
        checker.reportPreconditionViolations(spec, absSpecPath, "CIF to mCRL2 transformer");
        List origVars = (List)CifCollectUtils.collectDiscVariables((ComplexComponent)spec, (Collection)Lists.list());
        this.origDiscVarNames = origVars.stream().collect(Collectors.toMap(v -> v, v -> CifTextUtils.getAbsName((PositionObject)v, (boolean)false)));
        this.origAutNames = this.preprocess2(spec, warnOutput);
        this.enums = CifEnumUtils.getEnumDeclReprs((List)((List)CifCollectUtils.collectEnumDecls((ComplexComponent)spec, (Collection)Lists.list())));
        List vars = (List)CifCollectUtils.collectDiscAndInputVariables((ComplexComponent)spec, (Collection)Lists.list());
        List<InputVariable> inputVars = vars.stream().filter(InputVariable.class::isInstance).map(InputVariable.class::cast).toList();
        List events = (List)CifCollectUtils.collectEvents((ComplexComponent)spec, (Collection)Lists.list());
        List linearizedAuts = (List)CifCollectUtils.collectAutomata((ComplexComponent)spec, (Collection)Lists.list());
        Automaton aut = (Automaton)Lists.single((List)linearizedAuts);
        Location loc = (Location)Lists.single((List)aut.getLocations());
        EList edges = loc.getEdges();
        Set<Declaration> valueActionVars = this.determineValueActionVars(vars, valueActionPatterns);
        Expression marked = addMarked ? this.getMarked(spec) : null;
        SimplifyValues simplifyValues = new SimplifyValues();
        List<Expression> initPreds = CifCollectUtils.getComplexComponentsStream((ComplexComponent)spec).flatMap(comp -> comp.getInitials().stream()).toList();
        initPreds = initPreds.stream().map(pred -> simplifyValues.transform(pred)).filter(pred -> !CifValueUtils.isTriviallyTrue((Expression)pred, (boolean)true, (boolean)true)).toList();
        MemoryCodeBox code = new MemoryCodeBox();
        code.add("% Generated by the CIF to mCRL2 transformer of the Eclipse ESCET toolkit.");
        code.add();
        this.addSortsForEnums(code);
        this.addActionsForEvents(events, code);
        this.addActionsForInputVars(inputVars, code);
        this.addVarValueActions(valueActionVars, code);
        if (addMarked) {
            this.addMarkedAction(code);
        }
        this.addProcess(vars, inputVars, valueActionVars, (List<Edge>)edges, marked, code);
        this.addInstantiationForInit(vars, initPreds, code);
        return code;
    }

    private void preprocess1(Specification spec) {
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        removeIoDecls.warnAboutIgnoredSvgInputDecsIfRemoved(this.warnOutput);
        new RemoveAnnotations().transform(spec);
        new ElimComponentDefInst().transform(spec);
        new SimplifyValues().transform(spec);
    }

    private Map<DiscVariable, String> preprocess2(Specification spec, WarnOutput warnOutput) {
        new ElimTypeDecls().transform(spec);
        new ElimConsts().transform(spec);
        new ElimAlgVariables().transform(spec);
        new ElimStateEvtExclInvs(warnOutput).transform(spec);
        LinearizeProduct linearize = new LinearizeProduct(true, warnOutput);
        linearize.transform(spec);
        new ElimStateInvs().transform(spec);
        new SwitchesToIfs().transform(spec);
        new ElimIfUpdates().transform(spec);
        return linearize.getLpVarToAbsAutNameMap();
    }

    private Set<Declaration> determineValueActionVars(List<Declaration> vars, String valueActionPatterns) {
        Declaration prev;
        Map namesMap = Maps.mapc((int)(this.origDiscVarNames.size() + this.origAutNames.size()));
        for (Map.Entry<DiscVariable, String> entry : this.origDiscVarNames.entrySet()) {
            prev = namesMap.put(entry.getValue(), (Declaration)entry.getKey());
            Assert.check((prev == null ? 1 : 0) != 0);
        }
        for (Map.Entry<DiscVariable, String> entry : this.origAutNames.entrySet()) {
            prev = namesMap.put(entry.getValue(), (Declaration)entry.getKey());
            Assert.check((prev == null ? 1 : 0) != 0);
        }
        for (Declaration var : vars) {
            if (!(var instanceof InputVariable)) continue;
            prev = namesMap.put(CifTextUtils.getAbsName((PositionObject)var, (boolean)false), var);
            Assert.check((prev == null ? 1 : 0) != 0);
        }
        Set names = Sets.list2set((List)Sets.sortedstrings(namesMap.keySet()));
        Set<String> includeNames = ProcessValueActions.matchNames(valueActionPatterns, names, this.warnOutput);
        Set result = (Set)includeNames.stream().map(n -> (Declaration)namesMap.get(n)).collect(Sets.toSet());
        Assert.check((boolean)vars.containsAll(result));
        return result;
    }

    private Expression getMarked(Specification spec) {
        Expression marked = CifMarkedUtils.getMarked((Specification)spec);
        return new SimplifyValues().transform(marked);
    }

    private void addSortsForEnums(MemoryCodeBox code) {
        if (this.enums.isEmpty()) {
            return;
        }
        code.add("% Sorts for CIF enumerations.");
        for (EnumDecl enumDecl : (Set)this.enums.values().stream().collect(Sets.toSet())) {
            String litNames = enumDecl.getLiterals().stream().map(l -> this.getName((PositionObject)l)).collect(Collectors.joining(" | "));
            code.add("sort %s = struct %s;", new Object[]{this.getName((PositionObject)enumDecl), litNames});
        }
        code.add();
    }

    private void addActionsForEvents(List<Event> events, MemoryCodeBox code) {
        if (events.isEmpty()) {
            return;
        }
        code.add("% Actions for CIF events.");
        for (Event event : events) {
            code.add("act %s;", new Object[]{this.getName((PositionObject)event)});
        }
        code.add();
    }

    private void addActionsForInputVars(List<InputVariable> inputVars, MemoryCodeBox code) {
        if (inputVars.isEmpty()) {
            return;
        }
        code.add("% Actions for CIF input variables.");
        for (InputVariable inputVar : inputVars) {
            code.add("act %s'input;", new Object[]{this.getName((PositionObject)inputVar)});
        }
        code.add();
    }

    private void addVarValueActions(Set<Declaration> vars, MemoryCodeBox code) {
        if (vars.isEmpty()) {
            return;
        }
        code.add("% Actions for CIF variables/automata having certain values/locations.");
        for (Declaration var : vars) {
            code.add("act %s'varvalue: %s;", new Object[]{this.getName((PositionObject)var), this.generateSortExprForType(CifToMcrl2Transformer.getVarType(var))});
        }
        code.add();
    }

    private void addMarkedAction(MemoryCodeBox code) {
        code.add("% Action for CIF marker predicate.");
        code.add("act marked;");
        code.add();
    }

    private void addProcess(List<Declaration> vars, List<InputVariable> inputVars, Set<Declaration> valueActVars, List<Edge> edges, Expression marked, MemoryCodeBox code) {
        code.add("% Process for behavior of the CIF specification.");
        if (vars.isEmpty()) {
            code.add("proc P =");
        } else {
            code.add("proc P(");
            code.indent();
            int i = 0;
            while (i < vars.size()) {
                Declaration var = vars.get(i);
                boolean isLast = i == vars.size() - 1;
                code.add("%s: %s%s", new Object[]{this.getName((PositionObject)var), this.generateSortExprForType(CifToMcrl2Transformer.getVarType(var)), isLast ? "" : ","});
                ++i;
            }
            code.dedent();
            code.add(") =");
        }
        code.indent();
        boolean first = true;
        boolean firstEdge = true;
        for (Edge edge : edges) {
            if (!first) {
                code.add("+");
            }
            first = false;
            if (firstEdge) {
                code.add("% CIF linearized edges.");
                firstEdge = false;
            }
            this.addProcessExprForEdge(edge, vars, code);
        }
        boolean firstInputVarAct = true;
        for (InputVariable inputVar : inputVars) {
            if (!first) {
                code.add("+");
            }
            first = false;
            if (firstInputVarAct) {
                code.add("% CIF input variable actions.");
                firstInputVarAct = false;
            }
            this.addProcessExprForInputVar(inputVar, code);
        }
        boolean firstValueAct = true;
        for (Declaration valueActVar : valueActVars) {
            if (!first) {
                code.add("+");
            }
            first = false;
            if (firstValueAct) {
                code.add("% CIF variable value actions.");
                firstValueAct = false;
            }
            this.addProcessExprForVarWithValueAct(valueActVar, code);
        }
        if (marked != null) {
            if (!first) {
                code.add("+");
            }
            first = false;
            code.add("% CIF 'marked' action.");
            this.addProcessExprForMarked(marked, code);
        }
        if (first) {
            code.add("delta");
        }
        code.dedent();
        code.add(";");
    }

    private String generateSortExprForType(CifType type) {
        if (type instanceof BoolType) {
            return "Bool";
        }
        if (type instanceof IntType) {
            return "Int";
        }
        if (type instanceof EnumType) {
            EnumType enumType = (EnumType)type;
            EnumDecl representative = this.enums.get(enumType.getEnum());
            return this.getName((PositionObject)representative);
        }
        throw new AssertionError((Object)("Unexpected type: " + String.valueOf(type)));
    }

    private void addProcessExprForEdge(Edge edge, List<Declaration> vars, MemoryCodeBox code) {
        String event;
        List guards = Lists.list();
        guards.addAll(EMFHelper.deepclone((List)edge.getGuards()));
        Map<DiscVariable, Expression> assignments = this.getAssignments((List<Update>)edge.getUpdates());
        List<DiscVariable> intVars = vars.stream().filter(DiscVariable.class::isInstance).map(DiscVariable.class::cast).filter(v -> v.getType() instanceof IntType).toList();
        for (DiscVariable var : intVars) {
            Expression newValue = assignments.get(var);
            if (newValue == null) continue;
            int lower = CifTypeUtils.getLowerBound((IntType)((IntType)var.getType()));
            int upper = CifTypeUtils.getUpperBound((IntType)((IntType)var.getType()));
            guards.addAll(this.createRangeGuards(newValue, lower, upper));
        }
        Expression guardExpr = CifValueUtils.createConjunction((List)guards);
        guardExpr = new SimplifyValues().transform(guardExpr);
        String guard = this.generateExpr(guardExpr, false);
        EdgeEvent edgeEvent = (EdgeEvent)Lists.single((List)edge.getEvents());
        Expression eventRef = edgeEvent.getEvent();
        if (eventRef instanceof EventExpression) {
            EventExpression eventExpr = (EventExpression)eventRef;
            event = this.getName((PositionObject)eventExpr.getEvent());
        } else if (eventRef instanceof TauExpression) {
            event = "tau";
        } else {
            throw new AssertionError((Object)("Unexpected event reference: " + String.valueOf(eventRef)));
        }
        String updates = assignments.entrySet().stream().map(e -> Strings.fmt((String)"%s = %s", (Object[])new Object[]{this.getName((PositionObject)e.getKey()), this.generateExpr((Expression)e.getValue(), false)})).collect(Collectors.joining(", "));
        code.add("(%s) -> %s . P(%s)", new Object[]{guard, event, updates});
    }

    private List<Expression> createRangeGuards(Expression value, int lower, int upper) {
        Expression left1 = CifValueUtils.makeInt((int)lower);
        Expression right1 = (Expression)EMFHelper.deepclone((EObject)value);
        BinaryExpression bexpr1 = CifConstructors.newBinaryExpression();
        bexpr1.setLeft(left1);
        bexpr1.setOperator(BinaryOperator.LESS_EQUAL);
        bexpr1.setRight(right1);
        bexpr1.setType((CifType)CifConstructors.newBoolType());
        Expression left2 = (Expression)EMFHelper.deepclone((EObject)value);
        Expression right2 = CifValueUtils.makeInt((int)upper);
        BinaryExpression bexpr2 = CifConstructors.newBinaryExpression();
        bexpr2.setLeft(left2);
        bexpr2.setOperator(BinaryOperator.LESS_EQUAL);
        bexpr2.setRight(right2);
        bexpr2.setType((CifType)CifConstructors.newBoolType());
        return List.of(bexpr1, bexpr2);
    }

    private Map<DiscVariable, Expression> getAssignments(List<Update> updates) {
        Map result = Maps.mapc((int)updates.size());
        for (Update update : updates) {
            Assert.check((boolean)(update instanceof Assignment));
            Assignment asgn = (Assignment)update;
            Assert.check((boolean)(asgn.getAddressable() instanceof DiscVariableExpression));
            DiscVariable var = ((DiscVariableExpression)asgn.getAddressable()).getVariable();
            Expression value = asgn.getValue();
            Expression prev = result.put(var, value);
            Assert.check((prev == null ? 1 : 0) != 0);
        }
        return result;
    }

    private void addProcessExprForInputVar(InputVariable var, MemoryCodeBox code) {
        List conditions = Lists.listc((int)2);
        CifType cifType = var.getType();
        if (cifType instanceof IntType) {
            IntType intType = (IntType)cifType;
            conditions.add(Strings.fmt((String)"(%s <= i)", (Object[])new Object[]{CifTypeUtils.getLowerBound((IntType)intType)}));
            conditions.add(Strings.fmt((String)"(i <= %s)", (Object[])new Object[]{CifTypeUtils.getUpperBound((IntType)intType)}));
        }
        conditions.add(Strings.fmt((String)"(i != %s)", (Object[])new Object[]{this.getName((PositionObject)var)}));
        String condition = conditions.size() == 1 ? (String)Lists.single((List)conditions) : Strings.fmt((String)"(%s)", (Object[])new Object[]{conditions.stream().collect(Collectors.joining(" && "))});
        code.add("sum i: %s . %s -> %s'input . P(%s = i)", new Object[]{this.generateSortExprForType(var.getType()), condition, this.getName((PositionObject)var), this.getName((PositionObject)var)});
    }

    private void addProcessExprForVarWithValueAct(Declaration var, MemoryCodeBox code) {
        code.add("%s'varvalue(%s) . P()", new Object[]{this.getName((PositionObject)var), this.getName((PositionObject)var)});
    }

    private void addProcessExprForMarked(Expression marked, MemoryCodeBox code) {
        code.add("(%s) -> marked . P()", new Object[]{this.generateExpr(marked, false)});
    }

    private String generatePreds(List<Expression> preds, boolean initial) {
        if (preds.isEmpty()) {
            return "true";
        }
        if (preds.size() == 1) {
            return this.generateExpr((Expression)Lists.first(preds), initial);
        }
        return preds.stream().map(p -> this.generateExpr((Expression)p, initial)).collect(Collectors.joining(" && ", "(", ")"));
    }

    private String generateExpr(Expression expr, boolean initial) {
        Integer intValue = CifValueUtils.tryGetIntLiteralValue((Expression)expr);
        if (intValue != null) {
            return intValue.toString();
        }
        if (expr instanceof BoolExpression) {
            BoolExpression boolExpr = (BoolExpression)expr;
            return boolExpr.isValue() ? "true" : "false";
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression binExpr = (BinaryExpression)expr;
            String left = this.generateExpr(binExpr.getLeft(), initial);
            String right = this.generateExpr(binExpr.getRight(), initial);
            String op = switch (binExpr.getOperator()) {
                case BinaryOperator.ADDITION -> "+";
                case BinaryOperator.BI_CONDITIONAL -> "==";
                case BinaryOperator.CONJUNCTION -> "&&";
                case BinaryOperator.DISJUNCTION -> "||";
                case BinaryOperator.EQUAL -> "==";
                case BinaryOperator.GREATER_EQUAL -> ">=";
                case BinaryOperator.GREATER_THAN -> ">";
                case BinaryOperator.IMPLICATION -> "=>";
                case BinaryOperator.INTEGER_DIVISION -> "div";
                case BinaryOperator.LESS_EQUAL -> "<=";
                case BinaryOperator.LESS_THAN -> "<";
                case BinaryOperator.MODULUS -> "mod";
                case BinaryOperator.MULTIPLICATION -> "*";
                case BinaryOperator.SUBTRACTION -> "-";
                case BinaryOperator.UNEQUAL -> "!=";
                default -> throw new AssertionError((Object)("Unexpected operator: " + String.valueOf(binExpr.getOperator())));
            };
            return Strings.fmt((String)"(%s %s %s)", (Object[])new Object[]{left, op, right});
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression unExpr = (UnaryExpression)expr;
            String child = this.generateExpr(unExpr.getChild(), initial);
            String op = switch (unExpr.getOperator()) {
                case UnaryOperator.INVERSE -> "!";
                case UnaryOperator.NEGATE -> "-";
                case UnaryOperator.PLUS -> "";
                default -> throw new AssertionError((Object)("Unexpected operator: " + String.valueOf(unExpr.getOperator())));
            };
            return Strings.fmt((String)"%s%s", (Object[])new Object[]{op, child});
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariableExpression discRefExpr = (DiscVariableExpression)expr;
            return this.getName((PositionObject)discRefExpr.getVariable()) + (initial ? "'init" : "");
        }
        if (expr instanceof InputVariableExpression) {
            InputVariableExpression inputRefExpr = (InputVariableExpression)expr;
            return this.getName((PositionObject)inputRefExpr.getVariable()) + (initial ? "'init" : "");
        }
        if (expr instanceof IntExpression) {
            IntExpression intLitExpr = (IntExpression)expr;
            return Integer.toString(intLitExpr.getValue());
        }
        if (expr instanceof EnumLiteralExpression) {
            EnumLiteralExpression enumLitRefExpr = (EnumLiteralExpression)expr;
            EnumLiteral refEnumLit = enumLitRefExpr.getLiteral();
            EnumDecl refEnumDecl = (EnumDecl)refEnumLit.eContainer();
            int litIdx = refEnumDecl.getLiterals().indexOf((Object)refEnumLit);
            EnumDecl representativeEnumDecl = this.enums.get(refEnumDecl);
            EnumLiteral representativeEnumLit = (EnumLiteral)representativeEnumDecl.getLiterals().get(litIdx);
            return this.getName((PositionObject)representativeEnumLit);
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            String result = this.generateExpr(ifExpr.getElse(), initial);
            for (ElifExpression elifExpr : Lists.reverse((List)ifExpr.getElifs())) {
                String elifGuard = this.generatePreds((List<Expression>)elifExpr.getGuards(), initial);
                String elifThen = this.generateExpr(elifExpr.getThen(), initial);
                result = Strings.fmt((String)"if(%s, %s, %s)", (Object[])new Object[]{elifGuard, elifThen, result});
            }
            String ifGuard = this.generatePreds((List<Expression>)ifExpr.getGuards(), initial);
            String ifThen = this.generateExpr(ifExpr.getThen(), initial);
            result = Strings.fmt((String)"if(%s, %s, %s)", (Object[])new Object[]{ifGuard, ifThen, result});
            return result;
        }
        if (expr instanceof CastExpression) {
            CastExpression castExpr = (CastExpression)expr;
            return this.generateExpr(castExpr.getChild(), initial);
        }
        throw new AssertionError((Object)("Unexpected expression: " + String.valueOf(expr)));
    }

    private String evalAndGenerateExpr(Expression expr, boolean initial) {
        Expression value;
        try {
            value = CifEvalUtils.evalAsExpr((Expression)expr, (boolean)true);
        }
        catch (CifEvalException e) {
            throw new AssertionError("Precondition violation.", e);
        }
        return this.generateExpr(value, initial);
    }

    private void addInstantiationForInit(List<Declaration> vars, List<Expression> initPreds, MemoryCodeBox code) {
        if (vars.isEmpty() && initPreds.isEmpty()) {
            code.add();
            code.add("% Initialization.");
            code.add("init P();");
            return;
        }
        List initsPerVar = Lists.listc((int)vars.size());
        boolean hasSingleInitialState = true;
        for (Declaration var : vars) {
            List values;
            if (var instanceof DiscVariable) {
                DiscVariable dvar = (DiscVariable)var;
                VariableValue varValue = dvar.getValue();
                if (varValue == null) {
                    initsPerVar.add(List.of(this.evalAndGenerateExpr(CifValueUtils.getDefaultValue((CifType)dvar.getType(), null), true)));
                    continue;
                }
                if (varValue.getValues().isEmpty()) {
                    if (CifValueUtils.hasSingleValue((CifType)dvar.getType())) {
                        values = CifValueUtils.getPossibleValues((CifType)dvar.getType());
                        initsPerVar.add(List.of(this.evalAndGenerateExpr((Expression)Lists.single((List)values), true)));
                        continue;
                    }
                    initsPerVar.add(null);
                    hasSingleInitialState = false;
                    continue;
                }
                initsPerVar.add(varValue.getValues().stream().map(expr -> this.evalAndGenerateExpr((Expression)expr, true)).toList());
                hasSingleInitialState &= varValue.getValues().size() == 1;
                continue;
            }
            if (var instanceof InputVariable) {
                InputVariable ivar = (InputVariable)var;
                if (CifValueUtils.hasSingleValue((CifType)ivar.getType())) {
                    values = CifValueUtils.getPossibleValues((CifType)ivar.getType());
                    initsPerVar.add(List.of(this.evalAndGenerateExpr((Expression)Lists.single((List)values), true)));
                    continue;
                }
                initsPerVar.add(null);
                hasSingleInitialState = false;
                continue;
            }
            throw new AssertionError((Object)("Unexpected variable: " + String.valueOf(var)));
        }
        if (hasSingleInitialState && initPreds.isEmpty()) {
            code.add();
            code.add("% Initialization.");
            code.add("init P(%s);", new Object[]{initsPerVar.stream().map(inits -> (String)Lists.single((List)inits)).collect(Collectors.joining(", "))});
            return;
        }
        code.add();
        code.add("% Action for initialization, due to having multiple initial states.");
        code.add("act initialize;");
        code.add();
        code.add("% Initialization.");
        code.add("init");
        code.indent();
        List args = Lists.listc((int)vars.size());
        int varIdx = 0;
        while (varIdx < vars.size()) {
            Declaration var = vars.get(varIdx);
            List initsOfVar = (List)initsPerVar.get(varIdx);
            if (initsOfVar != null && initsOfVar.size() == 1 && initPreds.isEmpty()) {
                args.add((String)initsOfVar.get(0));
            } else {
                String sumVarName = this.getName((PositionObject)var) + "'init";
                args.add(sumVarName);
                List conditions = Lists.list();
                CifType cifType = CifToMcrl2Transformer.getVarType(var);
                if (cifType instanceof IntType) {
                    IntType intType = (IntType)cifType;
                    conditions.add(Strings.fmt((String)"(%s <= %s)", (Object[])new Object[]{CifTypeUtils.getLowerBound((IntType)intType), sumVarName}));
                    conditions.add(Strings.fmt((String)"(%s <= %s)", (Object[])new Object[]{sumVarName, CifTypeUtils.getUpperBound((IntType)intType)}));
                }
                if (initsOfVar != null) {
                    conditions.add(initsOfVar.stream().map(v -> Strings.fmt((String)"(%s == %s)", (Object[])new Object[]{sumVarName, v})).collect(Collectors.joining(" || ", "(", ")")));
                }
                String condition = switch (conditions.size()) {
                    case 0 -> "";
                    case 1 -> (String)Lists.single((List)conditions) + " ->";
                    default -> Strings.fmt((String)"(%s) ->", (Object[])new Object[]{conditions.stream().collect(Collectors.joining(" && "))});
                };
                code.add("sum %s: %s . %s", new Object[]{sumVarName, this.generateSortExprForType(CifToMcrl2Transformer.getVarType(var)), condition});
            }
            ++varIdx;
        }
        for (Expression initPred : initPreds) {
            code.add("(%s) ->", new Object[]{this.generateExpr(initPred, true)});
        }
        code.add("initialize . P(%s);", new Object[]{String.join((CharSequence)", ", args)});
        code.dedent();
    }

    private static CifType getVarType(Declaration var) {
        Declaration declaration = var;
        Objects.requireNonNull(declaration);
        Declaration declaration2 = declaration;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DiscVariable.class, InputVariable.class}, (Object)declaration2, n)) {
            case 0 -> {
                DiscVariable dvar = (DiscVariable)declaration2;
                yield dvar.getType();
            }
            case 1 -> {
                InputVariable ivar = (InputVariable)declaration2;
                yield ivar.getType();
            }
            default -> throw new AssertionError((Object)("Unexpected variable: " + String.valueOf(var)));
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getName(PositionObject cifObject) {
        Object name;
        if (cifObject instanceof DiscVariable) {
            DiscVariable dvar = (DiscVariable)cifObject;
            if (this.origDiscVarNames.containsKey(dvar)) {
                name = this.origDiscVarNames.get(dvar);
            } else {
                if (!this.origAutNames.containsKey(dvar)) throw new AssertionError((Object)("Unexpected discrete variable: " + String.valueOf(dvar)));
                name = this.origAutNames.get(dvar);
            }
        } else {
            name = CifTextUtils.getAbsName((PositionObject)cifObject, (boolean)false);
        }
        name = ((String)name).replace('.', '\'');
        return (String)name + "'";
    }
}

