/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifControllerPropertiesAnnotationUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class LiftEvents
implements CifToCifTransformation {
    private final WarnOutput warnOutput;

    public LiftEvents(WarnOutput warnOutput) {
        this.warnOutput = warnOutput;
    }

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Lifting event declarations for a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        List autEvents = Lists.list();
        for (Component component : spec.getComponents()) {
            if (component instanceof Group) {
                String msg = "Lifting event declarations for a CIF specification with groups is currently not supported.";
                throw new CifToCifPreconditionException(msg);
            }
            Assert.check((boolean)(component instanceof Automaton));
            Automaton aut = (Automaton)component;
            autEvents.addAll(Lists.filter((List)aut.getDeclarations(), Event.class));
        }
        Set specNames = CifScopeUtils.getSymbolNamesForScope((PositionObject)spec, null);
        Set liftedNames = Sets.set();
        for (Event event : autEvents) {
            String absName = CifTextUtils.getAbsName((PositionObject)event, (boolean)false).replace('.', '_');
            event.setName(absName);
            liftedNames.add(absName);
        }
        spec.getDeclarations().addAll((Collection)autEvents);
        Set usedNames = Sets.copy((Set)specNames);
        for (Event event : autEvents) {
            if (usedNames.contains(event.getName())) {
                String oldName = event.getName();
                String newName = CifScopeUtils.getUniqueName((String)oldName, (Set)usedNames, (Set)liftedNames);
                event.setName(newName);
                this.warnOutput.line("Event \"%s\" is renamed to \"%s\".", new Object[]{oldName, newName});
            }
            usedNames.add(event.getName());
        }
        CifControllerPropertiesAnnotationUtils.remove((Specification)spec);
    }
}

