/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.options;

import org.eclipse.escet.cif.datasynth.settings.CifDataSynthesisSettingsDefaults;
import org.eclipse.escet.cif.datasynth.settings.FixedPointComputationsOrder;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class FixedPointComputationsOrderOption
extends EnumOption<FixedPointComputationsOrder> {
    public FixedPointComputationsOrderOption() {
        super("Fixed-point computations order", "Specify the order in which the fixed-point computations are to be performed during synthesis. Three fixed-point computations are performed (depending on other settings), to compute the non-blocking states, controllable states and reachable states. Specify \"nonblock\", \"ctrl\", and \"reach\", in the desired order, joined by dashes. For instance, specify \"ctrl-reach-nonblock\" or \"reach-ctrl-nonblock\". [DEFAULT=nonblock-ctrl-reach]", null, "fixed-point-order", "ORDER", (Enum)CifDataSynthesisSettingsDefaults.FIXED_POINT_COMPUTATIONS_ORDER_DEFAULT, true, "Specify the order in which the fixed-point computations are to be performed during synthesis. Three fixed-point computations are performed (depending on other settings), to compute the non-blocking states, controllable states and reachable states.");
    }

    protected String getDialogText(FixedPointComputationsOrder order) {
        switch (order) {
            case NONBLOCK_CTRL_REACH: {
                return "Non-blocking -> controllable -> reachable";
            }
            case NONBLOCK_REACH_CTRL: {
                return "Non-blocking -> reachable -> controllable";
            }
            case CTRL_NONBLOCK_REACH: {
                return "Controllable -> non-blocking -> reachable";
            }
            case CTRL_REACH_NONBLOCK: {
                return "Controllable -> reachable -> non-blocking";
            }
            case REACH_NONBLOCK_CTRL: {
                return "Reachable -> non-blocking -> controllable";
            }
            case REACH_CTRL_NONBLOCK: {
                return "Reachable -> controllable -> non-blocking";
            }
        }
        throw new RuntimeException("Unknown order: " + String.valueOf((Object)order));
    }

    public static FixedPointComputationsOrder getOrder() {
        return (FixedPointComputationsOrder)((Object)Options.get(FixedPointComputationsOrderOption.class));
    }
}

