/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.support;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.ui.behavior.fsm.editor.AbstractFSMDiagramTypeProvider;
import org.eclipse.etrice.ui.behavior.fsm.provider.BaseDiagramProvider;
import org.eclipse.etrice.ui.behavior.fsm.provider.GenModelProvider;
import org.eclipse.etrice.ui.behavior.fsm.support.BaseDiagramPositionProvider;
import org.eclipse.etrice.ui.behavior.fsm.support.IPositionProvider;
import org.eclipse.etrice.ui.behavior.fsm.support.IStateGraphContext;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class GenModelStateGraphContext
implements IStateGraphContext {
    private final GenModelProvider genModel;
    private final BaseDiagramPositionProvider baseDiagram;
    private final Graph graph;

    public GenModelStateGraphContext(AbstractFSMDiagramTypeProvider diagramTypeProvider) {
        BaseDiagramPositionProvider baseDiagramPositionProvider;
        this.genModel = diagramTypeProvider.getGenModelProvider();
        BaseDiagramProvider baseDiagramProvider = new BaseDiagramProvider(diagramTypeProvider);
        this.baseDiagram = baseDiagramPositionProvider = new BaseDiagramPositionProvider(baseDiagramProvider);
        this.graph = this.genModel.getModel().getGraph();
    }

    public GenModelStateGraphContext(Graph graph, GenModelStateGraphContext other) {
        this.genModel = other.genModel;
        this.baseDiagram = other.baseDiagram;
        this.graph = graph;
    }

    @Override
    public List<ChoicePoint> getChPoints() {
        Functions.Function1<Node, StateGraphNode> function1 = new Functions.Function1<Node, StateGraphNode>(){

            public StateGraphNode apply(Node it) {
                return it.getStateGraphNode();
            }
        };
        return IterableExtensions.toList((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)this.graph.getNodes(), (Functions.Function1)function1), ChoicePoint.class));
    }

    @Override
    public List<IStateGraphContext> getChildren() {
        Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                Graph graph = it.getSubgraph();
                return graph != null;
            }
        };
        Functions.Function1<Node, IStateGraphContext> function12 = new Functions.Function1<Node, IStateGraphContext>(){

            public IStateGraphContext apply(Node it) {
                Graph graph = it.getSubgraph();
                GenModelStateGraphContext genModelStateGraphContext = new GenModelStateGraphContext(graph, GenModelStateGraphContext.this);
                return genModelStateGraphContext;
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)this.graph.getNodes(), (Functions.Function1)function1), (Functions.Function1)function12));
    }

    @Override
    public StateGraph getInitialPoint() {
        boolean bl;
        StateGraph stateGraph = null;
        Functions.Function1<Link, Transition> function1 = new Functions.Function1<Link, Transition>(){

            public Transition apply(Link it) {
                return it.getTransition();
            }
        };
        boolean bl2 = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)this.graph.getLinks(), (Functions.Function1)function1), InitialTransition.class));
        boolean bl3 = bl = !bl2;
        if (bl) {
            stateGraph = this.graph.getStateGraph();
        }
        return stateGraph;
    }

    @Override
    public State getParentState() {
        StateGraphNode stateGraphNode = this.graph.getNode().getStateGraphNode();
        return (State)stateGraphNode;
    }

    @Override
    public IPositionProvider getPositionProvider() {
        return this.baseDiagram;
    }

    @Override
    public StateGraph getStateGraph() {
        return this.graph.getStateGraph();
    }

    @Override
    public List<State> getStates() {
        Functions.Function1<Node, StateGraphNode> function1 = new Functions.Function1<Node, StateGraphNode>(){

            public StateGraphNode apply(Node it) {
                return it.getStateGraphNode();
            }
        };
        return IterableExtensions.toList((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)this.graph.getNodes(), (Functions.Function1)function1), State.class));
    }

    @Override
    public List<TrPoint> getTrPoints() {
        Functions.Function1<Node, StateGraphNode> function1 = new Functions.Function1<Node, StateGraphNode>(){

            public StateGraphNode apply(Node it) {
                return it.getStateGraphNode();
            }
        };
        return IterableExtensions.toList((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)this.graph.getNodes(), (Functions.Function1)function1), TrPoint.class));
    }

    @Override
    public List<Transition> getTransitions() {
        Functions.Function1<Link, Transition> function1 = new Functions.Function1<Link, Transition>(){

            public Transition apply(Link it) {
                return it.getTransition();
            }
        };
        return ListExtensions.map((List)this.graph.getLinks(), (Functions.Function1)function1);
    }
}

