/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.etphys.eTPhys;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExecMode implements Enumerator
{
    POLLED(0, "POLLED", "polled"),
    BLOCKED(1, "BLOCKED", "blocked"),
    MIXED(2, "MIXED", "mixed");

    public static final int POLLED_VALUE = 0;
    public static final int BLOCKED_VALUE = 1;
    public static final int MIXED_VALUE = 2;
    private static final ExecMode[] VALUES_ARRAY;
    public static final List<ExecMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExecMode[]{POLLED, BLOCKED, MIXED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExecMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExecMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExecMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExecMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExecMode get(int value) {
        switch (value) {
            case 0: {
                return POLLED;
            }
            case 1: {
                return BLOCKED;
            }
            case 2: {
                return MIXED;
            }
        }
        return null;
    }

    private ExecMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

