/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.common.base.Literal;
import org.eclipse.etrice.core.common.base.LiteralType;
import org.eclipse.etrice.core.common.base.StringLiteral;
import org.eclipse.etrice.core.common.converter.TimeConverter;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InstanceBase;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.gen.Initialization;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.fsm.base.IntelligentSeparator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class NodeGen {
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private ProcedureHelpers helpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    private Initialization attrInitGenAddon;

    public void doGenerate(Root root) {
        Collection collection = ETMapUtil.getNodeRefs();
        for (NodeRef nr : collection) {
            List list = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : list) {
                StructureInstance structureInstance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)structureInstance;
                if (ssi == null) continue;
                String filepath = this._roomExtensions.getPath((RoomClass)ssi.getSubSystemClass());
                String file = this._cExtensions.getCHeaderFileName(nr, ssi);
                this.checkDataPorts(ssi);
                Set usedThreads = ETMapUtil.getUsedThreads((NodeRef)nr, (SubSystemInstance)ssi);
                this.fileIO.generateFile("generating Node declaration", String.valueOf(filepath) + file, this.generateHeaderFile(root, ssi));
                file = this._cExtensions.getCSourceFileName(nr, ssi);
                this.fileIO.generateFile("generating Node implementation", String.valueOf(filepath) + file, this.generateSourceFile(root, ssi, usedThreads));
                file = this._cExtensions.getInstSourceFileName(nr, ssi);
                this.fileIO.generateFile("generating Node instance file", String.valueOf(filepath) + file, this.generateInstanceFile(root, ssi, usedThreads));
                file = this._cExtensions.getDispSourceFileName(nr, ssi);
                this.fileIO.generateFile("generating Node dispatcher file", String.valueOf(filepath) + file, this.generateDispatcherFile(root, ssi, usedThreads));
                file = this._cExtensions.getAddressMapFileName(nr, ssi);
                this.fileIO.generateFile("generating Address map file", file, this.generateAddressMap(root, ssi, usedThreads));
            }
        }
    }

    private CharSequence generateHeaderFile(Root root, SubSystemInstance ssi) {
        StringConcatenation stringConcatenation = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        SubSystemClass ssc = ssi.getSubSystemClass();
        String string = nr.getName();
        String string2 = String.valueOf(string) + "_";
        String string3 = ssi.getName();
        String clsname = String.valueOf(string2) + string3;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Header File of Node ");
        String string4 = nr.getName();
        stringConcatenation2.append(string4, " ");
        stringConcatenation2.append(" with SubSystem ");
        String string5 = ssi.getName();
        stringConcatenation2.append(string5, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence = this._cExtensions.generateIncludeGuardBegin(clsname);
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"etDatatypes.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence2 = this.helpers.userCode(ssc.getUserCode1());
        stringConcatenation2.append((Object)charSequence2);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* lifecycle functions");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* init -> start -> run (loop) -> stop -> destroy");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_init(void);\t\t/* lifecycle init  \t */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_start(void);\t/* lifecycle start \t */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("int ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_run(int argc, char** argv);\t\t/* lifecycle run \t */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_stop(void); \t/* lifecycle stop\t */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_destroy(void); \t/* lifecycle destroy */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_shutdown(void);  /* shutdown the dispatcher loop */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence3 = this.helpers.userCode(ssc.getUserCode2());
        stringConcatenation2.append((Object)charSequence3);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence4 = this._cExtensions.generateIncludeGuardEnd(clsname);
        stringConcatenation2.append((Object)charSequence4);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence generateSourceFile(Root root, SubSystemInstance ssi, final Collection<PhysicalThread> usedThreads) {
        PhysicalThread thread_32;
        Object object;
        String string;
        String string2;
        Iterator iterator;
        String string3;
        StringConcatenation stringConcatenation = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        SubSystemClass ssc = ssi.getSubSystemClass();
        String string4 = nr.getName();
        String string5 = String.valueOf(string4) + "_";
        String string6 = ssi.getName();
        String clsname = String.valueOf(string5) + string6;
        Functions.Function1<PhysicalThread, Boolean> function1 = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                return usedThreads.contains(t);
            }
        };
        Iterable threads = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)function1);
        Functions.Function1<PortInstance, Boolean> function12 = new Functions.Function1<PortInstance, Boolean>(){

            public Boolean apply(PortInstance it) {
                return !it.isRelay() && it.getPort().isConjugated() && Objects.equal((Object)it.getProtocol().getCommType(), (Object)CommunicationType.DATA_DRIVEN);
            }
        };
        List loggedPorts = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)ssi.eAllContents(), PortInstance.class), (Functions.Function1)function12));
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Source File of Node ");
        String string7 = nr.getName();
        stringConcatenation2.append(string7, " ");
        stringConcatenation2.append(" with SubSystem ");
        String string8 = ssi.getName();
        stringConcatenation2.append(string8, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include <stdio.h>");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include <string.h>");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        String string9 = this._cExtensions.getCHeaderFileName(nr, ssi);
        stringConcatenation2.append(string9);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etMSCLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etDataLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"messaging/etSystemProtocol.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"osal/etPlatformLifecycle.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"osal/etTimer.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"osal/etSema.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"runtime/etRuntime.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"etRuntimeConfig.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence = this.helpers.userCode(ssc.getUserCode3());
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* data for Node ");
        String string10 = nr.getName();
        stringConcatenation2.append(string10);
        stringConcatenation2.append(" with SubSystem ");
        String string11 = ssi.getName();
        stringConcatenation2.append(string11);
        stringConcatenation2.append(" */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("typedef struct ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append(" {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("char *name;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("volatile int shutdownRequest;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("} ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append(" ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("Inst = {\"");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("\", 0};");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_initActorInstances(void);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_constructActorInstances(void);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void logDataHeaders();");
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void logData();");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* include instances for all classes */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        String string12 = this._cExtensions.getInstSourceFileName(nr, ssi);
        stringConcatenation2.append(string12);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("#include \"");
        String string13 = this._cExtensions.getDispSourceFileName(nr, ssi);
        stringConcatenation2.append(string13);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_initMessageServices(void) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"initMessageServices\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("etTime interval;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("/* initialization of all message services */");
        stringConcatenation2.newLine();
        Object object2 = new Functions.Function1<PhysicalThread, Long>(){

            public Long apply(PhysicalThread it) {
                long l = it.getPrio();
                return -l;
            }
        };
        Iterator<Object> iterator2 = IterableExtensions.sortBy((Iterable)threads, (Functions.Function1)object2);
        Object object3 = iterator2.iterator();
        while (object3.hasNext()) {
            PhysicalThread thread = (PhysicalThread)object3.next();
            if (Objects.equal((Object)thread.getExecmode(), (Object)ExecMode.POLLED) || Objects.equal((Object)thread.getExecmode(), (Object)ExecMode.MIXED)) {
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("interval.sec = ");
                long l = TimeConverter.split((long)thread.getTime(), (String)"s", (boolean)true);
                stringConcatenation2.append((Object)l, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("interval.nSec = ");
                long l2 = TimeConverter.split((long)thread.getTime(), (String)"ms", (boolean)false);
                stringConcatenation2.append((Object)l2, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("etMessageService_init(");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("&msgService_");
            string3 = thread.getName();
            stringConcatenation2.append(string3, "\t\t\t");
            stringConcatenation2.append(",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("msgBuffer_");
            iterator = thread.getName();
            stringConcatenation2.append((String)((Object)iterator), "\t\t\t");
            stringConcatenation2.append(",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            string2 = thread.getName().toUpperCase();
            stringConcatenation2.append(string2, "\t\t\t");
            stringConcatenation2.append("_POOL_SIZE,");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            string = thread.getName().toUpperCase();
            stringConcatenation2.append(string, "\t\t\t");
            stringConcatenation2.append("_BLOCK_SIZE,");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            int n = thread.getStacksize();
            stringConcatenation2.append((Object)n, "\t\t\t");
            stringConcatenation2.append(",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            long l = thread.getPrio();
            stringConcatenation2.append((Object)l, "\t\t\t");
            stringConcatenation2.append(",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("interval,");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("MsgDispatcher_");
            String string14 = thread.getName();
            stringConcatenation2.append(string14, "\t\t\t");
            stringConcatenation2.append("_receiveMessage,");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("EXECMODE_");
            String string15 = thread.getExecmode().toString().toUpperCase();
            stringConcatenation2.append(string15, "\t\t\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_startMessageServices(void) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"startMessageServices\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        object2 = new Functions.Function1<PhysicalThread, Long>(){

            public Long apply(PhysicalThread it) {
                long l = it.getPrio();
                return -l;
            }
        };
        iterator2 = IterableExtensions.sortBy((Iterable)threads, (Functions.Function1)object2);
        object3 = iterator2.iterator();
        while (object3.hasNext()) {
            PhysicalThread thread_1 = (PhysicalThread)object3.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("etMessageService_start(&msgService_");
            string3 = thread_1.getName();
            stringConcatenation2.append(string3, "\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_stopMessageServices(void) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"stopMessageServices\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        for (PhysicalThread thread_2 : threads) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("etMessageService_stop(&msgService_");
            object = thread_2.getName();
            stringConcatenation2.append((String)object, "\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_destroyMessageServices(void) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"destroyMessageServices\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        for (PhysicalThread thread_32 : threads) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("etMessageService_destroy(&msgService_");
            object = thread_32.getName();
            stringConcatenation2.append((String)object, "\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_init(void) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"init\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etLogger_logInfoF(\"%s_init\", ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("Inst.name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* construct all actors */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_constructActorInstances();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* initialization of all message services */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_initMessageServices();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* init all actors */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_initActorInstances();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* init data logging */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("logDataHeaders();");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("logData();");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_start(void) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"start\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etLogger_logInfoF(\"%s_start\", ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("Inst.name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_startMessageServices();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#ifdef ET_RUNNER_ACTIVATE");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// kept for backwards compatibility, moved to life cycle etUserMainRun");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("static void generatedMainRun(int argc, char** argv) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("etBool runAsTest = false;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("if (argc>1 && strcmp(argv[1], \"-headless\")==0) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("runAsTest = ET_TRUE;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("} if (argc>1 && strcmp(argv[1], \"-run_as_test\")==0) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("runAsTest = ET_TRUE;\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("if (runAsTest) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("etSema_waitForWakeup(etRuntime_getTerminateSemaphore());");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("else {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("printf(\"type quit to exit\\n\");");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("fflush(stdout);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("while (ET_TRUE) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t\t");
        stringConcatenation2.append("char line[64];");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t\t");
        stringConcatenation2.append("if (fgets(line, 64, stdin) != NULL) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t\t\t");
        stringConcatenation2.append("if (strncmp(line, \"quit\", 4)==0)");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t\t\t\t");
        stringConcatenation2.append("break;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#endif");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("int ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_run(int argc, char** argv) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"run\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("#ifndef ET_USER_MAIN_RUN");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// deprecated");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("#ifdef ET_RUNNER_ACTIVATE");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t\t");
        stringConcatenation2.append("generatedMainRun(argc, argv);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("#endif");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("return 0;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("#else");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("return etUserMainRun(argc, argv);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("#endif");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_stop(void){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"stop\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etLogger_logInfoF(\"%s_stop\", ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("Inst.name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_stopMessageServices();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_destroy(void){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"destroy\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etLogger_logInfoF(\"%s_destroy\", ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("Inst.name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        thread_32 = ssi.getAllContainedInstances();
        for (ActorInstance ai : thread_32) {
            stringConcatenation2.append("\t");
            object3 = ai.getActorClass();
            string3 = this._roomExtensions.getPathName(ai.getPath());
            iterator = "&" + string3;
            string2 = this.helpers.invokeUserStructor((RoomClass)object3, (String)((Object)iterator), false);
            stringConcatenation2.append(string2, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("_destroyMessageServices();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_shutdown(void){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"shutdown\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("etLogger_logInfoF(\"%s_shutdown\", ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("Inst.name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("Inst.shutdownRequest = 1;");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_constructActorInstances(void){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"constructActorInstances\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        thread_32 = ssi.getAllContainedInstances();
        for (ActorInstance ai_1 : thread_32) {
            stringConcatenation2.append("\t");
            object3 = ai_1.getActorClass();
            string3 = this._roomExtensions.getPathName(ai_1.getPath());
            iterator = "&" + string3;
            string2 = this.helpers.invokeUserStructor((RoomClass)object3, (String)((Object)iterator), true);
            stringConcatenation2.append(string2, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("_initActorInstances(void){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("\", \"initActorInstances\")");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        thread_32 = ssi.getAllContainedInstances();
        for (ActorInstance ai_2 : thread_32) {
            stringConcatenation2.append("\t");
            object3 = ai_2.getActorClass().getName();
            stringConcatenation2.append((String)object3, "\t");
            stringConcatenation2.append("_init(&");
            string3 = this._roomExtensions.getPathName(ai_2.getPath());
            stringConcatenation2.append(string3, "\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void logDataHeaders() {");
        stringConcatenation2.newLine();
        for (PortInstance pi : loggedPorts) {
            object = new Functions.Function1<Message, Boolean>(){

                public Boolean apply(Message it) {
                    return NodeGen.this._typeHelpers.isEnumerationOrPrimitive(it.getData().getRefType().getType());
                }
            };
            object3 = IterableExtensions.filter((Iterable)pi.getProtocol().getIncomingMessages(), (Functions.Function1)object);
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                Message msg = (Message)iterator.next();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("ET_DATA_LOGGER_LOG_STRING(\"");
                string2 = pi.getPath();
                stringConcatenation2.append(string2, "\t");
                stringConcatenation2.append("/");
                string = msg.getName();
                stringConcatenation2.append(string, "\t");
                stringConcatenation2.append("\")");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("static void logData() {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_DATA_LOGGER_NEW_ROW");
        stringConcatenation2.newLine();
        for (PortInstance pi_1 : loggedPorts) {
            object = new Functions.Function1<Message, Boolean>(){

                public Boolean apply(Message it) {
                    return NodeGen.this._typeHelpers.isEnumerationOrPrimitive(it.getData().getRefType().getType());
                }
            };
            object3 = IterableExtensions.filter((Iterable)pi_1.getProtocol().getIncomingMessages(), (Functions.Function1)object);
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                Message msg_1 = (Message)iterator.next();
                stringConcatenation2.append("\t");
                string2 = this.createLoggerCall(pi_1, msg_1);
                stringConcatenation2.append(string2, "\t");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence generateInstanceFile(Root root, SubSystemInstance ssi, final Collection<PhysicalThread> usedThreads) {
        String string;
        String string2;
        int n;
        CharSequence charSequence;
        StringConcatenation stringConcatenation = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Instance File of Node ");
        String string3 = nr.getName();
        stringConcatenation2.append(string3, " ");
        stringConcatenation2.append(" with SubSystem ");
        String string4 = ssi.getName();
        stringConcatenation2.append(string4, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* - instantiation of all actor instances and port instances");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* - configuration of data and connection of ports");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"messaging/etMessageService.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* include all referenced room classes */");
        stringConcatenation2.newLine();
        Object object = root.getReferencedActorClasses((RoomClass)ssi.getSubSystemClass());
        Object object2 = root.getReferencedProtocolClasses((RoomClass)ssi.getSubSystemClass());
        Functions.Function1<RoomClass, String> function1 = new Functions.Function1<RoomClass, String>(){

            public String apply(RoomClass it) {
                return NodeGen.this._cExtensions.getIncludePath(it);
            }
        };
        Object object3 = IterableExtensions.sort((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)object, (Iterable)object2), (Functions.Function1)function1));
        Object object4 = object3.iterator();
        while (object4.hasNext()) {
            String path = (String)object4.next();
            stringConcatenation2.append("#include ");
            stringConcatenation2.append(path);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* instantiation of message services and message buffers */");
        stringConcatenation2.newLine();
        object = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                return usedThreads.contains(t);
            }
        };
        object2 = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)object);
        object3 = object2.iterator();
        while (object3.hasNext()) {
            PhysicalThread thread = (PhysicalThread)object3.next();
            stringConcatenation2.append("/* ");
            charSequence = thread.getName();
            stringConcatenation2.append(charSequence);
            stringConcatenation2.append(" */");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("#define ");
            object4 = thread.getName().toUpperCase();
            stringConcatenation2.append((String)object4);
            stringConcatenation2.append("_POOL_SIZE\t\t");
            int n2 = thread.getMsgpoolsize();
            stringConcatenation2.append((Object)n2);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("#define ");
            String string5 = thread.getName().toUpperCase();
            stringConcatenation2.append(string5);
            stringConcatenation2.append("_BLOCK_SIZE\t");
            n = thread.getMsgblocksize();
            stringConcatenation2.append((Object)n);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("static uint8 msgBuffer_");
            string2 = thread.getName();
            stringConcatenation2.append(string2);
            stringConcatenation2.append("[");
            string = thread.getName().toUpperCase();
            stringConcatenation2.append(string);
            stringConcatenation2.append("_POOL_SIZE * ");
            String string6 = thread.getName().toUpperCase();
            stringConcatenation2.append(string6);
            stringConcatenation2.append("_BLOCK_SIZE];");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("static etMessageService msgService_");
            String string7 = thread.getName();
            stringConcatenation2.append(string7);
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* declarations of all ActorClass instances (const and variable structs) */");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* forward declaration of variable actor structs */");
        stringConcatenation2.newLine();
        object = ssi.getAllContainedInstances();
        for (ActorInstance ai : object) {
            stringConcatenation2.append("ET_FOWARD_DECLARATION_OF_INST_VAR ");
            object3 = ai.getActorClass().getName();
            stringConcatenation2.append((String)object3);
            stringConcatenation2.append(" ");
            charSequence = this._roomExtensions.getPathName(ai.getPath());
            stringConcatenation2.append(charSequence);
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* forward declaration of variable port structs */");
        stringConcatenation2.newLine();
        object = ssi.getAllContainedInstances();
        for (ActorInstance ai_1 : object) {
            boolean bl = ai_1.getOrderedIfItemInstances().isEmpty();
            if (bl) {
                stringConcatenation2.append("/* nothing to do */");
                stringConcatenation2.newLine();
                continue;
            }
            charSequence = ai_1.getOrderedIfItemInstances();
            Iterator iterator = charSequence.iterator();
            while (iterator.hasNext()) {
                int n3;
                InterfaceItemInstance pi = (InterfaceItemInstance)iterator.next();
                int n4 = this.getPortClassAttributesSize(pi);
                int n5 = n = n4 > 0 ? 1 : 0;
                if (n == 0) continue;
                stringConcatenation2.append("ET_FOWARD_DECLARATION_OF_INST_VAR ");
                string2 = this._roomExtensions.getPortClassName(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                stringConcatenation2.append(string2);
                stringConcatenation2.append("_var ");
                string = this._roomExtensions.getPathName(pi.getPath());
                stringConcatenation2.append(string);
                stringConcatenation2.append("_var");
                int n6 = pi.isReplicated();
                if (n6 != 0) {
                    stringConcatenation2.append("[");
                    n3 = pi.getPeers().size();
                    stringConcatenation2.append((Object)n3);
                    stringConcatenation2.append("]");
                }
                stringConcatenation2.append("={");
                stringConcatenation2.newLineIfNotEmpty();
                n6 = 0;
                n3 = pi.getPeers().size();
                boolean bl2 = n3 == 0;
                n6 = bl2 ? 1 : pi.getPeers().size();
                IntegerRange integerRange = new IntegerRange(1, n6);
                boolean bl3 = false;
                Iterator iterator2 = integerRange.iterator();
                while (iterator2.hasNext()) {
                    Integer cfr_ignored_0 = (Integer)iterator2.next();
                    if (!bl3) {
                        bl3 = true;
                    } else {
                        stringConcatenation2.appendImmediate((Object)", ", "\t");
                    }
                    stringConcatenation2.append("\t");
                    boolean bl4 = pi.isReplicated();
                    if (bl4) {
                        stringConcatenation2.append("{");
                    }
                    CharSequence charSequence2 = this.attrInitGenAddon.generateAttributeInit((InstanceBase)pi, (List<Attribute>)this._roomHelpers.getPortClass(pi.getInterfaceItem()).getAttributes());
                    stringConcatenation2.append((Object)charSequence2, "\t");
                    boolean bl5 = pi.isReplicated();
                    if (bl5) {
                        stringConcatenation2.append("}");
                    }
                    stringConcatenation2.newLineIfNotEmpty();
                }
                stringConcatenation2.append("};");
                stringConcatenation2.newLine();
            }
        }
        stringConcatenation2.newLine();
        object = ssi.getAllContainedInstances();
        for (ActorInstance ai_2 : object) {
            stringConcatenation2.newLine();
            stringConcatenation2.append("/* instance ");
            String string8 = this._roomExtensions.getPathName(ai_2.getPath());
            stringConcatenation2.append(string8);
            stringConcatenation2.append(" */");
            stringConcatenation2.newLineIfNotEmpty();
            charSequence = this.genActorInstanceInitializer(root, ai_2);
            stringConcatenation2.append((Object)charSequence);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* special user codes from annotation SubSystemUserCode */");
        stringConcatenation2.newLine();
        object = this.generateSubSystemUserCodes(ssi);
        stringConcatenation2.append((String)object);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private int getPortClassAttributesSize(InterfaceItemInstance pi) {
        int n = 0;
        PortClass portClass = this._roomExtensions.getPortClass(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
        EList eList = null;
        if (portClass != null) {
            eList = portClass.getAttributes();
        }
        EList attribs = eList;
        int n2 = 0;
        n2 = attribs == null ? 0 : attribs.size();
        n = n2;
        return n;
    }

    private CharSequence genActorInstanceInitializer(Root root, ActorInstance ai) {
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        Object object4;
        StringConcatenation stringConcatenation = null;
        String instName = this._roomExtensions.getPathName(ai.getPath());
        ArrayList replEventItems = new ArrayList();
        Functions.Function1<InterfaceItemInstance, Boolean> function1 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                return e.isReplicated();
            }
        };
        Iterables.addAll(replEventItems, (Iterable)IterableExtensions.filter((Iterable)ai.getOrderedIfItemInstances(), (Functions.Function1)function1));
        Functions.Function1<InterfaceItemInstance, Boolean> function12 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                boolean bl = e.getPeers().isEmpty();
                return !bl;
            }
        };
        InterfaceItemInstance interfaceItemInstance = (InterfaceItemInstance)IterableExtensions.findFirst(replEventItems, (Functions.Function1)function12);
        boolean haveReplSubItems = interfaceItemInstance != null;
        Functions.Function1<InterfaceItemInstance, Boolean> function13 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem interfaceItem = i.getInterfaceItem();
                return interfaceItem instanceof Port;
            }
        };
        Iterable replEventPorts = IterableExtensions.filter(replEventItems, (Functions.Function1)function13);
        Functions.Function1<InterfaceItemInstance, Boolean> function14 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem interfaceItem = i.getInterfaceItem();
                return interfaceItem instanceof SPP;
            }
        };
        Iterable replEventSPPs = IterableExtensions.filter(replEventItems, (Functions.Function1)function14);
        Functions.Function1<InterfaceItemInstance, Boolean> function15 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                return e.isSimple();
            }
        };
        Iterable simplePorts = IterableExtensions.filter((Iterable)ai.getOrderedIfItemInstances(), (Functions.Function1)function15);
        ArrayList simpleEventItems = new ArrayList();
        Functions.Function1<InterfaceItemInstance, Boolean> function16 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                CommunicationType communicationType = p.getProtocol().getCommType();
                return Objects.equal((Object)communicationType, (Object)CommunicationType.EVENT_DRIVEN);
            }
        };
        Iterables.addAll(simpleEventItems, (Iterable)IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)function16));
        Functions.Function1<InterfaceItemInstance, Boolean> function17 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem interfaceItem = i.getInterfaceItem();
                return interfaceItem instanceof Port;
            }
        };
        Iterable simpleEventPorts = IterableExtensions.filter(simpleEventItems, (Functions.Function1)function17);
        Functions.Function1<InterfaceItemInstance, Boolean> function18 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem interfaceItem = i.getInterfaceItem();
                return interfaceItem instanceof SAP;
            }
        };
        Iterable simpleEventSAPs = IterableExtensions.filter(simpleEventItems, (Functions.Function1)function18);
        Functions.Function1<InterfaceItemInstance, Boolean> function19 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                CommunicationType communicationType = p.getProtocol().getCommType();
                return Objects.equal((Object)communicationType, (Object)CommunicationType.DATA_DRIVEN);
            }
        };
        Iterable dataPorts = IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)function19);
        Functions.Function1<InterfaceItemInstance, Boolean> function110 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                return p instanceof PortInstance && !((PortInstance)p).getPort().isConjugated();
            }
        };
        Iterable recvPorts = IterableExtensions.filter((Iterable)dataPorts, (Functions.Function1)function110);
        Functions.Function1<InterfaceItemInstance, Boolean> function111 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                return p instanceof PortInstance && ((PortInstance)p).getPort().isConjugated();
            }
        };
        Iterable sendPorts = IterableExtensions.filter((Iterable)dataPorts, (Functions.Function1)function111);
        HashMap<InterfaceItemInstance, Integer> offsets = new HashMap<InterfaceItemInstance, Integer>();
        int offset = 0;
        for (InterfaceItemInstance p : replEventItems) {
            int n;
            offsets.put(p, offset);
            int n2 = p.getPeers().size();
            offset = n = offset + n2;
        }
        String string = null;
        string = haveReplSubItems ? String.valueOf(instName) + "_repl_sub_ports" : "NULL";
        String replSubPortsArray = string;
        boolean haveConstData = !simpleEventItems.isEmpty() || !IterableExtensions.isEmpty((Iterable)recvPorts) || !replEventItems.isEmpty();
        IntelligentSeparator sep = new IntelligentSeparator(",");
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        CharSequence charSequence = this.genPeerPortArrays(root, ai);
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        if (haveReplSubItems) {
            stringConcatenation2.append("ET_INITIALIZATION_OF_INST_VAR const etReplSubPort ");
            stringConcatenation2.append(replSubPortsArray);
            stringConcatenation2.append("[");
            stringConcatenation2.append((Object)offset);
            stringConcatenation2.append("] = {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* Replicated Sub Ports: {varData, msgService, peerAddress, localId, index} */");
            stringConcatenation2.newLine();
            object4 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

                public Boolean apply(InterfaceItemInstance e) {
                    boolean bl = e.getPeers().isEmpty();
                    return !bl;
                }
            };
            object3 = IterableExtensions.filter(replEventItems, (Functions.Function1)object4);
            bl = false;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                InterfaceItemInstance pi = (InterfaceItemInstance)object2.next();
                if (!bl) {
                    bl = true;
                } else {
                    stringConcatenation2.appendImmediate((Object)",", "\t");
                }
                stringConcatenation2.append("\t");
                object = this.genReplSubPortInitializers(root, ai, pi);
                stringConcatenation2.append((String)object, "\t");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("};");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("ET_INITIALIZATION_OF_INST_VAR const ");
        object4 = ai.getActorClass().getName();
        stringConcatenation2.append((String)object4);
        stringConcatenation2.append("_const ");
        stringConcatenation2.append(instName);
        stringConcatenation2.append("_const = {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("#ifdef ET_MSC_LOGGER_ACTIVATE");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("\"");
        object3 = ai.getPath();
        stringConcatenation2.append((String)object3, "\t\t");
        stringConcatenation2.append("\"");
        if (ai.getXpActorClass().isTracingEnabled() || haveConstData) {
            stringConcatenation2.append(",");
        }
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("#endif");
        stringConcatenation2.newLine();
        bl = ai.getXpActorClass().isTracingEnabled();
        if (bl) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#if defined ET_MSC_TRACER_ACTIVATE || defined ET_MSC_LOGGER_ACTIVATE");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            int pi = ai.getObjId();
            stringConcatenation2.append((Object)pi, "\t\t");
            if (haveConstData) {
                stringConcatenation2.append(",");
            }
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#endif");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* Ports: {varData, msgService, peerAddress, localId} */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* simple ports */");
        stringConcatenation2.newLine();
        for (InterfaceItemInstance pi_1 : simpleEventPorts) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append((Object)sep, "\t");
            object2 = this.genPortInitializer(root, ai, pi_1);
            stringConcatenation2.append((String)object2, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* data receive ports */");
        stringConcatenation2.newLine();
        for (InterfaceItemInstance pi_2 : recvPorts) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append((Object)sep, "\t");
            object2 = this.genRecvPortInitializer(root, ai, pi_2);
            stringConcatenation2.append((String)object2, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* saps */");
        stringConcatenation2.newLine();
        for (InterfaceItemInstance pi_3 : simpleEventSAPs) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append((Object)sep, "\t");
            object2 = this.genPortInitializer(root, ai, pi_3);
            stringConcatenation2.append((String)object2, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* replicated ports */");
        stringConcatenation2.newLine();
        for (InterfaceItemInstance pi_4 : replEventPorts) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append((Object)sep, "\t");
            stringConcatenation2.append("{");
            int n = pi_4.getPeers().size();
            stringConcatenation2.append((Object)n, "\t");
            stringConcatenation2.append(", ");
            stringConcatenation2.append(replSubPortsArray, "\t");
            stringConcatenation2.append("+");
            object = (Integer)offsets.get(pi_4);
            stringConcatenation2.append(object, "\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* services */");
        stringConcatenation2.newLine();
        for (InterfaceItemInstance pi_5 : replEventSPPs) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append((Object)sep, "\t");
            stringConcatenation2.append("{");
            int n = pi_5.getPeers().size();
            stringConcatenation2.append((Object)n, "\t");
            stringConcatenation2.append(", ");
            stringConcatenation2.append(replSubPortsArray, "\t");
            stringConcatenation2.append("+");
            object = (Integer)offsets.get(pi_5);
            stringConcatenation2.append(object, "\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation2.append("ET_INITIALIZATION_OF_INST_VAR ");
        String string2 = ai.getActorClass().getName();
        stringConcatenation2.append(string2);
        stringConcatenation2.append(" ");
        stringConcatenation2.append(instName);
        stringConcatenation2.append(" = {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("&");
        stringConcatenation2.append(instName, "\t");
        stringConcatenation2.append("_const,");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* data send ports */");
        stringConcatenation2.newLine();
        for (InterfaceItemInstance pi_6 : sendPorts) {
            stringConcatenation2.append("\t");
            object = this.genSendPortInitializer(pi_6);
            stringConcatenation2.append(object, "\t");
            stringConcatenation2.append(",");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* attributes */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        CharSequence charSequence2 = this.attrInitGenAddon.generateAttributeInit((InstanceBase)ai, this._roomHelpers.getAllAttributes(ai.getActorClass()));
        stringConcatenation2.append((Object)charSequence2, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* state and history are initialized in init function */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence genPeerPortArrays(Root root, ActorInstance ai) {
        boolean bl;
        StringConcatenation stringConcatenation = null;
        Functions.Function1<InterfaceItemInstance, Boolean> function1 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                return e.isSimple() && e instanceof PortInstance;
            }
        };
        Functions.Function1<InterfaceItemInstance, PortInstance> function12 = new Functions.Function1<InterfaceItemInstance, PortInstance>(){

            public PortInstance apply(InterfaceItemInstance inst) {
                return (PortInstance)inst;
            }
        };
        Iterable simplePorts = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ai.getOrderedIfItemInstances(), (Functions.Function1)function1), (Functions.Function1)function12);
        Functions.Function1<PortInstance, Boolean> function13 = new Functions.Function1<PortInstance, Boolean>(){

            public Boolean apply(PortInstance p) {
                return p.getPort().isConjugated() && Objects.equal((Object)p.getProtocol().getCommType(), (Object)CommunicationType.DATA_DRIVEN);
            }
        };
        Iterable sendPorts = IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)function13);
        Functions.Function1<PortInstance, Boolean> function14 = new Functions.Function1<PortInstance, Boolean>(){

            public Boolean apply(PortInstance p) {
                Functions.Function1<Message, Boolean> function1 = new Functions.Function1<Message, Boolean>(){

                    public Boolean apply(Message m) {
                        return (this).NodeGen.this._typeHelpers.isEnumeration(m.getData().getRefType().getType()) || (this).NodeGen.this._typeHelpers.isBoolean(m.getData().getRefType().getType());
                    }
                };
                boolean bl = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)NodeGen.this._roomHelpers.getOutgoing((InterfaceItem)p.getPort()), (Functions.Function1)function1));
                return !bl;
            }
        };
        Iterable loggedPorts = IterableExtensions.filter((Iterable)sendPorts, (Functions.Function1)function14);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        boolean bl2 = IterableExtensions.isEmpty((Iterable)loggedPorts);
        boolean bl3 = bl = !bl2;
        if (bl) {
            stringConcatenation2.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
            stringConcatenation2.newLine();
            for (PortInstance pi : loggedPorts) {
                stringConcatenation2.append("static const char* ");
                String string = this._roomExtensions.getPathName(pi.getPath());
                stringConcatenation2.append(string);
                stringConcatenation2.append("_peers[");
                int n = pi.getPeers().size();
                int n2 = n + 1;
                stringConcatenation2.append((Object)n2);
                stringConcatenation2.append("] = {");
                stringConcatenation2.newLineIfNotEmpty();
                EList eList = pi.getPeers();
                for (InterfaceItemInstance peer : eList) {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\"");
                    EObject eObject = peer.eContainer();
                    String string2 = ((ActorInstance)eObject).getPath();
                    stringConcatenation2.append(string2, "\t");
                    stringConcatenation2.append("\",");
                    stringConcatenation2.newLineIfNotEmpty();
                }
                stringConcatenation2.append("\t");
                stringConcatenation2.append("NULL");
                stringConcatenation2.newLine();
                stringConcatenation2.append("};");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("#endif");
            stringConcatenation2.newLine();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String genPortInitializer(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        boolean bl;
        Object object;
        String string = null;
        int n = 0;
        boolean bl2 = pi.getPeers().isEmpty();
        n = bl2 ? 0 : ((InterfaceItemInstance)pi.getPeers().get(0)).getObjId();
        int objId = n;
        int n2 = 0;
        boolean bl3 = pi.getPeers().isEmpty();
        n2 = bl3 ? 0 : ((InterfaceItemInstance)pi.getPeers().get(0)).getPeers().indexOf((Object)pi);
        int idx = n2;
        String string2 = null;
        boolean bl4 = pi.getPeers().isEmpty();
        if (bl4) {
            string2 = "NULL";
        } else {
            EObject eObject = ((InterfaceItemInstance)pi.getPeers().get(0)).eContainer();
            object = ETMapUtil.getMappedThread((AbstractInstance)((ActorInstance)eObject)).getThread().getName();
            string2 = "&msgService_" + (String)object;
        }
        String msgSvc = string2;
        object = pi.eContainer();
        String myInst = ((ActorInstance)object).getPath();
        String string3 = null;
        boolean bl5 = pi.getPeers().isEmpty();
        boolean bl6 = bl = !bl5;
        if (bl) {
            EObject eObject = ((InterfaceItemInstance)pi.getPeers().get(0)).eContainer();
            string3 = ((ActorInstance)eObject).getPath();
        }
        String peerInst = string3;
        int n3 = root.getExpandedActorClass(ai).getInterfaceItemLocalId((AbstractInterfaceItem)pi.getInterfaceItem());
        int localId = n3 + 1;
        String varData = this.getInterfaceItemInstanceData(pi);
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("{");
        stringConcatenation.append(varData);
        stringConcatenation.append(", ");
        stringConcatenation.append(msgSvc);
        stringConcatenation.append(", ");
        stringConcatenation.append((Object)(objId + idx));
        stringConcatenation.append("+BASE_ADDRESS, ");
        stringConcatenation.append((Object)localId);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
        stringConcatenation.newLine();
        stringConcatenation.append(", \"");
        stringConcatenation.append(myInst);
        stringConcatenation.append("\", \"");
        stringConcatenation.append(peerInst);
        stringConcatenation.append("\"");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("#endif");
        stringConcatenation.newLine();
        stringConcatenation.append("} /* Port ");
        String string4 = pi.getName();
        stringConcatenation.append(string4);
        stringConcatenation.append(" */");
        stringConcatenation.newLineIfNotEmpty();
        string = stringConcatenation.toString();
        return string;
    }

    private CharSequence genSendPortInitializer(InterfaceItemInstance pi) {
        StringConcatenation stringConcatenation = null;
        ProtocolClass pc = ((PortInstance)pi).getPort().getProtocol();
        Functions.Function1<Message, Boolean> function1 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                MessageData messageData = m.getData();
                return messageData != null;
            }
        };
        Iterable messages = IterableExtensions.filter((Iterable)this._roomHelpers.getAllIncomingMessages(pc), (Functions.Function1)function1);
        Functions.Function1<Message, Boolean> function12 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                return NodeGen.this._typeHelpers.isEnumeration(m.getData().getRefType().getType());
            }
        };
        Iterable enumMsgs = IterableExtensions.filter((Iterable)messages, (Functions.Function1)function12);
        Functions.Function1<Message, Boolean> function13 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                return NodeGen.this._typeHelpers.isBoolean(m.getData().getRefType().getType());
            }
        };
        Iterable boolMsgs = IterableExtensions.filter((Iterable)messages, (Functions.Function1)function13);
        boolean usesMSC = !IterableExtensions.isEmpty((Iterable)enumMsgs) || !IterableExtensions.isEmpty((Iterable)boolMsgs);
        EObject eObject = pi.eContainer();
        String instName = ((ActorInstance)eObject).getPath();
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        Object object = pc.getIncomingMessages();
        boolean bl = false;
        for (Message m : object) {
            if (!bl) {
                bl = true;
            } else {
                stringConcatenation2.appendImmediate((Object)",", "\t");
            }
            stringConcatenation2.append("\t");
            String string = this._cExtensions.defaultValue(m.getData().getRefType().getType());
            stringConcatenation2.append(string, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        if (usesMSC) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append(", \"");
            stringConcatenation2.append(instName, "\t\t");
            stringConcatenation2.append("\",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            object = this._roomExtensions.getPathName(pi.getPath());
            stringConcatenation2.append((String)object, "\t\t");
            stringConcatenation2.append("_peers");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#endif");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("} /* send port ");
        object = pi.getName();
        stringConcatenation2.append((String)object);
        stringConcatenation2.append(" */");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String getInterfaceItemInstanceData(InterfaceItemInstance pi) {
        boolean bl;
        PortClass portClass = this._roomExtensions.getPortClass(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
        boolean bl2 = bl = portClass == null;
        if (bl) {
            return "NULL";
        }
        boolean bl3 = this._roomExtensions.getPortClass(pi.getProtocol(), this._roomExtensions.isConjugated(pi)).getAttributes().isEmpty();
        if (bl3) {
            return "NULL";
        }
        String string = this._roomExtensions.getPathName(pi.getPath());
        String string2 = "&" + string;
        return String.valueOf(string2) + "_var";
    }

    private String genRecvPortInitializer(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        boolean bl;
        String string;
        String string2;
        Object object;
        String string3 = null;
        Functions.Function1<Message, Boolean> function1 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                MessageData messageData = m.getData();
                return messageData != null;
            }
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)this._roomHelpers.getIncoming(pi.getInterfaceItem()), (Functions.Function1)function1);
        Functions.Function1<Message, Boolean> function12 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                return NodeGen.this._typeHelpers.isEnumeration(m.getData().getRefType().getType());
            }
        };
        Iterable enumMsgs = IterableExtensions.filter((Iterable)sentMsgs, (Functions.Function1)function12);
        Functions.Function1<Message, Boolean> function13 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                return NodeGen.this._typeHelpers.isBoolean(m.getData().getRefType().getType());
            }
        };
        Iterable boolMsgs = IterableExtensions.filter((Iterable)sentMsgs, (Functions.Function1)function13);
        boolean usesMSC = !IterableExtensions.isEmpty((Iterable)enumMsgs) || !IterableExtensions.isEmpty((Iterable)boolMsgs);
        String enumVal = "";
        if (usesMSC) {
            String string4 = ai.getPath();
            String string5 = "\n, \"" + string4;
            object = String.valueOf(string5) + "\"";
            enumVal = object;
            for (Message msg : enumMsgs) {
                string2 = this._cExtensions.defaultValue(msg.getData().getRefType().getType());
                enumVal = string = String.valueOf(enumVal) + "\n, " + string2;
            }
            for (Message msg_1 : boolMsgs) {
                string2 = this._cExtensions.defaultValue(msg_1.getData().getRefType().getType());
                enumVal = string = String.valueOf(enumVal) + "\n, " + string2;
            }
            enumVal = "\n#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE" + enumVal + "\n#endif\n";
        }
        if (bl = pi.getPeers().isEmpty()) {
            return "{NULL" + enumVal + "}";
        }
        InterfaceItemInstance peer = (InterfaceItemInstance)pi.getPeers().get(0);
        object = ((InterfaceItemInstance)pi.getPeers().get(0)).eContainer();
        ActorInstance peerInst = (ActorInstance)object;
        String instName = this._roomExtensions.getPathName(peerInst.getPath());
        string2 = peer.getName();
        string = "{&" + instName + "." + string2;
        String string6 = String.valueOf(string) + enumVal;
        string3 = String.valueOf(string6) + "}";
        return string3;
    }

    private String genReplSubPortInitializers(final Root root, final ActorInstance ai, final InterfaceItemInstance pi) {
        Functions.Function1<InterfaceItemInstance, String> function1 = new Functions.Function1<InterfaceItemInstance, String>(){

            public String apply(InterfaceItemInstance p) {
                String string = null;
                int idx = pi.getPeers().indexOf((Object)p);
                EObject eObject = p.eContainer();
                String thread = ETMapUtil.getMappedThread((AbstractInstance)((ActorInstance)eObject)).getThread().getName();
                String iiidD = NodeGen.this.getInterfaceItemInstanceData(pi);
                String string2 = null;
                boolean bl = Objects.equal((Object)iiidD, (Object)"NULL");
                if (bl) {
                    string2 = iiidD;
                } else {
                    StringConcatenation stringConcatenation = new StringConcatenation();
                    stringConcatenation.append(iiidD);
                    stringConcatenation.append("[");
                    stringConcatenation.append((Object)idx);
                    stringConcatenation.append("]");
                    string2 = stringConcatenation.toString();
                }
                String varData = string2;
                int n = root.getExpandedActorClass(ai).getInterfaceItemLocalId((AbstractInterfaceItem)pi.getInterfaceItem());
                int localId = n + 1;
                EObject eObject2 = pi.eContainer();
                String myInst = ((ActorInstance)eObject2).getPath();
                EObject eObject3 = p.eContainer();
                String peerInst = ((ActorInstance)eObject3).getPath();
                StringConcatenation stringConcatenation = new StringConcatenation();
                stringConcatenation.append("{{");
                stringConcatenation.append(varData);
                stringConcatenation.append(", &msgService_");
                stringConcatenation.append(thread);
                stringConcatenation.append(", ");
                int n2 = p.getObjId();
                stringConcatenation.append((Object)n2);
                stringConcatenation.append("+BASE_ADDRESS, ");
                stringConcatenation.append((Object)localId);
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
                stringConcatenation.newLine();
                stringConcatenation.append(", \"");
                stringConcatenation.append(myInst);
                stringConcatenation.append("\", \"");
                stringConcatenation.append(peerInst);
                stringConcatenation.append("\"");
                stringConcatenation.newLineIfNotEmpty();
                stringConcatenation.append("#endif");
                stringConcatenation.newLine();
                stringConcatenation.append("}, ");
                stringConcatenation.append((Object)idx);
                stringConcatenation.append(" } /* Repl Sub Port ");
                String string3 = pi.getName();
                stringConcatenation.append(string3);
                stringConcatenation.append(" idx ");
                stringConcatenation.append((Object)idx);
                stringConcatenation.append(" */");
                stringConcatenation.newLineIfNotEmpty();
                string = stringConcatenation.toString();
                return string;
            }
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)pi.getPeers(), (Functions.Function1)function1), (CharSequence)",");
    }

    private CharSequence generateDispatcherFile(Root root, SubSystemInstance ssi, final Collection<PhysicalThread> usedThreads) {
        StringConcatenation stringConcatenation = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Dispatcher File of Node ");
        String string = nr.getName();
        stringConcatenation2.append(string, " ");
        stringConcatenation2.append(" with SubSystem ");
        String string2 = ssi.getName();
        stringConcatenation2.append(string2, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* contains a generated message dispatcher (receiveMessage) for each MessageService (Thread)");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"messaging/etMessageReceiver.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etMSCLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        Functions.Function1<PhysicalThread, Boolean> function1 = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                return usedThreads.contains(t);
            }
        };
        Iterable iterable = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)function1);
        boolean bl = false;
        for (final PhysicalThread thread : iterable) {
            String string3;
            boolean bl2;
            Object object;
            Object object2;
            String string4;
            String string5;
            boolean bl3;
            if (!bl) {
                bl = true;
            } else {
                stringConcatenation2.appendImmediate((Object)"\n", "");
            }
            Functions.Function1<ActorInstance, Boolean> function12 = new Functions.Function1<ActorInstance, Boolean>(){

                public Boolean apply(ActorInstance ai) {
                    PhysicalThread physicalThread = ETMapUtil.getMappedThread((AbstractInstance)ai).getThread();
                    return Objects.equal((Object)physicalThread, (Object)thread);
                }
            };
            Iterable instancesOnThread = IterableExtensions.filter((Iterable)ssi.getAllContainedInstances(), (Functions.Function1)function12);
            stringConcatenation2.newLineIfNotEmpty();
            Functions.Function1<ActorInstance, Boolean> function13 = new Functions.Function1<ActorInstance, Boolean>(){

                public Boolean apply(ActorInstance ai) {
                    return Objects.equal((Object)ai.getActorClass().getCommType(), (Object)ComponentCommunicationType.EVENT_DRIVEN) || Objects.equal((Object)ai.getActorClass().getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS);
                }
            };
            Iterable dispatchedInstances = IterableExtensions.filter((Iterable)instancesOnThread, (Functions.Function1)function13);
            stringConcatenation2.newLineIfNotEmpty();
            Functions.Function1<ActorInstance, Boolean> function14 = new Functions.Function1<ActorInstance, Boolean>(){

                public Boolean apply(ActorInstance ai) {
                    return Objects.equal((Object)ai.getActorClass().getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN) || Objects.equal((Object)ai.getActorClass().getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS);
                }
            };
            Iterable executedInstances = IterableExtensions.filter((Iterable)instancesOnThread, (Functions.Function1)function14);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.newLine();
            int n = IterableExtensions.size((Iterable)executedInstances);
            boolean bl4 = bl3 = n > 0;
            if (bl3) {
                stringConcatenation2.append("/**");
                stringConcatenation2.newLine();
                stringConcatenation2.append(" ");
                stringConcatenation2.append("* generated execute function for all cyclic execute calls for the async or datadriven actor instances of thread \"");
                string5 = thread.getName();
                stringConcatenation2.append(string5, " ");
                stringConcatenation2.append("\"");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append(" ");
                stringConcatenation2.append("*/");
                stringConcatenation2.newLine();
                stringConcatenation2.append("static void MsgDispatcher_");
                string4 = thread.getName();
                stringConcatenation2.append(string4);
                stringConcatenation2.append("_poll(void){");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"MsgDispatcher_");
                String string6 = thread.getName();
                stringConcatenation2.append(string6, "\t");
                stringConcatenation2.append("\", \"execute\")");
                stringConcatenation2.newLineIfNotEmpty();
                for (ActorInstance ai : executedInstances) {
                    stringConcatenation2.append("\t");
                    object2 = ai.getActorClass().getName();
                    stringConcatenation2.append((String)object2, "\t");
                    stringConcatenation2.append("_execute((");
                    String string7 = ai.getActorClass().getName();
                    stringConcatenation2.append(string7, "\t");
                    stringConcatenation2.append("*)&");
                    object = this._roomExtensions.getPathName(ai.getPath());
                    stringConcatenation2.append((String)object, "\t");
                    stringConcatenation2.append(");");
                    stringConcatenation2.newLineIfNotEmpty();
                }
                stringConcatenation2.append("\t");
                stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
                stringConcatenation2.newLine();
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("/**");
            stringConcatenation2.newLine();
            stringConcatenation2.append(" ");
            stringConcatenation2.append("* generated dispatch function for all messages for the thread \"");
            String string8 = thread.getName();
            stringConcatenation2.append(string8, " ");
            stringConcatenation2.append("\"");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append(" ");
            stringConcatenation2.append("*/");
            stringConcatenation2.newLine();
            stringConcatenation2.append("static etBool MsgDispatcher_");
            String string9 = thread.getName();
            stringConcatenation2.append(string9);
            stringConcatenation2.append("_receiveMessage(const etMessage* msg){");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"MsgDispatcher_");
            string5 = thread.getName();
            stringConcatenation2.append(string5, "\t");
            stringConcatenation2.append("\", \"receiveMessage\")");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("switch(msg->address){");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("case MESSAGESERVICE_ADDRESS:");
            stringConcatenation2.newLine();
            boolean bl5 = IterableExtensions.isEmpty((Iterable)executedInstances);
            boolean bl6 = bl2 = !bl5;
            if (bl2) {
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("if (msg->evtID == etSystemProtocol_IN_poll) {");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("MsgDispatcher_");
                string3 = thread.getName();
                stringConcatenation2.append(string3, "\t\t\t\t");
                stringConcatenation2.append("_poll();");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("logData();");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("else");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t\t\t");
            stringConcatenation2.append("if (msg->evtID == etSystemProtocol_IN_terminate)");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t\t\t");
            stringConcatenation2.append("return ET_FALSE;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t\t");
            stringConcatenation2.append("break;");
            stringConcatenation2.newLine();
            for (ActorInstance ai_1 : dispatchedInstances) {
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("/* interface items of ");
                string3 = ai_1.getPath();
                stringConcatenation2.append(string3, "\t\t");
                stringConcatenation2.append(" */");
                stringConcatenation2.newLineIfNotEmpty();
                Functions.Function1<InterfaceItemInstance, Boolean> function15 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

                    public Boolean apply(InterfaceItemInstance p) {
                        CommunicationType communicationType = p.getProtocol().getCommType();
                        return Objects.equal((Object)communicationType, (Object)CommunicationType.EVENT_DRIVEN);
                    }
                };
                object2 = IterableExtensions.filter((Iterable)ai_1.getOrderedIfItemInstances(), (Functions.Function1)function15);
                object = object2.iterator();
                while (object.hasNext()) {
                    String string10;
                    String string11;
                    Object object3;
                    Object object4;
                    String string12;
                    String string13;
                    String string14;
                    Object object5;
                    InterfaceItemInstance pi = (InterfaceItemInstance)object.next();
                    boolean bl7 = pi.isReplicated();
                    if (bl7) {
                        EList eList = pi.getPeers();
                        for (InterfaceItemInstance peer : eList) {
                            String string15;
                            String string16;
                            String string17;
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("case ");
                            int n2 = pi.getObjId();
                            int n3 = pi.getPeers().indexOf((Object)peer);
                            int n4 = n2 + n3;
                            stringConcatenation2.append((Object)n4, "\t\t");
                            stringConcatenation2.append("+BASE_ADDRESS:");
                            stringConcatenation2.newLineIfNotEmpty();
                            boolean bl8 = this._roomExtensions.handlesReceive(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                            if (bl8) {
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("switch (msg->evtID){");
                                stringConcatenation2.newLine();
                                object5 = this._roomExtensions.getReceiveHandlers(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                                Object object6 = object5.iterator();
                                while (object6.hasNext()) {
                                    MessageHandler h = (MessageHandler)object6.next();
                                    stringConcatenation2.append("\t\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("case ");
                                    string14 = pi.getProtocol().getName();
                                    stringConcatenation2.append(string14, "\t\t\t\t");
                                    stringConcatenation2.append("_");
                                    String string18 = this._roomExtensions.getCodeName(h.getMsg());
                                    stringConcatenation2.append(string18, "\t\t\t\t");
                                    stringConcatenation2.append(":");
                                    stringConcatenation2.newLineIfNotEmpty();
                                    stringConcatenation2.append("\t\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("\t");
                                    string13 = this._roomExtensions.getPortClassName(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                                    stringConcatenation2.append(string13, "\t\t\t\t\t");
                                    stringConcatenation2.append("_");
                                    String string19 = h.getMsg().getName();
                                    stringConcatenation2.append(string19, "\t\t\t\t\t");
                                    stringConcatenation2.append("_receiveHandler((etPort *)&");
                                    string17 = this._roomExtensions.getPathName(ai_1.getPath());
                                    stringConcatenation2.append(string17, "\t\t\t\t\t");
                                    stringConcatenation2.append("_const.");
                                    string16 = pi.getName();
                                    stringConcatenation2.append(string16, "\t\t\t\t\t");
                                    stringConcatenation2.append(".ports[");
                                    int n5 = pi.getPeers().indexOf((Object)peer);
                                    stringConcatenation2.append((Object)n5, "\t\t\t\t\t");
                                    stringConcatenation2.append("],msg,(void*)&");
                                    string15 = this._roomExtensions.getPathName(ai_1.getPath());
                                    stringConcatenation2.append(string15, "\t\t\t\t\t");
                                    stringConcatenation2.append(",");
                                    String string20 = ai_1.getActorClass().getName();
                                    stringConcatenation2.append(string20, "\t\t\t\t\t");
                                    stringConcatenation2.append("_receiveMessage);");
                                    stringConcatenation2.newLineIfNotEmpty();
                                    stringConcatenation2.append("\t\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("\t");
                                    stringConcatenation2.append("break;");
                                    stringConcatenation2.newLine();
                                }
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("default: ");
                                object5 = ai_1.getActorClass().getName();
                                stringConcatenation2.append((String)object5, "\t\t\t\t");
                                stringConcatenation2.append("_receiveMessage((void*)&");
                                string12 = this._roomExtensions.getPathName(ai_1.getPath());
                                stringConcatenation2.append(string12, "\t\t\t\t");
                                stringConcatenation2.append(",(etPort*)&");
                                object6 = this._roomExtensions.getPathName(ai_1.getPath());
                                stringConcatenation2.append((String)object6, "\t\t\t\t");
                                stringConcatenation2.append("_const.");
                                string14 = pi.getName();
                                stringConcatenation2.append(string14, "\t\t\t\t");
                                stringConcatenation2.append(".ports[");
                                int n6 = pi.getPeers().indexOf((Object)peer);
                                stringConcatenation2.append((Object)n6, "\t\t\t\t");
                                stringConcatenation2.append("], msg);");
                                stringConcatenation2.newLineIfNotEmpty();
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("break;");
                                stringConcatenation2.newLine();
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("}");
                                stringConcatenation2.newLine();
                            } else {
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("ET_MSC_LOGGER_ASYNC_IN(");
                                stringConcatenation2.newLine();
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("\t");
                                object5 = this._roomExtensions.getPathName(ai_1.getPath());
                                stringConcatenation2.append((String)object5, "\t\t\t\t");
                                stringConcatenation2.append("_const.");
                                string12 = pi.getName();
                                stringConcatenation2.append(string12, "\t\t\t\t");
                                stringConcatenation2.append(".ports[");
                                int n7 = pi.getPeers().indexOf((Object)peer);
                                stringConcatenation2.append((Object)n7, "\t\t\t\t");
                                stringConcatenation2.append("].port.peerInstName,");
                                stringConcatenation2.newLineIfNotEmpty();
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("\t");
                                string14 = pi.getProtocol().getName();
                                stringConcatenation2.append(string14, "\t\t\t\t");
                                stringConcatenation2.append("_getMessageString(msg->evtID),");
                                stringConcatenation2.newLineIfNotEmpty();
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("\t");
                                String string21 = this._roomExtensions.getPathName(ai_1.getPath());
                                stringConcatenation2.append(string21, "\t\t\t\t");
                                stringConcatenation2.append("_const.");
                                string13 = pi.getName();
                                stringConcatenation2.append(string13, "\t\t\t\t");
                                stringConcatenation2.append(".ports[");
                                int n8 = pi.getPeers().indexOf((Object)peer);
                                stringConcatenation2.append((Object)n8, "\t\t\t\t");
                                stringConcatenation2.append("].port.myInstName");
                                stringConcatenation2.newLineIfNotEmpty();
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append("\t");
                                stringConcatenation2.append(")");
                                stringConcatenation2.newLine();
                                stringConcatenation2.append("\t\t");
                                stringConcatenation2.append("\t");
                                string17 = ai_1.getActorClass().getName();
                                stringConcatenation2.append(string17, "\t\t\t");
                                stringConcatenation2.append("_receiveMessage((void*)&");
                                string16 = this._roomExtensions.getPathName(ai_1.getPath());
                                stringConcatenation2.append(string16, "\t\t\t");
                                stringConcatenation2.append(",&");
                                String string22 = this._roomExtensions.getPathName(ai_1.getPath());
                                stringConcatenation2.append(string22, "\t\t\t");
                                stringConcatenation2.append("_const.");
                                string15 = pi.getName();
                                stringConcatenation2.append(string15, "\t\t\t");
                                stringConcatenation2.append(".ports[");
                                int n9 = pi.getPeers().indexOf((Object)peer);
                                stringConcatenation2.append((Object)n9, "\t\t\t");
                                stringConcatenation2.append("].port, msg);");
                                stringConcatenation2.newLineIfNotEmpty();
                            }
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("break;");
                            stringConcatenation2.newLine();
                        }
                        continue;
                    }
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("case ");
                    int n10 = pi.getObjId();
                    stringConcatenation2.append((Object)n10, "\t\t");
                    stringConcatenation2.append("+BASE_ADDRESS:");
                    stringConcatenation2.newLineIfNotEmpty();
                    boolean bl9 = this._roomExtensions.handlesReceive(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                    if (bl9) {
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("switch (msg->evtID){");
                        stringConcatenation2.newLine();
                        object4 = this._roomExtensions.getReceiveHandlers(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            MessageHandler h_1 = (MessageHandler)object3.next();
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("case ");
                            String string23 = pi.getProtocol().getName();
                            stringConcatenation2.append(string23, "\t\t\t\t");
                            stringConcatenation2.append("_");
                            String string24 = this._roomExtensions.getCodeName(h_1.getMsg());
                            stringConcatenation2.append(string24, "\t\t\t\t");
                            stringConcatenation2.append(":");
                            stringConcatenation2.newLineIfNotEmpty();
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            object5 = this._roomExtensions.getPortClassName(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                            stringConcatenation2.append((String)object5, "\t\t\t\t\t");
                            stringConcatenation2.append("_");
                            string12 = h_1.getMsg().getName();
                            stringConcatenation2.append(string12, "\t\t\t\t\t");
                            stringConcatenation2.append("_receiveHandler((etPort *)&");
                            String string25 = this._roomExtensions.getPathName(ai_1.getPath());
                            stringConcatenation2.append(string25, "\t\t\t\t\t");
                            stringConcatenation2.append("_const.");
                            string14 = pi.getName();
                            stringConcatenation2.append(string14, "\t\t\t\t\t");
                            stringConcatenation2.append(",msg,(void*)&");
                            String string26 = this._roomExtensions.getPathName(ai_1.getPath());
                            stringConcatenation2.append(string26, "\t\t\t\t\t");
                            stringConcatenation2.append(",");
                            string13 = ai_1.getActorClass().getName();
                            stringConcatenation2.append(string13, "\t\t\t\t\t");
                            stringConcatenation2.append("_receiveMessage);");
                            stringConcatenation2.newLineIfNotEmpty();
                            stringConcatenation2.append("\t\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("break;");
                            stringConcatenation2.newLine();
                        }
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("default: ");
                        object4 = ai_1.getActorClass().getName();
                        stringConcatenation2.append((String)object4, "\t\t\t\t");
                        stringConcatenation2.append("_receiveMessage((void*)&");
                        string11 = this._roomExtensions.getPathName(ai_1.getPath());
                        stringConcatenation2.append(string11, "\t\t\t\t");
                        stringConcatenation2.append(",(etPort*)&");
                        object3 = this._roomExtensions.getPathName(ai_1.getPath());
                        stringConcatenation2.append((String)object3, "\t\t\t\t");
                        stringConcatenation2.append("_const.");
                        string10 = pi.getName();
                        stringConcatenation2.append(string10, "\t\t\t\t");
                        stringConcatenation2.append(", msg);");
                        stringConcatenation2.newLineIfNotEmpty();
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("break;");
                        stringConcatenation2.newLine();
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("}");
                        stringConcatenation2.newLine();
                    } else {
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("ET_MSC_LOGGER_ASYNC_IN(");
                        stringConcatenation2.newLine();
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("((etPort*)&");
                        object4 = this._roomExtensions.getPathName(ai_1.getPath());
                        stringConcatenation2.append((String)object4, "\t\t\t\t");
                        stringConcatenation2.append("_const.");
                        string11 = pi.getName();
                        stringConcatenation2.append(string11, "\t\t\t\t");
                        stringConcatenation2.append(")->peerInstName,");
                        stringConcatenation2.newLineIfNotEmpty();
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        object3 = pi.getProtocol().getName();
                        stringConcatenation2.append((String)object3, "\t\t\t\t");
                        stringConcatenation2.append("_getMessageString(msg->evtID),");
                        stringConcatenation2.newLineIfNotEmpty();
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("((etPort*)&");
                        string10 = this._roomExtensions.getPathName(ai_1.getPath());
                        stringConcatenation2.append(string10, "\t\t\t\t");
                        stringConcatenation2.append("_const.");
                        String string27 = pi.getName();
                        stringConcatenation2.append(string27, "\t\t\t\t");
                        stringConcatenation2.append(")->myInstName");
                        stringConcatenation2.newLineIfNotEmpty();
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append(")");
                        stringConcatenation2.newLine();
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        object5 = ai_1.getActorClass().getName();
                        stringConcatenation2.append((String)object5, "\t\t\t");
                        stringConcatenation2.append("_receiveMessage((void*)&");
                        string12 = this._roomExtensions.getPathName(ai_1.getPath());
                        stringConcatenation2.append(string12, "\t\t\t");
                        stringConcatenation2.append(",(etPort*)&");
                        String string28 = this._roomExtensions.getPathName(ai_1.getPath());
                        stringConcatenation2.append(string28, "\t\t\t");
                        stringConcatenation2.append("_const.");
                        string14 = pi.getName();
                        stringConcatenation2.append(string14, "\t\t\t");
                        stringConcatenation2.append(", msg);");
                        stringConcatenation2.newLineIfNotEmpty();
                    }
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("break;");
                    stringConcatenation2.newLine();
                }
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("default:");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t\t");
            stringConcatenation2.append("etLogger_logErrorF(\"MessageService_");
            string4 = thread.getName();
            stringConcatenation2.append(string4, "\t\t\t");
            stringConcatenation2.append("_receiveMessage: address %d does not exist \", msg->address);");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t\t");
            stringConcatenation2.append("break;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("return ET_TRUE;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String createLoggerCall(PortInstance pi, Message msg) {
        String string = null;
        EObject eObject = pi.eContainer();
        ActorInstance ai = (ActorInstance)eObject;
        String string2 = this._roomExtensions.getPathName(ai.getPath());
        String string3 = String.valueOf(string2) + ".";
        String string4 = pi.getName();
        String string5 = String.valueOf(string3) + string4;
        String string6 = String.valueOf(string5) + ".";
        String string7 = msg.getName();
        String data = String.valueOf(string6) + string7;
        LiteralType literalType = null;
        DataType dataType = msg.getData().getRefType().getType();
        if (dataType instanceof EnumerationType) {
            literalType = LiteralType.INT;
        } else {
            DataType dataType2 = msg.getData().getRefType().getType();
            literalType = ((PrimitiveType)dataType2).getType();
        }
        LiteralType type = literalType;
        String string8 = null;
        if (type != null) {
            switch (type) {
                case BOOL: {
                    string8 = "ET_DATA_LOGGER_LOG_BOOL((int)" + data + ")";
                    break;
                }
                case CHAR: {
                    string8 = "ET_DATA_LOGGER_LOG_INT((int)" + data + ")";
                    break;
                }
                case INT: {
                    string8 = "ET_DATA_LOGGER_LOG_INT((int)" + data + ")";
                    break;
                }
                case REAL: {
                    string8 = "ET_DATA_LOGGER_LOG_DOUBLE((double)" + data + ")";
                    break;
                }
            }
        }
        string = string8;
        return string;
    }

    private void checkDataPorts(SubSystemInstance comp) {
        HashSet<String> found = new HashSet<String>();
        EList eList = comp.getAllContainedInstances();
        for (ActorInstance ai : eList) {
            int thread = ai.getThreadId();
            EList eList2 = ai.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : eList2) {
                CommunicationType communicationType = pi.getProtocol().getCommType();
                boolean bl = Objects.equal((Object)communicationType, (Object)CommunicationType.DATA_DRIVEN);
                if (!bl) continue;
                EList eList3 = pi.getPeers();
                for (InterfaceItemInstance peer : eList3) {
                    boolean bl2;
                    EObject eObject = peer.eContainer();
                    ActorInstance peer_ai = (ActorInstance)eObject;
                    int peer_thread = peer_ai.getThreadId();
                    if (thread == peer_thread) continue;
                    String path = pi.getPath();
                    String ppath = peer.getPath();
                    String string = null;
                    int n = path.compareTo(ppath);
                    boolean bl3 = n < 0;
                    string = bl3 ? String.valueOf(path) + " and " + ppath : String.valueOf(ppath) + " and " + path;
                    String pair = string;
                    boolean bl4 = found.contains(pair);
                    boolean bl5 = bl2 = !bl4;
                    if (!bl2) continue;
                    found.add(pair);
                    this._cExtensions.diagnostician.error(String.valueOf(pair) + ": data ports placed on different threads (not supported yet)", (EObject)pi.getInterfaceItem(), pi.getInterfaceItem().eContainingFeature());
                }
            }
        }
    }

    public int getInterfaceAddress(InterfaceItemInstance pi, int baseAddress) {
        int n = pi.getObjId();
        return n + baseAddress;
    }

    public int getInterfaceAddress(InterfaceItemInstance pi, InterfaceItemInstance peer, int baseAddress) {
        int n = pi.getObjId();
        int n2 = pi.getPeers().indexOf((Object)peer);
        int n3 = n + n2;
        return n3 + baseAddress;
    }

    public CharSequence generateAddressMap(Root root, SubSystemInstance ssi, Collection<PhysicalThread> usedThreads) {
        int n;
        Object object;
        Object object2;
        StringConcatenation stringConcatenation = null;
        HashSet usedProtocols = CollectionLiterals.newHashSet();
        EList eList = ssi.getAllContainedInstances();
        for (ActorInstance ai : eList) {
            EList eList2 = ai.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : eList2) {
                usedProtocols.add(pi.getProtocol());
            }
        }
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("\"baseAddress\": \"");
        stringConcatenation2.append((Object)32, "\t");
        stringConcatenation2.append("\",");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("\"actorInstances\": [");
        stringConcatenation2.newLine();
        Iterator iterator = ssi.getAllContainedInstances();
        boolean bl = false;
        Object object3 = iterator.iterator();
        while (object3.hasNext()) {
            ActorInstance ai_1 = (ActorInstance)object3.next();
            if (!bl) {
                bl = true;
            } else {
                stringConcatenation2.appendImmediate((Object)",", "\t\t");
            }
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("{");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\"path\": \"");
            object2 = ai_1.getPath();
            stringConcatenation2.append((String)object2, "\t\t\t");
            stringConcatenation2.append("\",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\"threadName\": \"");
            object = ETMapUtil.getMappedThread((AbstractInstance)ai_1).getThread().getName();
            stringConcatenation2.append((String)object, "\t\t\t");
            stringConcatenation2.append("\",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\"obejctId\": \"");
            int n2 = ai_1.getObjId();
            stringConcatenation2.append((Object)n2, "\t\t\t");
            stringConcatenation2.append("\",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\"actorClass\": \"");
            String string = this._roomExtensions.getFullyQualifiedName((RoomClass)ai_1.getActorClass()).replace("_", ".");
            stringConcatenation2.append(string, "\t\t\t");
            stringConcatenation2.append("\",");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\"ports\": [");
            stringConcatenation2.newLine();
            EList eList3 = ai_1.getOrderedIfItemInstances();
            boolean bl2 = false;
            for (InterfaceItemInstance pi_1 : eList3) {
                if (!bl2) {
                    bl2 = true;
                } else {
                    stringConcatenation2.appendImmediate((Object)",", "\t\t\t\t");
                }
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("{");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\"name\": \"");
                String string2 = pi_1.getName();
                stringConcatenation2.append(string2, "\t\t\t\t\t");
                stringConcatenation2.append("\",");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\"objectId\": \"");
                int n3 = pi_1.getObjId();
                stringConcatenation2.append((Object)n3, "\t\t\t\t\t");
                stringConcatenation2.append("\",");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\"portBaseAddress\": ");
                n = this.getInterfaceAddress(pi_1, 32);
                stringConcatenation2.append((Object)n, "\t\t\t\t\t");
                stringConcatenation2.append(",");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\"connections\": [");
                stringConcatenation2.newLine();
                Object object4 = pi_1.getPeers();
                boolean bl3 = false;
                for (InterfaceItemInstance peer : object4) {
                    if (!bl3) {
                        bl3 = true;
                    } else {
                        stringConcatenation2.appendImmediate((Object)",", "\t\t\t\t\t\t");
                    }
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("{");
                    stringConcatenation2.newLine();
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\"index\": ");
                    int n4 = pi_1.getPeers().indexOf((Object)peer);
                    stringConcatenation2.append((Object)n4, "\t\t\t\t\t\t\t");
                    stringConcatenation2.append(",");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\"peerPortName\": \"");
                    String string3 = peer.getName();
                    stringConcatenation2.append(string3, "\t\t\t\t\t\t\t");
                    stringConcatenation2.append("\",");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\"peerPath\": \"");
                    String string4 = peer.getPath();
                    stringConcatenation2.append(string4, "\t\t\t\t\t\t\t");
                    stringConcatenation2.append("\",");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\"localAddress\": ");
                    int n5 = this.getInterfaceAddress(pi_1, peer, 32);
                    stringConcatenation2.append((Object)n5, "\t\t\t\t\t\t\t");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("}");
                    stringConcatenation2.newLine();
                }
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("],");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\"protocolClass\": \"");
                object4 = this._roomExtensions.getFullyQualifiedName((RoomClass)pi_1.getProtocol()).replace("_", ".");
                stringConcatenation2.append((String)object4, "\t\t\t\t\t");
                stringConcatenation2.append("\"");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("]");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("],");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("\"protocols\": {");
        stringConcatenation2.newLine();
        boolean bl4 = false;
        for (ProtocolClass protocol : usedProtocols) {
            if (!bl4) {
                bl4 = true;
            } else {
                stringConcatenation2.appendImmediate((Object)",", "\t\t");
            }
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\"");
            object3 = this._roomExtensions.getFullyQualifiedName((RoomClass)protocol).replace("_", ".");
            stringConcatenation2.append((String)object3, "\t\t");
            stringConcatenation2.append("\": {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\"messages\": [");
            stringConcatenation2.newLine();
            object2 = this._roomHelpers.getAllOutgoingMessages(protocol);
            object = this._roomHelpers.getAllIncomingMessages(protocol);
            Iterable iterable = IterableExtensions.indexed((Iterable)Iterables.concat((Iterable)object2, (Iterable)object));
            boolean bl5 = false;
            for (Pair it : iterable) {
                if (!bl5) {
                    bl5 = true;
                } else {
                    stringConcatenation2.appendImmediate((Object)",", "\t\t\t\t");
                }
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("{");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\"name\": \"");
                String string = ((Message)it.getValue()).getName();
                stringConcatenation2.append(string, "\t\t\t\t\t");
                stringConcatenation2.append("\",");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\"direction\": \"");
                Object object5 = null;
                boolean bl6 = this._roomHelpers.getAllIncomingMessages(protocol).contains(it.getValue());
                object5 = bl6 ? "incoming" : "outgoing";
                stringConcatenation2.append((String)object5, "\t\t\t\t\t");
                stringConcatenation2.append("\",");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\"evtId\": \"");
                Integer n6 = (Integer)it.getKey();
                n = n6 + 1;
                stringConcatenation2.append((Object)n, "\t\t\t\t\t");
                stringConcatenation2.append("\"");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("]");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String generateSubSystemUserCodes(SubSystemInstance ssi) {
        String string = null;
        Functions.Function1<ActorInstance, ActorClass> function1 = new Functions.Function1<ActorInstance, ActorClass>(){

            public ActorClass apply(ActorInstance it) {
                return it.getActorClass();
            }
        };
        Set acs = IterableExtensions.toSet((Iterable)ListExtensions.map((List)ssi.getAllContainedInstances(), (Functions.Function1)function1));
        Functions.Function1<ActorClass, Iterable<Annotation>> function12 = new Functions.Function1<ActorClass, Iterable<Annotation>>(){

            public Iterable<Annotation> apply(ActorClass it) {
                Functions.Function1<Annotation, Boolean> function1 = new Functions.Function1<Annotation, Boolean>(){

                    public Boolean apply(Annotation it) {
                        String string = it.getType().getName();
                        return Objects.equal((Object)string, (Object)"SubSystemUserCode");
                    }
                };
                return IterableExtensions.filter((Iterable)it.getAnnotations(), (Functions.Function1)function1);
            }
        };
        Iterable annotations = Iterables.concat((Iterable)IterableExtensions.map((Iterable)acs, (Functions.Function1)function12));
        Functions.Function1<Annotation, EList<KeyValue>> function13 = new Functions.Function1<Annotation, EList<KeyValue>>(){

            public EList<KeyValue> apply(Annotation it) {
                return it.getAttributes();
            }
        };
        Functions.Function1<KeyValue, Literal> function14 = new Functions.Function1<KeyValue, Literal>(){

            public Literal apply(KeyValue it) {
                return it.getValue();
            }
        };
        Functions.Function1<StringLiteral, String> function15 = new Functions.Function1<StringLiteral, String>(){

            public String apply(StringLiteral it) {
                return it.getValue();
            }
        };
        string = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)annotations, (Functions.Function1)function13)), (Functions.Function1)function14), StringLiteral.class), (Functions.Function1)function15), (CharSequence)this._roomExtensions.NEWLINE);
        return string;
    }
}

