/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.ReferenceType;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.util.Multiplicities;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class WiringValidator
extends AbstractDeclarativeValidator {
    @Inject
    RoomHelpers roomHelpers;
    public static final String MULTIPLICITY_ANY_REQUIRES_OPTIONAL = "multiplicity any [*] requires optional";
    public static final String ACTOR_REF_CHANGE_REF_TYPE_TO_OPTIONAL = "MultiplicityValidator.ActorRefChangeRefTypeToOptional";

    @Check
    public void checkDataDrivenPortMultiplicity(Port port) {
        if (port.getProtocol() instanceof ProtocolClass && port.getProtocol().getCommType() == CommunicationType.DATA_DRIVEN && port.getMultiplicity() != 1) {
            this.error("multiplicity must be 1 for data driven ports", (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
        }
    }

    @Check
    public void checkActorRefMultiplicity(ActorRef ref) {
        if (ref.getMultiplicity() == -1 && ref.getRefType() != ReferenceType.OPTIONAL) {
            this.error(MULTIPLICITY_ANY_REQUIRES_OPTIONAL, (EStructuralFeature)RoomPackage.eINSTANCE.getActorRef_RefType(), ACTOR_REF_CHANGE_REF_TYPE_TO_OPTIONAL, new String[0]);
        }
        if (ref.getMultiplicity() != 1) {
            ActorClass ac = ref.getType();
            if (this.getAll(ac, ActorClass::getInterfacePorts).anyMatch(port -> port.getMultiplicity() == -1)) {
                this.error("replicated actors must not have replicated ports with multiplicity any", null);
            }
            if (this.getAll(ac, ActorContainerClass::getServiceProvisionPoints).anyMatch(spp -> true)) {
                this.error("replicated actors must not have service provision points", null);
            }
        }
    }

    @Check
    public void checkLayerConnectionTarget(LayerConnection lc) {
        if (lc.getTo().getRef() instanceof ActorRef && ((ActorRef)lc.getTo().getRef()).getMultiplicity() > 1) {
            this.error("layer connection must not connect to replicated actor", null);
        }
    }

    @Check
    public void checkPortMultiplicities(LogicalSystem ls) {
        this.checkPortMultiplicities(ls.getBindings().stream(), Stream.empty());
    }

    @Check
    public void checkPortMultiplicities(SubSystemClass ssc) {
        this.checkPortMultiplicities(ssc.getBindings().stream(), ssc.getRelayPorts().stream());
    }

    @Check
    public void checkPortMultiplicities(ActorClass ac) {
        this.checkPortMultiplicities(this.getAll(ac, StructureClass::getBindings), ac.isAbstract() ? Stream.empty() : this.getAll(ac, ActorClass::getRelayPorts));
    }

    private void checkPortMultiplicities(Stream<Binding> bindings, Stream<Port> relays) {
        HashMap multiplicities = new HashMap();
        bindings.forEach(binding -> {
            EndPoint ep1 = new EndPoint(binding.getEndpoint1());
            EndPoint ep2 = new EndPoint(binding.getEndpoint2());
            int multiplicity = Multiplicities.minimum(this.getMultiplicity(ep1), this.getMultiplicity(ep2));
            multiplicities.merge(ep1, multiplicity, Multiplicities::plus);
            multiplicities.merge(ep2, multiplicity, Multiplicities::plus);
        });
        multiplicities.entrySet().forEach(entry -> {
            EndPoint ep = (EndPoint)entry.getKey();
            int multiplicity = this.getMultiplicity(ep);
            int calculated = (Integer)entry.getValue();
            if (Multiplicities.compare(calculated, multiplicity) > 0) {
                if (multiplicity == 1) {
                    this.warning("port \"" + ep.toString() + "\" is connected to more than one peer", (EStructuralFeature)RoomPackage.eINSTANCE.getRoomClass_Name());
                } else {
                    this.warning("port \"" + ep.toString() + "\" is connected to " + Multiplicities.toString(calculated) + " peers but its multiplicity is only " + Multiplicities.toString(multiplicity), (EStructuralFeature)RoomPackage.eINSTANCE.getRoomClass_Name());
                }
            }
        });
        relays.map(EndPoint::new).forEach(ep -> {
            int multiplicity = this.getMultiplicity((EndPoint)ep);
            int calculated = multiplicities.getOrDefault(ep, 0);
            if (Multiplicities.compare(calculated, multiplicity) < 0) {
                if (multiplicity == 1) {
                    this.warning("relay port \"" + ep.toString() + "\" is not connected", (EStructuralFeature)RoomPackage.eINSTANCE.getRoomClass_Name());
                } else {
                    this.warning("relay port \"" + ep.toString() + "\" is only connected to " + Multiplicities.toString(calculated) + " peers but its multiplicity is " + Multiplicities.toString(multiplicity), (EStructuralFeature)RoomPackage.eINSTANCE.getRoomClass_Name());
                }
            }
        });
    }

    private int getMultiplicity(EndPoint ep) {
        int multiplicator = ep.ref != null && ep.ref instanceof ActorRef ? ((ActorRef)ep.ref).getMultiplicity() : 1;
        return Multiplicities.times(multiplicator, ep.port.getMultiplicity());
    }

    private <T> Stream<T> getAll(ActorClass ac, Function<ActorClass, Collection<? extends T>> getter) {
        return this.roomHelpers.getClassHierarchy(ac).stream().flatMap(getter.andThen(Collection::stream));
    }

    public void register(EValidatorRegistrar registrar) {
    }

    private static class EndPoint {
        public final ActorContainerRef ref;
        public final Port port;

        public EndPoint(Port port) {
            this.ref = null;
            this.port = port;
        }

        public EndPoint(ActorContainerRef ref, Port port) {
            this.ref = ref;
            this.port = port;
        }

        public EndPoint(BindingEndPoint ep) {
            this(ep.getActorRef(), ep.getPort());
        }

        public String toString() {
            return this.ref == null ? this.port.getName() : String.valueOf(this.ref.getName()) + "." + this.port.getName();
        }

        public int hashCode() {
            return Objects.hash(this.port, this.ref);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EndPoint other = (EndPoint)obj;
            return Objects.equals(this.port, other.port) && Objects.equals(this.ref, other.ref);
        }
    }
}

