/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.base.util;

import org.eclipse.emf.common.util.URI;

public class RelativePathHelpers {
    private static boolean bothNullOrEqual(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static String getRelativePath(String base, String path) {
        return RelativePathHelpers.getRelativePath(URI.createFileURI((String)base), URI.createFileURI((String)path), false);
    }

    public static String getRelativePath(String base, String path, boolean goUpIfNeeded) {
        return RelativePathHelpers.getRelativePath(URI.createFileURI((String)base), URI.createFileURI((String)path), goUpIfNeeded);
    }

    public static String getRelativePath(URI base, URI path) {
        return RelativePathHelpers.getRelativePath(base, path, false);
    }

    public static String getRelativePath(URI base, URI path, boolean goUpIfNeeded) {
        if (base == null || path == null) {
            return null;
        }
        if (!RelativePathHelpers.bothNullOrEqual(base.scheme(), path.scheme())) {
            return null;
        }
        if (!base.hasAbsolutePath()) {
            return null;
        }
        if (!path.hasAbsolutePath()) {
            return null;
        }
        if (!RelativePathHelpers.bothNullOrEqual(path.device(), base.device())) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (goUpIfNeeded) {
            int max = base.segmentCount() < path.segmentCount() ? base.segmentCount() : path.segmentCount();
            int common = 0;
            while (common < max) {
                if (!base.segment(common).equals(path.segment(common))) break;
                ++common;
            }
            int i = common;
            while (i < base.segmentCount()) {
                result.append("../");
                ++i;
            }
            i = common;
            while (i < path.segmentCount()) {
                result.append(String.valueOf(path.segment(i)) + "/");
                ++i;
            }
            if (result.length() == 0) {
                return "";
            }
            return result.substring(0, result.length() - 1);
        }
        if (path.segmentCount() < base.segmentCount()) {
            return null;
        }
        int i = 0;
        while (i < base.segmentCount()) {
            if (!base.segment(i).equals(path.segment(i))) {
                return null;
            }
            ++i;
        }
        i = base.segmentCount();
        while (i < path.segmentCount()) {
            result.append(String.valueOf(path.segment(i)) + "/");
            ++i;
        }
        if (result.length() == 0) {
            return "";
        }
        return result.substring(0, result.length() - 1);
    }
}

