/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SAPInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ServiceImplInstance;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.fsm.generic.FSMExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class RoomExtensions
extends FSMExtensions {
    public final String NEWLINE = System.getProperty("line.separator");
    @Inject
    @Extension
    protected RoomHelpers _roomHelpers;

    public List<Port> punion(Iterable<Port> in1, Iterable<ExternalPort> in2) {
        final ArrayList<Port> ret = new ArrayList<Port>();
        Consumer<ExternalPort> consumer = new Consumer<ExternalPort>(){

            @Override
            public void accept(ExternalPort e) {
                ret.add(e.getInterfacePort());
            }
        };
        in2.forEach(consumer);
        Iterables.addAll(ret, in1);
        return ret;
    }

    public String getModelPath(EObject e) {
        Resource res = e.eResource();
        if (res == null) {
            return "";
        }
        return res.getURI().toFileString();
    }

    public String getPackage(RoomClass rc) {
        EObject eObject = rc.eContainer();
        return ((RoomModel)eObject).getName();
    }

    public String getFullyQualifiedName(RoomClass rc) {
        String string = this.getPackage(rc).replace(".", "_");
        String string2 = String.valueOf(string) + "_";
        String string3 = rc.getName();
        return String.valueOf(string2) + string3;
    }

    public String getPathFromPackage(String packageName) {
        String string = packageName.replaceAll("\\.", "/");
        return String.valueOf(string) + "/";
    }

    public String getPath(RoomClass rc) {
        return this.getPathFromPackage(this.getPackage(rc));
    }

    public String getPathName(String path) {
        return path.replaceAll("/", "_").replaceAll(":", "_");
    }

    protected String _getPortClassName(Port p) {
        String string = null;
        ProtocolClass protocolClass = p.getProtocol();
        if (protocolClass instanceof ProtocolClass) {
            ProtocolClass protocolClass2 = p.getProtocol();
            string = this.getPortClassName(protocolClass2, p.isConjugated(), p.isReplicated());
        } else {
            string = "";
        }
        return string;
    }

    protected String _getPortClassName(ExternalPort p) {
        return this.getPortClassName((RoomElement)p.getInterfacePort());
    }

    protected String _getPortClassName(SAP sap) {
        return this.getPortClassName(sap.getProtocol(), true);
    }

    protected String _getPortClassName(SPP spp) {
        return this.getPortClassName(spp.getProtocol(), false, true);
    }

    protected String _getPortClassName(ServiceImplementation svc) {
        return this.getPortClassName(svc.getSpp().getProtocol(), false, true);
    }

    public String getPortClassName(ProtocolClass p, boolean conj) {
        return this.getPortClassName(p, conj, false);
    }

    public String getPortClassName(ProtocolClass p, boolean conj, boolean repl) {
        String string = p.getName();
        String string2 = null;
        string2 = conj ? "Conj" : "";
        String string3 = String.valueOf(string) + string2;
        String string4 = null;
        string4 = repl ? "Repl" : "";
        String string5 = String.valueOf(string3) + string4;
        return String.valueOf(string5) + "Port";
    }

    public PortClass getPortClass(ProtocolClass pc, boolean conj) {
        if (conj) {
            return pc.getConjugated();
        }
        return pc.getRegular();
    }

    public List<PortClass> getAllPortClasses(ProtocolClass pc, boolean conj) {
        ArrayList result = CollectionLiterals.newArrayList();
        ProtocolClass protocol = pc;
        while (protocol != null) {
            boolean bl;
            PortClass portClass;
            if (conj) {
                portClass = protocol.getConjugated();
                boolean bl2 = bl = portClass != null;
                if (bl) {
                    result.add(protocol.getConjugated());
                }
            } else {
                portClass = protocol.getRegular();
                boolean bl3 = bl = portClass != null;
                if (bl) {
                    result.add(protocol.getRegular());
                }
            }
            protocol = protocol.getBase();
        }
        return result;
    }

    public boolean handlesSend(ProtocolClass pc, boolean conj) {
        boolean bl;
        PortClass portClass = this.getPortClass(pc, conj);
        boolean bl2 = bl = portClass == null;
        if (bl) {
            return false;
        }
        List allMessages = this._roomHelpers.getAllMessages(pc, conj);
        List<MessageHandler> list = RoomExtensions.getSafeList((List<MessageHandler>)this.getPortClass(pc, conj).getMsgHandlers());
        for (MessageHandler hdlr : list) {
            boolean bl3 = allMessages.contains(hdlr.getMsg());
            if (!bl3) continue;
            return true;
        }
        return false;
    }

    public boolean handlesReceive(ProtocolClass pc, boolean conj) {
        boolean bl;
        PortClass portClass = this.getPortClass(pc, conj);
        boolean bl2 = bl = portClass == null;
        if (bl) {
            return false;
        }
        List allMessages = this._roomHelpers.getAllMessages(pc, !conj);
        List<MessageHandler> list = RoomExtensions.getSafeList((List<MessageHandler>)this.getPortClass(pc, conj).getMsgHandlers());
        for (MessageHandler hdlr : list) {
            boolean bl3 = allMessages.contains(hdlr.getMsg());
            if (!bl3) continue;
            return true;
        }
        return false;
    }

    public boolean handlesReceiveIncludingSuper(ProtocolClass pc, boolean conj) {
        List<PortClass> allPortClasses = this.getAllPortClasses(pc, conj);
        List allMessages = this._roomHelpers.getAllMessages(pc, !conj);
        for (PortClass p : allPortClasses) {
            List<MessageHandler> list = RoomExtensions.getSafeList((List<MessageHandler>)p.getMsgHandlers());
            for (MessageHandler hdlr : list) {
                boolean bl = allMessages.contains(hdlr.getMsg());
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConjugated(InterfaceItemInstance iii) {
        if (iii instanceof PortInstance) {
            return ((PortInstance)iii).getPort().isConjugated();
        }
        if (iii instanceof SAPInstance) {
            return true;
        }
        if (iii instanceof ServiceImplInstance) {
            return false;
        }
        return false;
    }

    public List<MessageHandler> getReceiveHandlers(ProtocolClass pc, boolean conj) {
        boolean bl;
        ArrayList<MessageHandler> res = new ArrayList<MessageHandler>();
        PortClass portClass = this.getPortClass(pc, conj);
        boolean bl2 = bl = portClass != null;
        if (bl) {
            List allMessages = this._roomHelpers.getAllMessages(pc, !conj);
            List<MessageHandler> list = RoomExtensions.getSafeList((List<MessageHandler>)this.getPortClass(pc, conj).getMsgHandlers());
            for (MessageHandler hdlr : list) {
                boolean bl3 = allMessages.contains(hdlr.getMsg());
                if (!bl3) continue;
                res.add(hdlr);
            }
        }
        return res;
    }

    public List<MessageHandler> getReceiveHandlersIncludingSuper(ProtocolClass pc, boolean conj) {
        ArrayList<MessageHandler> res = new ArrayList<MessageHandler>();
        List<PortClass> allPortClasses = this.getAllPortClasses(pc, conj);
        List allMsgs = this._roomHelpers.getAllMessages(pc, !conj);
        for (PortClass p : allPortClasses) {
            List<MessageHandler> list = RoomExtensions.getSafeList((List<MessageHandler>)p.getMsgHandlers());
            for (MessageHandler hdlr : list) {
                boolean bl = allMsgs.contains(hdlr.getMsg());
                if (!bl) continue;
                res.add(hdlr);
            }
        }
        return res;
    }

    public List<MessageHandler> getSendHandlers(ProtocolClass pc, boolean conj) {
        boolean bl;
        PortClass portClass = this.getPortClass(pc, conj);
        boolean bl2 = bl = portClass == null;
        if (bl) {
            return Collections.emptyList();
        }
        ArrayList<MessageHandler> res = new ArrayList<MessageHandler>();
        List allMessages = this._roomHelpers.getAllMessages(pc, conj);
        List<MessageHandler> list = RoomExtensions.getSafeList((List<MessageHandler>)this.getPortClass(pc, conj).getMsgHandlers());
        for (MessageHandler hdlr : list) {
            boolean bl3 = allMessages.contains(hdlr.getMsg());
            if (!bl3) continue;
            res.add(hdlr);
        }
        return res;
    }

    public MessageHandler getSendHandler(final Message m, boolean conj) {
        EObject eObject = m.eContainer();
        Functions.Function1<MessageHandler, Boolean> function1 = new Functions.Function1<MessageHandler, Boolean>(){

            public Boolean apply(MessageHandler e) {
                Message message = e.getMsg();
                return Objects.equal((Object)message, (Object)m);
            }
        };
        return (MessageHandler)IterableExtensions.findFirst(this.getSendHandlers((ProtocolClass)eObject, conj), (Functions.Function1)function1);
    }

    public boolean isIncoming(Message m) {
        EObject eObject = m.eContainer();
        return this._roomHelpers.getAllIncomingMessages((ProtocolClass)eObject).contains(m);
    }

    public String getCodeName(Message m) {
        boolean bl = this.isIncoming(m);
        if (bl) {
            String string = m.getName();
            return "IN_" + string;
        }
        String string = m.getName();
        return "OUT_" + string;
    }

    public boolean overridesStop(ActorClass ac) {
        return IterableExtensions.exists((Iterable)ac.getOperations(), (Functions.Function1)new Functions.Function1<StandardOperation, Boolean>(){

            public Boolean apply(StandardOperation e) {
                return Objects.equal((Object)e.getName(), (Object)"stop") && e.getArguments().isEmpty() && e.getReturnType() == null;
            }
        }) || ac.getActorBase() != null && this.overridesStop(ac.getActorBase());
    }

    public BasicEList<AbstractInstance> getAllSubInstances(StructureInstance ssi) {
        BasicEList result = new BasicEList();
        TreeIterator it = ssi.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof AbstractInstance)) continue;
            result.add((Object)((AbstractInstance)obj));
        }
        return result;
    }

    public static List<MessageHandler> getSafeList(List<MessageHandler> msgHandlers) {
        List<Object> list = null;
        list = msgHandlers == null ? Collections.emptyList() : msgHandlers;
        return list;
    }

    public String getPortClassName(RoomElement p) {
        if (p instanceof Port) {
            return this._getPortClassName((Port)p);
        }
        if (p instanceof SAP) {
            return this._getPortClassName((SAP)p);
        }
        if (p instanceof SPP) {
            return this._getPortClassName((SPP)p);
        }
        if (p instanceof ExternalPort) {
            return this._getPortClassName((ExternalPort)p);
        }
        if (p instanceof ServiceImplementation) {
            return this._getPortClassName((ServiceImplementation)p);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(p).toString());
    }
}

